/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.drivers;

import au.com.ordermate.persistence.Displayable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.Lockable;
import ordermate.database.sales.Account;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import waitermate.gui.dialogs.UnlockDialog;

public class AccountSelectionPanel<T extends Account>
extends JPanel {
    private DataScrollPaneModel model;
    private Renderer<? super Component, T> renderer;
    private List<T> sortedAccounts;
    private CustomScrollPane accountsPane;
    private Comparator defaultComparator;

    public AccountSelectionPanel(Renderer<? super Component, T> yourRenderer, Comparator yourComparator) {
        super(new BorderLayout());
        this.renderer = yourRenderer;
        this.defaultComparator = yourComparator;
        this.setupComponents();
    }

    private void setupComponents() {
        this.model = new DataScrollPaneModel(4, 5);
        this.accountsPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.add((Component)this.accountsPane, "Center");
    }

    private List<CustomToggleButton<T>> createToggleButtons(List<T> selectedAccounts) {
        ArrayList<CustomToggleButton<T>> buttons = new ArrayList<CustomToggleButton<T>>();
        for (Account nextAccount : this.sortedAccounts) {
            final CustomToggleButton button = new CustomToggleButton((Displayable)nextAccount);
            try {
                this.renderer.setupComponent((Component)button, (Object)nextAccount, 0);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error setting up account component.", (Throwable)ex);
            }
            button.addActionListener((ActionListener)this.model);
            button.setSelected(selectedAccounts.contains(nextAccount));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (button.getData() instanceof PhoneAccount) {
                        PhoneAccount account = (PhoneAccount)button.getData();
                        if (button.isSelected() && account.isLocked()) {
                            new UnlockDialog().displayLockInfo((Lockable)account, account.getLabel());
                            button.setSelected(false);
                        }
                    }
                }
            });
            buttons.add(button);
        }
        return buttons;
    }

    public void setAccounts(List<T> accounts) {
        this.sortedAccounts = new ArrayList<T>(accounts);
        this.model.setButtons(this.createToggleButtons(new ArrayList()));
        this.setSortAccounts(this.defaultComparator);
    }

    public void dropAccounts() {
        this.sortedAccounts.clear();
        this.model.setButtons(Collections.emptyList());
    }

    void setSortAccounts(Comparator<T> comparator) {
        List<T> selectedAccounts = this.getSelectedAccounts();
        Collections.sort(this.sortedAccounts, comparator);
        List<CustomToggleButton<T>> buttons = this.createToggleButtons(selectedAccounts);
        this.model.setButtons(buttons);
        this.validate();
        this.repaint();
    }

    public List<T> getSelectedAccounts() {
        ArrayList<Displayable> selectedAccounts = new ArrayList<Displayable>();
        for (Object nextButton : this.model.getButtons()) {
            CustomToggleButton toggleButton = (CustomToggleButton)nextButton;
            if (!toggleButton.isSelected()) continue;
            selectedAccounts.add(toggleButton.getData());
        }
        return selectedAccounts;
    }
}

