/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.drivers;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class AutoAssignDriverSelector {
    private static AutoAssignDriverSelector instance;
    private DataScrollPaneModel model;
    private User currentDriver;
    private final User dudUser = new User(){

        public void save() {
            throw new IllegalStateException("Cannot save a Dummy User");
        }
    };

    public static AutoAssignDriverSelector getInstance() {
        if (instance == null) {
            instance = new AutoAssignDriverSelector();
        }
        return instance;
    }

    private AutoAssignDriverSelector() {
        this.dudUser.setFirstName("None");
        this.dudUser.setLastName("");
        this.reset();
    }

    public void checkAutoAssignedUser(User user) {
        if (user.isAutoAssign() && user.getDriverTrackingId() == null && !user.isClockedOn()) {
            Dialogs.displayOkDialog((String)"This user is set to be the Auto-Assigned, but is now clocked off.\r\n\r\nThis will now clear the auto-assigned driver.", (String)"Clearing Auto-Assign");
            user.setAutoAssign(false);
            user.save();
        }
    }

    public User selectUserToAssign() {
        List selected;
        this.model = new DataScrollPaneModel(3, 6);
        ArrayList<User> clockedOnUsers = new ArrayList<User>();
        clockedOnUsers.add(this.dudUser);
        List activeUsers = PersistenceManager.getObjectList(User.class, (String)Query.select(User.class).active(User.class).equals(User.Properties.DRIVER, (Object)Boolean.TRUE).orderBy(User.Properties.AUTO_ASSIGN, true).orderBy(User.Properties.DRIVER_TRACKING, true).orderBy(User.Properties.LAST_LOGIN, true).orderBy(User.Properties.FIRST_NAME, false).toString());
        for (User user : activeUsers) {
            if (!user.isClockedOn() && user.getDriverTrackingId() == null) continue;
            clockedOnUsers.add(user);
        }
        this.model.setItems(clockedOnUsers, true, true, false);
        PopupWindow window = new PopupWindow(false);
        window.setCancelButtonText("Cancel");
        window.setComponent((JComponent)new CustomScrollPane((CustomScrollPaneModel)this.model));
        window.startFillTheFrame();
        if (window.getResult() && (selected = this.model.getSelections()) != null && !selected.isEmpty()) {
            this.currentDriver = (User)selected.get(selected.size() - 1);
        }
        return this.currentDriver;
    }

    public void setAutoAssign() {
        this.selectUserToAssign();
        if (this.currentDriver != null) {
            User oldUser = this.getCurrentAutoAssign();
            if (oldUser != null && !oldUser.equals((Object)this.getSelectedDriver())) {
                oldUser.setAutoAssign(false);
                oldUser.save();
            }
            if (this.getSelectedDriver() != null) {
                this.currentDriver.setAutoAssign(true);
                this.currentDriver.save();
            }
        }
    }

    public User getCurrentAutoAssign() {
        return (User)PersistenceManager.getObject(User.class, (String)Query.select(User.class).active(User.class).equals(User.Properties.AUTO_ASSIGN, 1.0).orderBy(User.Properties.LAST_LOGIN, true).toString());
    }

    public User getSelectedDriver() {
        return this.currentDriver == this.dudUser ? null : this.currentDriver;
    }

    public void reset() {
        this.currentDriver = this.getCurrentAutoAssign();
        if (this.currentDriver == null) {
            this.currentDriver = this.dudUser;
        }
    }
}

