/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.drivers;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.Account;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXPanel;
import waitermate.gui.displayitems.DeliveryAccountItemRenderer;

public class DriversScreenPanel
extends JPanel {
    private CustomScrollPane accountsPane;
    private RendererScrollPaneModel accounts;
    private DataScrollPaneModel drivers;
    private JLabel deliveryInfo;
    private User selectedDriver;
    private List theCurrentDrivers;
    public final Signal buttonClicked = Signals.createSignal();
    public final Signal<Account, ?, ?, ?, ?> accountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    public final Signal<Account, ?, ?, ?, ?> deleteClicked = Signals.createSignal(Account.class, (String)"theAccount");

    public DriversScreenPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(8, 10)));
        DeliveryAccountItemRenderer renderer = new DeliveryAccountItemRenderer();
        this.accounts = new RendererScrollPaneModel((Renderer)renderer, 1, 6);
        this.accountsPane = new CustomScrollPane((CustomScrollPaneModel)this.accounts);
        this.deliveryInfo = new JLabel("");
        this.drivers = new DataScrollPaneModel(1, 8);
        CustomScrollPane driversPane = new CustomScrollPane((CustomScrollPaneModel)this.drivers);
        driversPane.setEmptyMessage("<html><p align='center'>There are no drivers<br>clocked on</html>");
        JXPanel panel = new JXPanel((LayoutManager)new BorderLayout());
        panel.add((Component)driversPane, (Object)"Center");
        StandardSecurityDecorator driversPaneDec = new StandardSecurityDecorator((JComponent)panel, AllPermissions.ASSIGN_DELIVERY_TO_OTHERS);
        JPanel deliveryPanel = new JPanel();
        deliveryPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(8, 10)));
        deliveryPanel.setBorder(BorderFactory.createTitledBorder("Delivery Details"));
        deliveryPanel.add((Component)this.deliveryInfo, new Rectangle(1, 9, 7, 1));
        deliveryPanel.add((Component)this.accountsPane, new Rectangle(0, 0, 8, 9));
        this.add((Component)deliveryPanel, new Rectangle(2, 0, 6, 10));
        this.add((Component)driversPaneDec, new Rectangle(0, 0, 2, 10));
        renderer.account.connect((Object)this, "gotAccountSelected");
        renderer.delete.connect((Object)this, "gotDelete");
        this.drivers.objectSelected.connect((Object)this, "gotDriver");
        this.selectedDriver = null;
    }

    void gotAccountSelected(Account selectedAccount) {
        this.accountSelected.emit((Object)selectedAccount);
    }

    void gotDelete(Account selected) {
        this.deleteClicked.emit((Object)selected);
    }

    void gotDriver(Displayable info) {
        this.selectedDriver = (User)info;
        this.buttonClicked.emit();
    }

    public void setData(List newData) {
        this.accounts.setObjects(newData);
    }

    public void setDrivers(List theDrivers) {
        this.theCurrentDrivers = theDrivers;
        this.drivers.setItems(this.theCurrentDrivers, true, true, true);
    }

    public User getSelectedDriver() {
        return this.selectedDriver;
    }

    public void setSelectedDriver(User theDriver) {
        this.selectedDriver = theDriver;
        this.drivers.selectButton((Displayable)theDriver);
    }

    public void setDeliveryInfo(String info) {
        this.deliveryInfo.setText("<html><h3>    " + info + "<html></h3>");
    }

    public boolean hasDrivers() {
        if (this.theCurrentDrivers == null) {
            return false;
        }
        return !this.theCurrentDrivers.isEmpty();
    }

    public User getFirstDriverInt() {
        if (this.hasDrivers()) {
            this.selectedDriver = (User)this.theCurrentDrivers.get(0);
            return this.selectedDriver;
        }
        return null;
    }

    public boolean hasDriver(User user) {
        return this.theCurrentDrivers.contains(user);
    }
}

