/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.settle;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.screens.selectaccount.phone.settle.DeliveredAccountsRenderer;

class SettleDeliveryAccountsGui
extends JPanel {
    private CustomScrollPane scrollPane;
    private RendererScrollPaneModel model;
    private JLabel driverLabel;
    private JLabel pricesLabel;
    private JLabel numDeliveriesLabel;
    private User theDriver;
    private Price selectedAccountsTotal = Price.ZERO_DOLLAR;
    private Price selectedAccountsFeeTotal = Price.ZERO_DOLLAR;
    private DeliveredAccountsRenderer renderer = new DeliveredAccountsRenderer();

    public SettleDeliveryAccountsGui() {
        this.model = new RendererScrollPaneModel((Renderer)this.renderer, 1, 5);
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.renderer.accountSelected.connect((Object)this, "gotAccountSelected");
        this.driverLabel = new JLabel("");
        this.driverLabel.setFont(OrderMateTheme.getLargeFont());
        this.pricesLabel = new JLabel("");
        this.numDeliveriesLabel = new JLabel("");
        JLabel infoLabel = new JLabel("<html>Total Unsettled Items: <br>Total Unsettled Delivery Fees: <br>Float: <br><h2>Total Cash On Hand: </h2>");
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        this.add((Component)this.driverLabel, new Rectangle(1, 0, 9, 1));
        this.add((Component)this.scrollPane, new Rectangle(1, 1, 8, 6));
        this.add((Component)infoLabel, new Rectangle(5, 7, 3, 4));
        this.add((Component)this.pricesLabel, new Rectangle(8, 7, 1, 4));
        this.add((Component)this.numDeliveriesLabel, new Rectangle(1, 9, 4, 1));
    }

    public void displayAccounts(List<PhoneAccount> accounts, User driver) {
        double accountTotal = 0.0;
        double feeTotal = 0.0;
        for (PhoneAccount account : accounts) {
            if (!account.isDeliverable() || !account.isDelivered()) {
                throw new IllegalArgumentException("All accounts must be delivered!");
            }
            accountTotal += account.getDue().doubleValue();
            if (!(account.getDue().doubleValue() > 0.0)) continue;
            feeTotal += account.getDeliveryFee().doubleValue();
        }
        this.driverLabel.setText("Unsettled Delivery Accounts for " + driver.getName());
        this.renderer.setSelectedAccounts(accounts);
        this.model.setObjects(accounts);
        this.theDriver = driver;
        this.selectedAccountsTotal = new Price(accountTotal, 0.01);
        this.selectedAccountsFeeTotal = new Price(feeTotal, 0.01);
        this.setPricesLabel();
    }

    public void gotAccountSelected(PhoneAccount account, Boolean selected) {
        if (selected != null && selected.booleanValue()) {
            this.selectedAccountsTotal = this.selectedAccountsTotal.add(account.getDue());
            if (account.getDue().doubleValue() > 0.0) {
                this.selectedAccountsFeeTotal = this.selectedAccountsFeeTotal.add(account.getDeliveryFee());
            }
        } else {
            this.selectedAccountsTotal = this.selectedAccountsTotal.subtract(account.getDue());
            if (account.getDue().doubleValue() > 0.0) {
                this.selectedAccountsFeeTotal = this.selectedAccountsFeeTotal.subtract(account.getDeliveryFee());
            }
        }
        this.setPricesLabel();
    }

    private void setPricesLabel() {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.append(this.selectedAccountsTotal.subtract(this.selectedAccountsFeeTotal).toString());
        htmlBuilder.appendLineBreak();
        htmlBuilder.append(this.selectedAccountsFeeTotal.toString());
        htmlBuilder.appendLineBreak();
        htmlBuilder.append(this.theDriver.getFloatAmount().toString());
        htmlBuilder.appendLineBreak();
        htmlBuilder.appendTextWithHeading(this.selectedAccountsTotal.add(this.theDriver.getFloatAmount()).toString(), 2);
        this.pricesLabel.setText(htmlBuilder.toString());
    }

    public Set<PhoneAccount> getSelectedAccounts() {
        return Collections.unmodifiableSet(this.renderer.getSelectedAccounts());
    }

    public void cleanUp() {
        this.theDriver = null;
        this.selectedAccountsTotal = Price.ZERO_DOLLAR;
        this.selectedAccountsFeeTotal = Price.ZERO_DOLLAR;
        this.renderer.cleanUp();
    }
}

