/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.SalesLineItem;

public class BistroModeHelper {
    private List<SalesLineItem> currentSaleLineItems;

    public BistroModeHelper(List<SalesLineItem> currentSaleLineItems) {
        this.currentSaleLineItems = currentSaleLineItems;
    }

    public BistroModeHelper() {
    }

    public List<SalesLineItem> getCurrentSaleLineItems() {
        return this.currentSaleLineItems;
    }

    public void setCurrentSaleLineItems(List<SalesLineItem> currentSaleLineItems) {
        this.currentSaleLineItems = currentSaleLineItems;
    }

    Price calculateCurrentTotal() {
        Price total = new Price(0.0, 0.01);
        for (SalesLineItem salesLineItem : this.currentSaleLineItems) {
            total = total.add(salesLineItem.getPrice());
        }
        return total;
    }

    Price calculateCurrentPaid(FinanceTransaction cashTransaction) {
        Price paid = cashTransaction != null ? cashTransaction.getPaid() : this.getPaid(cashTransaction);
        return paid;
    }

    Price getPaid(FinanceTransaction cashTransaction) {
        Price paid = new Price(0.0, 0.01);
        if (!this.currentSaleLineItems.isEmpty()) {
            List financeTransactions = this.currentSaleLineItems.get(0).getAccount().getFinanceTransactions();
            for (FinanceTransaction financeTransaction : financeTransactions) {
                if (financeTransaction == cashTransaction) continue;
                paid = paid.add(financeTransaction.getPaid());
            }
        }
        return paid;
    }

    Price calculateCurrentCashPaid() {
        Price paid = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        if (!this.currentSaleLineItems.isEmpty()) {
            List financeTransactions = this.currentSaleLineItems.get(0).getAccount().getFinanceTransactions();
            for (FinanceTransaction financeTransaction : financeTransactions) {
                if (!(financeTransaction instanceof CashTransaction)) continue;
                paid = paid.add(financeTransaction.getPaid());
            }
        }
        return paid;
    }

    Price calculateCurrentTendered() {
        Price tendered = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        if (!this.currentSaleLineItems.isEmpty()) {
            List financeTransactions = this.currentSaleLineItems.get(0).getFinanceTransactions();
            for (FinanceTransaction financeTransaction : financeTransactions) {
                if (!(financeTransaction instanceof CashTransaction)) continue;
                tendered = tendered.add(financeTransaction.getTendered());
            }
        }
        return tendered;
    }
}

