/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.border.BevelBorder;
import ordermate.database.hardware.QuickSaleButtonId;
import ordermate.database.hardware.QuickSaleNavConfig;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.Permission;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import waitermate.gui.screens.selectaccount.quicksale.QuickSaleNav;
import waitermate.guikit.ScreenResource;

class ButtonParams {
    private String icon;
    private String text;
    private String name;
    private AbstractButton button;
    private Permission permission;
    private QuickSaleButtonId buttonId;
    private Signal signal;
    private QuickSaleNav navBar;

    public ButtonParams(QuickSaleNav navBar) {
        this.navBar = navBar;
    }

    public ButtonParams signal(Signal sig) {
        this.signal = sig;
        return this;
    }

    public ButtonParams button(AbstractButton jbutton) {
        this.button = jbutton;
        return this;
    }

    public AbstractButton getButton() {
        QuickSaleNavConfig navConfig = Terminal.getLocalHost().getQuickSaleNavConfig();
        if (this.button == null) {
            this.button = this.navBar.constructButton(IconLoader.get((String)this.getIcon()), this.getText(), this.getName(), this.navBar.getButtonInsets(), this.getSignal());
        } else if (this.getSignal() != null) {
            final Signal sig = this.getSignal();
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sig.emit();
                }
            });
        }
        this.button.setFont(OrderMateTheme.getSmallerFont());
        int width = Terminal.getLocalHost().getQuickSaleNavConfig().getButtonWidth().getPixelWidth();
        int minHeight = 75;
        int height = ScreenResource.getNavHeight() / navConfig.getRowsPerPage();
        this.button.setPreferredSize(new Dimension(width, height));
        this.button.setBorder(new BevelBorder(0));
        return this.button;
    }

    public Signal getSignal() {
        return this.signal;
    }

    public ButtonParams icon(String newIcon) {
        this.icon = newIcon;
        return this;
    }

    public ButtonParams name(String newName) {
        this.name = newName;
        return this;
    }

    public ButtonParams text(String newText) {
        this.text = newText;
        return this;
    }

    public ButtonParams permission(Permission perm) {
        this.permission = perm;
        return this;
    }

    public ButtonParams buttonId(QuickSaleButtonId id) {
        this.buttonId = id;
        return this;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public QuickSaleButtonId getButtonId() {
        return this.buttonId;
    }
}

