/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.FinanceInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class GuiFinanceInfo
extends JPanel
implements ActionListener,
FinanceInfo {
    public final Signal clearTendered = Signals.createSignal();
    public final Signal resyncPoints = Signals.createSignal();
    private JLabel totalLabel;
    private JLabel paidLabel;
    private JLabel changeLabel;
    private JLabel tenderedLabel;
    private JLabel remainingLabel;
    private JLabel surchargeLabel;
    private JLabel discountLabel;
    private JLabel orderInfoLabel;
    private JButton resetButton;
    private JButton resyncPointsButton;

    public GuiFinanceInfo() {
        super(new BorderLayout());
        this.setBackground(new Color(240, 240, 240));
        JPanel leftPanel = new JPanel(new FlowLayout(0));
        leftPanel.setOpaque(false);
        this.resetButton = new JButton("");
        this.resetButton.setName("resetButton");
        this.resetButton.setIcon(IconLoader.get((String)"/waitermate/images/clearSmall.png"));
        this.resetButton.addActionListener(this);
        leftPanel.add(this.resetButton);
        this.totalLabel = new JLabel();
        this.totalLabel.setName("totalLabel");
        leftPanel.add(this.totalLabel);
        this.paidLabel = new JLabel();
        this.paidLabel.setName("paidLabel");
        leftPanel.add(this.paidLabel);
        this.tenderedLabel = new JLabel();
        this.tenderedLabel.setName("tenderedLabel");
        leftPanel.add(this.tenderedLabel);
        this.changeLabel = new JLabel();
        this.changeLabel.setName("changeLabel");
        leftPanel.add(this.changeLabel);
        this.remainingLabel = new JLabel();
        this.remainingLabel.setName("remainingBalanceLabel");
        leftPanel.add(this.remainingLabel);
        this.add((Component)leftPanel, "West");
        JPanel rightPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(7, 2)));
        rightPanel.setOpaque(false);
        this.surchargeLabel = new JLabel();
        rightPanel.add((Component)this.surchargeLabel, new Rectangle(0, 0, 2, 1));
        this.discountLabel = new JLabel();
        rightPanel.add((Component)this.discountLabel, new Rectangle(0, 1, 2, 1));
        this.orderInfoLabel = new JLabel();
        rightPanel.add((Component)this.orderInfoLabel, new Rectangle(4, 0, 2, 2));
        this.resyncPointsButton = new JButton("");
        this.resyncPointsButton.setName("resyncPoints");
        this.resyncPointsButton.setIcon(IconLoader.get((String)"/waitermate/images/loyalty.png"));
        this.resyncPointsButton.addActionListener(this);
        rightPanel.add((Component)this.resyncPointsButton, new Rectangle(6, 0, 1, 2));
        this.add((Component)rightPanel, "East");
    }

    public void setFinanceInfo(Price total, Price due, Price paid, Price tendered, Price change, Price remaining) {
        if (due != null && !due.isZero() && !paid.isZero()) {
            this.totalLabel.setText(this.htmlAmountText(Internationalization.getLiteralFor((String)"DUE"), due, false));
        } else {
            this.totalLabel.setText(this.htmlAmountText(this.getTotalString(), total, false));
        }
        this.paidLabel.setText(this.htmlAmountText(Internationalization.getLiteralFor((String)"PAID"), paid, false));
        if (tendered.isZero()) {
            this.tenderedLabel.setVisible(false);
        } else {
            this.tenderedLabel.setText(this.htmlAmountText(Internationalization.getLiteralFor((String)"TENDERED"), tendered, false));
            this.tenderedLabel.setVisible(true);
        }
        if (change.isZero()) {
            this.changeLabel.setVisible(false);
        } else {
            this.changeLabel.setText(this.htmlAmountText(Internationalization.getLiteralFor((String)"CHANGE"), change, true));
            this.changeLabel.setVisible(true);
        }
        if (remaining == null) {
            this.remainingLabel.setVisible(false);
        } else {
            this.remainingLabel.setText(this.htmlAmountText(Internationalization.getLiteralFor((String)"REMAINING_BALANCE"), remaining, false));
            this.remainingLabel.setVisible(true);
        }
    }

    private String getTotalString() {
        return SystemProperty.getInstance().isExTax() ? Internationalization.getLiteralFor((String)"TOTAL_INC_TAX") : Internationalization.getLiteralFor((String)"TOTAL");
    }

    private String htmlAmountText(String name, Price amount, boolean red) {
        String text = name + ":";
        StringBuilder sb = new StringBuilder("");
        if (red) {
            sb.append(HtmlUtils.highlight((String)text, (String)"RED", (boolean)false, (boolean)false, (int)4));
            sb.append(HtmlUtils.highlight((String)amount.toString(), (String)"RED", (boolean)false, (boolean)false, (int)6));
        } else {
            sb.append(HtmlUtils.fontSize((String)text, (int)4));
            sb.append(HtmlUtils.fontSize((String)amount.toString(), (int)6));
        }
        return HtmlUtils.htmlCenter((String)sb.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resetButton) {
            this.clearTendered.emit();
        } else if (e.getSource() == this.resyncPointsButton) {
            this.resyncPoints.emit();
        }
    }

    public void setSyncEnabled(boolean value) {
        this.resyncPointsButton.setEnabled(value);
    }

    public void setOrderInfo(List orderInfo) {
        if (orderInfo.size() == 0) {
            this.orderInfoLabel.setVisible(false);
        } else {
            StringBuffer buffer = new StringBuffer("<HTML><LEFT><FONT SIZE=4>");
            orderInfo.iterator();
            for (int i = 0; i < orderInfo.size(); ++i) {
                buffer.append(orderInfo.get(i));
                if (i == 0 && orderInfo.size() > 1) {
                    buffer.append(",<br/> ");
                    continue;
                }
                if (i >= orderInfo.size() - 1) continue;
                buffer.append(", ");
            }
            buffer.append("</FONT></HTML>");
            this.orderInfoLabel.setText(buffer.toString());
            this.orderInfoLabel.setVisible(true);
        }
    }

    public void setDiscountAndSurcharge(String discount, String surcharge) {
        if (surcharge != null) {
            this.surchargeLabel.setText(Internationalization.getLiteralFor((String)"SUR") + ": " + surcharge);
            this.surchargeLabel.setVisible(true);
        } else {
            this.surchargeLabel.setText(Internationalization.getLiteralFor((String)"SUR") + ": ");
            this.surchargeLabel.setVisible(false);
        }
        if (discount != null) {
            this.discountLabel.setText(Internationalization.getLiteralFor((String)"DIS") + ": " + discount);
            this.discountLabel.setVisible(true);
        } else {
            this.discountLabel.setText(Internationalization.getLiteralFor((String)"DIS") + ": ");
            this.discountLabel.setVisible(false);
        }
    }
}

