/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.glazedlists.PropertyAccessorComparator;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.action.ActionManager;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.Payable;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.finance.ChangeCalculator;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.FinanceInfo;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.VoucherTransactionHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TicketDataConfig;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.integration.webpayment.WebPaymentType;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.coupon.CouponHandlerFactory;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.action.ActionFireOn;
import ordermate.database.misc.enums.ItemBarcodeType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.CustomerUpdateManager;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.stock.StockUtilities;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.SaveAccount;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.integration.loyalty.LoyaltyResyncTask;
import ordermate.integration.videopro.CCTVIntegration;
import ordermate.internationalization.Internationalization;
import ordermate.services.finance.transactions.FinanceTransactionFactory;
import ordermate.services.hardware.physical.eftpos.CashDrawerManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.WaiterMateUpdater;
import waitermate.gui.WaitermateAccountGui;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.additems.search.InventoryItemSearchPanel;
import waitermate.gui.customerdisplay.WaiterMateCustomerDisplay;
import waitermate.gui.dialogs.AutoComboSelector;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.ClosedAccountItemSignals;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.ClosedAccountItems;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.gui.screens.debtor.components.DebtorPaymentProcessor;
import waitermate.gui.screens.discount.DiscountGuiUtils;
import waitermate.gui.screens.ordering.VoucherTransactionReturner;
import waitermate.gui.screens.ordering.accountadmin.AccountAdmin;
import waitermate.gui.screens.ordering.additems.AddItems;
import waitermate.gui.screens.ordering.additems.OrderedItemDetails;
import waitermate.gui.screens.ordering.additems.UpgradeCombo;
import waitermate.gui.screens.ordering.coupon.WaiterMateCoupons;
import waitermate.gui.screens.ordering.coupon.handlers.WaiterMateCouponHandlerFactory;
import waitermate.gui.screens.ordering.giftvoucher.WaiterMateGiftVouchers;
import waitermate.gui.screens.ordering.modifyitem.ModifyItem;
import waitermate.gui.screens.ordering.saveaccount.WaiterMateTicketData;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.transferitems.TransferItems;
import waitermate.gui.screens.payment.Payments;
import waitermate.gui.screens.payment.cashtransaction.DenominationPopup;
import waitermate.gui.screens.payment.debtorTransaction.DebtorTransaction;
import waitermate.gui.screens.payment.eftpos.EftposController;
import waitermate.gui.screens.payment.loyaltytransaction.LoyaltyRedemptionScreen;
import waitermate.gui.screens.payment.selectadjustment.DiscountReasonPopup;
import waitermate.gui.screens.payment.selectadjustment.SelectPriceAdjustment;
import waitermate.gui.screens.payment.tabtransaction.TabTransactionScreen;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.payment.transactions.DebtorSaleHandler;
import waitermate.gui.screens.payment.voucher.VoucherPayment;
import waitermate.gui.screens.selectaccount.AbstractAccountSelection;
import waitermate.gui.screens.selectaccount.quicksale.BistroModeHelper;
import waitermate.gui.screens.selectaccount.quicksale.ConfirmFinanceUnit;
import waitermate.gui.screens.selectaccount.quicksale.QuickSaleNav;
import waitermate.gui.screens.selectaccount.quicksale.QuickSalePanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.guikit.showitem.ShowItemsUtils;
import waitermate.webpayment.WaitermateWebPayment;

public class QuickSale
extends AbstractAccountSelection {
    private boolean inBistroMode = false;
    private boolean gotPayDone = false;
    private BistroModeHelper bistroModeHelper;
    private List<SalesLineItem> currentSaleLineItems = new ArrayList<SalesLineItem>();
    public final Signal<?, ?, ?, ?, ?> logout = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> payDone = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> payBack = Signals.createSignal();
    public final Signal<QuickSale, ?, ?, ?, ?> changed = Signals.createSignal(QuickSale.class, (String)"this");
    public final Signal<Account, User, ?, ?, ?> accountChanged = Signals.createSignal(Account.class, (String)"current account", User.class, (String)"locker user");
    public final Signal<Account, ?, ?, ?, ?> prevAccount = Signals.createSignal(Account.class, (String)"prevAccount");
    public final Signal<?, ?, ?, ?, ?> printLast = Signals.createSignal();
    public final Signal<QuickSale, BarTabAccount, ?, ?, ?> payToTab = Signals.createSignal(QuickSale.class, (String)"thisQuickSale", BarTabAccount.class, (String)"");
    private final Signal<Account, InventoryItem, ?, ?, ?> itemFound = Signals.createSignal(Account.class, (String)"currentAccount", InventoryItem.class, (String)"foundItem");
    private final QuickSalePanel gui;
    private final QuickSaleNav nav;
    private final AddItems addItemState;
    private final CouponHandlerFactory couponHandlerFactory;
    private final Signal<?, ?, ?, ?, ?> modifyDone = Signals.createSignal();
    private final TabTransactionScreen selectTabScreen;
    private final SelectPriceAdjustment selectAdjustmentScreen;
    private final ClosedAccountItemSignals closedAccountSignals = new ClosedAccountItemSignals();
    private final Signal<?, ?, ?, ?, ?> debtorScreenCancelled = Signals.createSignal();
    private final Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelected = Signals.createSignal(AbstractDebtor.class, (String)"debtor");
    private final List<FinanceInfo> financeInfo;
    private FinanceTransaction cashTransaction;
    private FinanceTransaction lastCashTransaction;
    private LoyaltyRedemptionScreen loyaltyScreen;
    private TakeawayAccount currentAccount;
    private final Signal<?, ?, ?, ?, ?> display = Signals.createSignal();
    private final Signal<?, ?, ?, ?, ?> autoComboDone = Signals.createSignal();
    private final Signal<?, ?, ?, ?, ?> finishedUpgrade = Signals.createSignal();
    private InventoryItemSearchPanel searchPanel;
    private boolean itemOrderedFromSearch = false;
    private String unlockedName = Internationalization.getLiteralFor((String)"QUICK_SALE");
    private String currentName = Internationalization.getLiteralFor((String)"QUICK_SALE");
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    public static final String QUICKSALE_TAB_NAME_PROP = "currentName";
    private JPanel quickLogoutPanel;
    private User quickSaleUser;
    private final FinanceTransactionFactory transactionFactory = new FinanceTransactionFactory();
    private final EftposController eftposController;
    private WaitermateWebPayment webPay;
    private VoucherPayment voucherPay;
    private final DebtorPaymentProcessor debtorPaymentProcesser = new DebtorPaymentProcessor();
    private DebtorTransactionManager debtorTransactionManager;
    private boolean moved;

    public QuickSale() {
        this.quickTransferDone.connect((Object)this, "gotQuickTransferDone");
        this.autoComboDone.connect((Object)this, "gotMakeComboDone");
        StockUtilities.clearPermittedOversellItems();
        this.gui = new QuickSalePanel(Terminal.getLocalHost().getQuickSaleMenuWidth());
        this.gui.groupSelected.connect((Object)this, "gotGroupSelected");
        this.gui.newItem.connect((Object)this, "gotNewItem");
        this.gui.newCombo.connect((Object)this, "gotNewCombo");
        this.nav = new QuickSaleNav();
        this.display.connect((Object)this, "display");
        this.addItemState = new AddItems(true);
        this.addItemState.orderingComplete.connect((Object)this, "gotItemOrderingComplete");
        this.addItemState.done.connect((Object)this, "gotAddItemDone");
        this.couponHandlerFactory = new WaiterMateCouponHandlerFactory(this.addItemState);
        this.modifyDone.connect((Object)this, "display");
        this.payDone.connect((Object)this, "gotPayDone");
        this.payBack.connect((Object)this, "gotPayBack");
        this.financeInfo = new ArrayList<FinanceInfo>();
        this.financeInfo.add(this.gui);
        this.financeInfo.addAll(Terminal.getLocalHost().getAvailablePoleDisplays());
        this.gui.item.connect((Object)this, "gotItem");
        this.gui.quantity.connect((Object)this, "gotQuantity");
        this.gui.delete.connect((Object)this, "gotDelete");
        this.gui.upgrade.connect((Object)this, "gotUpgrade");
        this.gui.clearTendered.connect((Object)this, "gotClearTendered");
        this.gui.resyncPoints.connect((Object)this, "gotResyncPoints");
        this.nav.addCash.connect((Object)this, "gotAddCash");
        this.nav.cashdrawer.connect((Object)this, "gotNoSale");
        this.nav.pay.connect((Object)this, "gotPay");
        this.nav.quickPay.connect((Object)this, "gotQuickPay");
        this.nav.config.connect((Object)this, "gotAdmin");
        this.nav.tabPay.connect((Object)this, "gotTabPay");
        this.nav.customerDebtorPay.connect((Object)this, "gotDebtorPay");
        this.nav.roomAccountPay.connect((Object)this, "gotRoomAccountPay");
        this.nav.discount.connect((Object)this, "gotDiscount");
        this.nav.customer.connect((Object)this, "gotSetCustomer");
        this.nav.printOrder.connect((Object)this, "gotPrintOrder");
        this.nav.showOrder.connect((Object)this, "gotShowItems");
        this.nav.ticketData.connect((Object)this, "gotTicketData");
        this.nav.usePriceLevel.connect((Object)this, "usePriceLevel");
        this.nav.useCheapestPriceLevels.connect((Object)this, "useCheapestPriceLevel");
        this.nav.makeCombo.connect((Object)this, "gotMakeCombo");
        this.nav.quickTransfer.connect((Object)this, "gotQuickTransfer");
        this.nav.findItem.connect((Object)this, "gotFindItem");
        this.nav.printLast.connect(this.printLast);
        this.nav.admin.connect((Object)this, "gotSysAdmin");
        this.nav.creditPay.connect((Object)this, "gotCreditPay");
        this.nav.payPalPay.connect((Object)this, "gotPayPalPay");
        this.nav.payToCard.connect((Object)this, "gotPayToCard");
        this.nav.payByLoyalty.connect((Object)this, "gotPayByLoyalty");
        this.nav.customerMessage.connect((Object)this, "gotCustomerMessage");
        this.nav.changeToDineIn.connect((Object)this, "gotChangeToDineIn");
        this.nav.changeToTakeaway.connect((Object)this, "gotChangeToTakeaway");
        this.nav.payToDebtor.connect((Object)this, "gotDebtorPay");
        this.nav.voucherPay.connect((Object)this, "gotVoucherPay");
        this.nav.purchaseVoucher.connect((Object)this, "gotPurchaseVoucher");
        this.nav.showPreviousAccount.connect((Object)this, "showPreviousAccount");
        this.closedAccountSignals.back.connect((Object)this, "showPreviousAccountDone");
        this.closedAccountSignals.ok.connect((Object)this, "showPreviousAccountDone");
        this.selectTabScreen = new TabTransactionScreen();
        this.selectTabScreen.tabSelectedSignal.connect((Object)this, "gotTab");
        this.selectTabScreen.cancel.connect((Object)this, "display");
        this.debtorSelected.connect((Object)this, "gotDebtor");
        this.debtorScreenCancelled.connect((Object)this, "display");
        this.selectAdjustmentScreen = new SelectPriceAdjustment(true);
        this.selectAdjustmentScreen.back.connect((Object)this, "display");
        this.selectAdjustmentScreen.addAdjustment.connect((Object)this, "gotDiscountDone");
        this.selectAdjustmentScreen.removeAdjustment.connect((Object)this, "gotRemoveDiscount");
        this.finishedUpgrade.connect((Object)this, "display");
        this.itemFound.connect((Object)this, "gotFoundItem");
        this.eftposController = new EftposController();
        this.eftposController.txnAdded.connect((Object)this, "gotEftposAdded");
        this.eftposController.txnRemoved.connect((Object)this, "gotEftposRemoved");
        this.eftposController.eftposFinished.connect((Object)this, "gotEftposFinished");
        WaiterMateInputAdapter.getInstance().barcodeInput.connect((Object)this, "gotBarcode");
        WaiterMateInputAdapter.getInstance().barcodedItemScanned.connect((Object)this, "gotBarcodedItemScanned");
        WaiterMateInputAdapter.getInstance().couponScanned.connect((Object)this, "gotCouponScanned");
        WaiterMateInputAdapter.getInstance().customerInput.connect((Object)this, "setCustomer");
        WaiterMateInputAdapter.getInstance().customerCardInput.connect((Object)this, "gotCustomerCard");
        CustomerUpdateManager.getInstance().customerUpdated.connect((Object)this, "gotUpdateCustomer");
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotNewUser");
        LoginManager.getInstance().refreshUserSignal.connect((Object)this, "gotRefreshUser");
        WaiterMateUpdater.getInstance().updatePerformed.connect((Object)this, "gotUpdate");
        this.loyaltyScreen = new LoyaltyRedemptionScreen();
        this.loyaltyScreen.getNavBar().back.connect((Object)this, "display");
        this.loyaltyScreen.getNavBar().cancel.connect((Object)this, "display");
        this.loyaltyScreen.getNavBar().ok.connect((Object)this, "gotLoyaltyDone");
        this.bistroModeHelper = new BistroModeHelper(this.currentSaleLineItems);
    }

    private void gotGroupSelected(InventoryGroup group) {
        this.scrapAccountIfTradingDayHasChanged();
        this.addItemState.startAddingItem((Account)this.getCurrentAccount(), group, new OrderedItemDetails());
    }

    private void scrapAccountIfTradingDayHasChanged() {
        if (this.shouldAccountBeScrapped()) {
            this.newAccount();
        }
    }

    private boolean shouldAccountBeScrapped() {
        TakeawayAccount currentAccount = this.getCurrentAccount();
        boolean sameTradingDay = currentAccount.getTradingDay().getDate().equals(SystemCurrentInfo.getInstance().getCurrentTradingDay().getDate()) && currentAccount.getTradingDay().getTime().equals(SystemCurrentInfo.getInstance().getCurrentTradingDay().getTime());
        boolean accountHasItems = currentAccount.hasItems();
        return !sameTradingDay && !accountHasItems;
    }

    void gotNewItem(InventoryItem newItem) {
        this.scrapAccountIfTradingDayHasChanged();
        this.addItemState.startAddingItem((Account)this.getCurrentAccount(), newItem, new OrderedItemDetails(), this.gui.getKeyPadQuantity(), this.gui.getIncrementQuantityFlag());
    }

    void gotNewCombo(InventoryCombo newItem) {
        this.scrapAccountIfTradingDayHasChanged();
        this.addItemState.startAddingCombo((Account)this.getCurrentAccount(), newItem, new OrderedItemDetails(), this.gui.getKeyPadQuantity(), this.gui.getIncrementQuantityFlag());
    }

    void gotItem(Sellable theItem) {
        this.scrapAccountIfTradingDayHasChanged();
        if (theItem instanceof SalesLineItemWrapper) {
            ModifyItem.getInstance().startModify((SalesLineItem)theItem.getSellingObject(), (Account)this.getCurrentAccount(), this.modifyDone);
        }
    }

    private void itemsUpdated() {
        if (!this.gotPayDone) {
            this.currentSaleLineItems = new ArrayList<SalesLineItem>();
            this.currentSaleLineItems.addAll(this.getCurrentAccount().getItemHelper().getUnpaidItems());
            this.bistroModeHelper.setCurrentSaleLineItems(this.currentSaleLineItems);
        }
        this.priceLevelCheckForChange();
        this.setupScreen();
    }

    private void priceLevelCheckForChange() {
        if (PriceLevel.getAllPriceLevels().size() > 1 && LoginManager.getInstance().getUser() != null) {
            boolean onlyActive = !LoginManager.getInstance().getUser().hasPermission(AllPermissions.USE_INACTIVE_PRICE_LEVEL);
            Set priceLevelSet = this.getCurrentAccount().getPriceAdjHelper().getPossiblePriceLevels(onlyActive, LoginManager.getEventContext());
            for (PriceLevel currentPriceLevel : priceLevelSet) {
                if (!currentPriceLevel.isActive(new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.getCurrentAccount()))) {
                    currentPriceLevel.setLabelFormat("%s (Inactive)");
                    currentPriceLevel.setForegroundColor(Color.RED);
                    continue;
                }
                currentPriceLevel.setLabelFormat("");
                currentPriceLevel.setForegroundColor(OrderMateTheme.getDefaultTextColor());
            }
            this.nav.setPossiblePriceLevels(priceLevelSet);
        }
    }

    void gotQuantity(Sellable theItem) {
        if (theItem.isQuantifiable() && theItem instanceof SalesLineItemWrapper) {
            SalesLineItem salesItem = (SalesLineItem)theItem.getSellingObject();
            SalesQuantity newQuantity = theItem.getQuantity().lessThan(0L) ? theItem.getQuantity().subtract(SalesQuantity.ONE) : theItem.getQuantity().add(SalesQuantity.ONE);
            boolean allowQuantityEdit = StockUtilities.allowQuantityEdit((Account)this.getCurrentAccount(), new ArrayList(), (SalesLineItem)salesItem, (SalesQuantity)newQuantity, (User)LoginManager.getInstance().getUser());
            if (allowQuantityEdit && this.currentAccount instanceof CreditLimited && ((CreditLimited)this.currentAccount).exceedsCreditLimit(salesItem.getPricePerItem())) {
                boolean bl = allowQuantityEdit = allowQuantityEdit && CreditLimitPanel.doCreditLimitDialog((CreditLimited)this.currentAccount, salesItem.getPricePerItem(), this.currentAccount.getLabel(), true);
            }
            if (allowQuantityEdit) {
                salesItem.setQuantity(newQuantity, LoginManager.getEventContext());
                this.addItemState.setAccount((Account)this.currentAccount);
                this.addItemState.doAutoCombos((Account)this.currentAccount, null);
                this.itemsUpdated();
            }
        }
    }

    void gotDelete(Sellable theItem) {
        if (theItem instanceof SalesLineItemWrapper) {
            this.getCurrentAccount().getItemHelper().removeItem((SalesLineItem)theItem.getSellingObject(), LoginManager.getEventContext());
        } else if (theItem instanceof VoucherTransactionWrapper) {
            new VoucherTransactionReturner(new WaitermateGuiHandler()).returnTransaction((GiftVoucherTransaction)theItem.getSellingObject(), LoginManager.getEventContext());
        }
        if (this.getCurrentAccount().isPersistent() && this.getCurrentAccount().getItems().isEmpty() && this.getCurrentAccount().isClosePossible()) {
            WaitermateSaveAccount.getInstance().closeAccount((Account)this.getCurrentAccount(), true, false, LoginManager.getEventContext());
        }
        this.itemsUpdated();
    }

    void gotUpgrade(Sellable theItem) {
        if (theItem != null && theItem instanceof SalesLineItemWrapper) {
            UpgradeCombo.getInstance().configureSignal(this.finishedUpgrade);
            UpgradeCombo.getInstance().upgradeRequested((SalesItem)theItem.getSellingObject(), (ItemGroup)this.getCurrentAccount(), LoginManager.getEventContext());
        }
    }

    void createTransaction(Price tendered, Price paid) {
        this.cashTransaction = new CashTransaction(new FinanceTransactionContext(LoginManager.getEventContext(), Terminal.getLocalHost().getAssignedCashDrawer(LoginManager.getInstance().getUser())), tendered, paid, new Price(0.0, Price.DEFAULT_ROUND_AMOUNT));
    }

    void gotAddCash(Price addAmount) {
        if (this.cashTransaction == null) {
            this.cashTransaction = new CashTransaction(new FinanceTransactionContext(LoginManager.getEventContext(), Terminal.getLocalHost().getAssignedCashDrawer(LoginManager.getInstance().getUser())), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR);
        }
        this.cashTransaction.setTendered(this.cashTransaction.getTendered().add(addAmount));
        Price due = this.currentAccount.getDue(Price.DEFAULT_ROUND_AMOUNT);
        if (this.cashTransaction.getTendered().greaterThan((Object)due)) {
            this.cashTransaction.setPaid(due);
        } else {
            this.cashTransaction.setPaid(this.cashTransaction.getTendered());
        }
        this.cashTransaction.setRoundingAmt(this.cashTransaction.getRoundingAmt().add(addAmount.getAppliedRoundingAmt()));
        this.setupScreen();
    }

    void usePriceLevel(PriceLevel toUse, Boolean showDialog) {
        this.getCurrentAccount().getPriceAdjHelper().usePriceLevel(toUse, true, LoginManager.getEventContext());
        this.itemsUpdated();
        if (Boolean.TRUE.equals(showDialog)) {
            new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItemsOnPriceLevelChange((ItemGroup)this.getCurrentAccount());
        }
    }

    void useCheapestPriceLevel() {
        List changedList = this.getCurrentAccount().getPriceAdjHelper().useCheapestPriceLevel(false, LoginManager.getEventContext());
        this.itemsUpdated();
        Dialogs.displayOkDialog((String)this.itemsToString(changedList), (String)Internationalization.getLiteralFor((String)"CHEAPEST_PRICES"));
    }

    private String itemsToString(List updatedItems) {
        StringBuffer itemList = new StringBuffer();
        SalesQuantity itemCount = SalesQuantity.ZERO;
        for (SalesLineItem item : updatedItems) {
            itemCount = itemCount.add(item.getQuantity());
            itemList.append("<li>");
            itemList.append(item.getQuantity());
            itemList.append(" - ");
            itemList.append(item.getLabel());
            itemList.append("</li>");
        }
        StringBuffer string = new StringBuffer("<html>" + itemCount);
        string.append(" " + Internationalization.getLiteralFor((String)"_ITEM"));
        if (itemCount.notEquals(1)) {
            string.append('s');
        }
        string.append(" " + Internationalization.getLiteralFor((String)"UPDATED_FULLSTOP") + "<ul>");
        string.append(itemList);
        string.append("</ul><html>");
        return string.toString();
    }

    void gotPay() {
        boolean accountEmpty = !this.getCurrentAccount().hasSellables();
        boolean zeroDue = this.getCurrentAccount().getDue().equals((Object)Price.ZERO_DOLLAR);
        boolean keepOpen = false;
        Terminal localhost = Terminal.getLocalHost();
        if (this.inBistroMode && !accountEmpty && zeroDue) {
            this.closeAccount();
        } else if (this.preTransaction()) {
            this.nav.setEnableQuickEftpos(true);
            if (this.getCurrentAccount().hasSellables()) {
                Payments.getInstance().startPayment((Account)this.getCurrentAccount(), this.payBack, this.payDone, true);
            } else {
                Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_TO_PAY_OFF"), (String)Internationalization.getLiteralFor((String)"NO_ITEMS"));
            }
        }
    }

    void gotTicketData() {
        WaitermateSaveAccount.getInstance().getTicketData((Account)this.getCurrentAccount());
        this.gui.setOrderInfo(this.getCurrentAccount().getTicketData());
    }

    void gotPayBack() {
        this.gotPayDone = true;
        this.display();
        if (Terminal.getLocalHost().getTicketDataConfig().equals((Object)TicketDataConfig.TicketDataFirst)) {
            this.currentAccount.clearTicketData();
        }
    }

    void gotPayDone() {
        this.gotPayDone = true;
        this.display();
        if (this.getCurrentAccount().isOpen() && (this.getCurrentAccount().hasSellables() || this.getCurrentAccount().isPersistent())) {
            if (this.inBistroMode) {
                if (this.cashTransaction != null) {
                    this.cashTransaction.setPaid(this.bistroModeHelper.getPaid(this.cashTransaction));
                    this.cashTransaction.setTendered(this.bistroModeHelper.calculateCurrentTendered());
                }
            } else if (this.getCurrentAccount().getFinanceTransactions().isEmpty() && this.getCurrentAccount().getDue().equals((Object)Price.ZERO_DOLLAR)) {
                if (this.cashTransaction == null) {
                    this.gotAddCash(this.getCurrentAccount().getDue(Price.DEFAULT_ROUND_AMOUNT));
                }
                this.getCurrentAccount().addFinanceTransaction(this.cashTransaction);
            }
            this.closeAccount();
        } else {
            this.newAccount();
        }
    }

    void gotDiscount() {
        this.selectAdjustmentScreen.start(this.getCurrentAccount().getPriceAdjHelper().getDiscounts(), null, PriceAdjustmentDirection.DISCOUNT, PriceAdjustmentType.NORMAL, PriceAdjustmentLevel.ACCOUNT_LEVEL, this.getTriggerActivationContext());
    }

    void gotDiscountDone(InventoryPriceAdjustment newAdjustment) {
        String reason = null;
        if (newAdjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) && newAdjustment.getType().equals((Object)PriceAdjustmentType.CUSTOM) && Terminal.getLocalHost().isPromptForCustomDiscountReason()) {
            if (DiscountReasonPopup.areReasonsAvailable()) {
                reason = DiscountReasonPopup.promptForReason();
                if (reason == null) {
                    this.display();
                    return;
                }
            } else {
                WaiterMate.LOG.warn("Cannot supply reason code for items discount as none are available.");
            }
        }
        if (PriceAdjustmentDirection.DISCOUNT.equals((Object)newAdjustment.getDirection()) && PriceAdjustmentType.NORMAL.equals((Object)newAdjustment.getType()) && newAdjustment.isOpenPrice()) {
            TakeawayAccount account = this.getCurrentAccount();
            DiscountGuiUtils.getNewPriceForOpenPriceDiscountAccount(newAdjustment, (Account)account);
        } else {
            SalesPriceAdjustment salesAdj = newAdjustment.createSalesPriceAdjustment((PriceAdjustable)this.getCurrentAccount(), LoginManager.getEventContext());
            salesAdj.setReason(reason, LoginManager.getEventContext());
        }
        this.display();
    }

    void gotRemoveDiscount(SalesPriceAdjustmentI adjustment) {
        this.getCurrentAccount().removePriceAdjustment((SalesPriceAdjustment)adjustment, LoginManager.getEventContext());
        this.display();
    }

    void gotClearTendered() {
        if (this.cashTransaction != null) {
            if (this.inBistroMode) {
                this.getCurrentAccount().getFinanceTransactions().remove(this.cashTransaction);
                this.cashTransaction.setPaid(Price.ZERO_DOLLAR);
                this.cashTransaction.setTendered(Price.ZERO_DOLLAR);
            } else {
                this.getCurrentAccount().removeFinanceTransaction(this.cashTransaction);
                this.cashTransaction = null;
            }
        }
        if (!(this.inBistroMode || this.getCurrentAccount() != null && this.getCurrentAccount().hasSellables() && this.getCurrentAccount().isOpen())) {
            this.newAccount();
        }
        this.setupScreen();
    }

    void gotDone() {
        if (this.preTransaction()) {
            Price due = this.currentAccount.getDue(Price.DEFAULT_ROUND_AMOUNT);
            if (this.cashTransaction == null) {
                this.createTransaction(due, due);
            } else {
                this.cashTransaction.setPaid(due);
            }
            this.lastCashTransaction = this.cashTransaction;
            this.nav.setDoneEnabled(false);
            this.nav.setEnableQuickEftpos(false);
            this.getCurrentAccount().addFinanceTransaction(this.cashTransaction);
            this.postTransaction(this.cashTransaction);
            this.closeAccount();
        }
    }

    void gotQuickPay() {
        if (this.cashTransaction != null) {
            if (this.inBistroMode) {
                this.gotDone();
            } else if (this.cashTransaction.getPaid().greaterThan((Object)this.getCurrentAccount().getDue(Price.DEFAULT_ROUND_AMOUNT)) || this.cashTransaction.getPaid().equals((Object)this.getCurrentAccount().getDue(Price.DEFAULT_ROUND_AMOUNT))) {
                this.gotDone();
            }
        } else {
            this.gotDone();
        }
    }

    void gotPrintOrder() {
        if (WaitermateSaveAccount.getInstance().printOrder((Account)this.getCurrentAccount(), LoginManager.getEventContext())) {
            this.setupScreen();
        }
    }

    public void gotTab(BarTabAccount barTab) {
        boolean enoughCredit;
        boolean bl = enoughCredit = !barTab.exceedsCreditLimit(this.getCurrentAccount().getDue()) || CreditLimitPanel.doCreditLimitDialog((CreditLimited)barTab, this.getCurrentAccount().getDue(), barTab.getLabel(), true);
        if (enoughCredit && this.preTransaction()) {
            this.payToTab.emit((Object)this, (Object)barTab);
        } else {
            barTab.unlock();
        }
    }

    public void gotDebtor(AbstractDebtor debtor) {
        TakeawayAccount account = this.getCurrentAccount();
        if (this.preTransaction()) {
            boolean paymentSucceeded = this.debtorPaymentProcesser.payToDebtor((Account)account, debtor, this.getTransactionManager());
            if (paymentSucceeded) {
                this.printAndRestart();
                new DebtorSaleHandler().salePerformed(debtor, (Account)account);
                this.display();
                this.startQuickLogoutDialog();
            } else {
                this.display();
            }
        }
    }

    private boolean isTerminalConfigTicketDataEntryRequired() {
        Terminal localhost = Terminal.getLocalHost();
        return localhost.getTicketDataConfig() != null || localhost.isQuicksaleDineinStandName() || localhost.isQuicksaleDineinStandNum() || localhost.isQuicksaleTakeawayStandName() || localhost.isQuicksaleTakeawayStandNum();
    }

    private boolean isTicketDataEntryRequired() {
        Terminal localhost = Terminal.getLocalHost();
        boolean shouldIBother = !this.currentAccount.hasTicketData() && localhost.isAutoPromptQS();
        return shouldIBother && this.isTerminalConfigTicketDataEntryRequired();
    }

    private boolean preTransaction() {
        boolean okToContinue = true;
        if (this.isTicketDataEntryRequired() && !WaitermateSaveAccount.getInstance().getTicketData((Account)this.getCurrentAccount())) {
            return false;
        }
        this.checkCurrentAccountType();
        if (okToContinue) {
            okToContinue = StockUtilities.checkAccountOversell((Account)this.getCurrentAccount());
        }
        return okToContinue;
    }

    private void checkCurrentAccountType() {
        boolean foundTicket = false;
        boolean isDineIn = false;
        for (String ticketLine : this.getCurrentAccount().getTicketData()) {
            if (ticketLine.contains(WaiterMateTicketData.DINE_IN)) {
                isDineIn = true;
                foundTicket = true;
                break;
            }
            if (!ticketLine.contains(WaiterMateTicketData.TAKE_AWAY)) continue;
            isDineIn = false;
            foundTicket = true;
            break;
        }
        if (foundTicket) {
            if (isDineIn) {
                this.getCurrentAccount().setAccountType(AccountType.quickSaleDineInType);
            } else {
                this.getCurrentAccount().setAccountType(AccountType.takeawayType);
            }
        }
    }

    boolean isBistroModePopUpRequired() {
        return !this.getCurrentAccount().getTicketData().isEmpty();
    }

    private void postTransaction(FinanceTransaction transaction) {
        List deNoms;
        if (transaction.needsOpenCashdrawer()) {
            CashDrawerManager.getInstance().openAllCashDrawersPayment(LoginManager.getInstance().getUser(), transaction, Terminal.getLocalHost());
        }
        if (SystemProperty.getInstance().isCctvEnabled() && Terminal.getLocalHost().getCCTVCamera() != null) {
            HashSet<FinanceTransaction> newTransaction = new HashSet<FinanceTransaction>();
            newTransaction.add(transaction);
            CCTVIntegration.showPayoff((Payable)this.getCurrentAccount(), newTransaction, (User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost());
        }
        if (SystemProperty.getInstance().isShowChange() && !(deNoms = new ChangeCalculator(Denomination.getDenominations()).calculateChange(transaction.getTendered(), transaction.getPaid().add(transaction.getTip()))).isEmpty()) {
            new DenominationPopup().showDenominations(deNoms);
        }
        this.setupScreen();
    }

    protected void closeAccount(boolean doQuickLogout) {
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.getCurrentAccount());
        WaitermateSaveAccount.getInstance().closeAccount((Account)this.getCurrentAccount(), true, true, (EventContext)context);
        CouponAdministratorRemote.getInstance().accountSaved(context);
        if (this.currentAccount.isPersistent()) {
            this.currentAccount = (TakeawayAccount)PersistenceManager.reacquire((PersistentObjectI)this.currentAccount);
        }
        this.emitAccountChanged();
        this.printAndRestart();
        if (doQuickLogout) {
            this.startQuickLogoutDialog();
        }
        this.changed.emit((Object)this);
        this.currentSaleLineItems = new ArrayList<SalesLineItem>();
        this.bistroModeHelper.setCurrentSaleLineItems(this.currentSaleLineItems);
    }

    protected void closeAccount() {
        boolean keepOpen = false;
        Terminal localhost = Terminal.getLocalHost();
        if (localhost.isQuicksaleBistroMode() && this.isBistroModePopUpRequired() && !this.isTicketDataEntryRequired()) {
            this.inBistroMode = keepOpen = WaitermateSaveAccount.getInstance().moreCustomers();
        }
        if (keepOpen) {
            this.setupNavButtons();
            TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.getCurrentAccount());
            WaitermateSaveAccount.getInstance().saveAccount((Account)this.getCurrentAccount(), (EventContext)context);
            this.updateFinanceInfo(null);
        } else {
            this.closeAccount(true);
        }
    }

    private void printAndRestart() {
        WaitermateSaveAccount.getInstance().printClosingReceipts((Account)this.getCurrentAccount());
        WaitermateSaveAccount.getInstance().printPrep((Account)this.getCurrentAccount());
        this.setupDiscountSurcharge((Account)this.getCurrentAccount());
        this.getCurrentAccount().unlock();
        this.newAccount();
    }

    protected void updateFinanceInfo(FinanceTransaction transaction) {
        Price total;
        if (transaction != null && transaction instanceof CashTransaction) {
            if (transaction.getPayoffGroup() != null) {
                total = new Price((Number)this.bistroModeHelper.calculateCurrentTotal().add(transaction.getRoundingAmt()), Price.DEFAULT_ROUND_AMOUNT);
            } else {
                total = new Price((Number)this.bistroModeHelper.calculateCurrentTotal().subtract(this.getCurrentAccount().getTotalRoundingAmt()), Price.DEFAULT_ROUND_AMOUNT);
                transaction.setRoundingAmt(total.getAppliedRoundingAmt());
            }
        } else {
            total = this.bistroModeHelper.calculateCurrentTotal();
        }
        Price paid = this.bistroModeHelper.calculateCurrentPaid(this.cashTransaction);
        Price change = Price.ZERO_DOLLAR;
        Price tendered = Price.ZERO_DOLLAR;
        Price rounding = this.getCurrentAccount().getTotalRoundingAmt();
        Price remaining = null;
        if (transaction != null) {
            change = transaction.getChange();
            tendered = transaction.getTendered();
            if (this.getCurrentAccount().getTotalRoundingAmt().isZero()) {
                rounding = transaction.getRoundingAmt();
            }
            remaining = VoucherTransactionHelper.getInstance().getRemainingBalance(transaction);
        } else if (!this.getCurrentAccount().getFinanceTransactions().isEmpty()) {
            List allTransactions = this.getCurrentAccount().getFinanceTransactions();
            Collections.sort(allTransactions, new PropertyAccessorComparator((PropertyAccessor)FinanceTransaction.Properties.CREATION_TIME, true));
            FinanceTransaction lastTransaction = (FinanceTransaction)allTransactions.get(0);
            if (lastTransaction instanceof CashTransaction) {
                tendered = lastTransaction.getTendered();
                change = tendered.subtract(lastTransaction.getPaid());
            } else {
                tendered = Price.ZERO_DOLLAR;
            }
            remaining = VoucherTransactionHelper.getInstance().getRemainingBalance(lastTransaction);
        }
        if (!rounding.isZero()) {
            total = total.add(rounding);
        }
        Price due = total;
        due = !this.currentAccount.getFinanceTransactions().isEmpty() ? this.currentAccount.getDue() : total.subtract(paid);
        if (Price.ZERO_DOLLAR.approximatelyEquals(due)) {
            due = null;
        }
        for (FinanceInfo info : this.financeInfo) {
            info.setFinanceInfo(total, due, paid, tendered, change, remaining);
        }
    }

    private void resetFinanceInfo() {
        this.cashTransaction = null;
    }

    private void setupDiscountSurcharge(Account theAccount) {
        String discount = null;
        String surcharge = null;
        if (!this.inBistroMode && this.currentSaleLineItems.isEmpty()) {
            if (theAccount.getPriceAdjHelper().isDiscounted()) {
                discount = theAccount.getPriceAdjHelper().stringifyDiscountSummary();
            }
            if (theAccount.getPriceAdjHelper().isSurcharged()) {
                surcharge = theAccount.getPriceAdjHelper().stringifySurchargeSummary();
            }
        } else {
            Price surchargeTotal = Price.ZERO_DOLLAR;
            Price discountTotal = Price.ZERO_DOLLAR;
            for (SalesLineItem lineItem : this.currentSaleLineItems) {
                for (SalesItem item : lineItem.getSalesItems()) {
                    for (SalesComponent comp : item.getComponentList()) {
                        for (SalesPriceAdjustmentUsage usage : comp.getPriceAdjustmentUsages()) {
                            if (PriceAdjustmentDirection.SURCHARGE.equals((Object)usage.getSalesPriceAdjustment().getDirection())) {
                                surchargeTotal = surchargeTotal.add(usage.getSavedTotalValue());
                                continue;
                            }
                            discountTotal = discountTotal.add(usage.getSavedTotalValue());
                        }
                    }
                }
            }
            if (!Price.ZERO_DOLLAR.equals((Object)surchargeTotal)) {
                surcharge = surchargeTotal.negate().toString();
            }
            if (!Price.ZERO_DOLLAR.equals((Object)discountTotal)) {
                discount = discountTotal.toString();
            }
        }
        this.gui.setDiscountAndSurcharge(discount, surcharge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newAccount() {
        TakeawayAccount previousAccount;
        if (this.getCurrentAccount() != null && this.getCurrentAccount().isPersistent()) {
            this.cashTransaction = null;
            this.currentAccount.setQuickSaleOriginated(true);
            this.setupScreen();
        }
        if ((previousAccount = this.getCurrentAccount()) != null && previousAccount.hasSellables()) {
            previousAccount.unlock();
            this.prevAccount.emit((Object)previousAccount);
        }
        QuickSale quickSale = this;
        synchronized (quickSale) {
            OrderMate.LOG.info("Creating New Account in QuickSale");
            User user = LoginManager.getInstance().getUser();
            this.currentAccount = new TakeawayAccount(user, Terminal.getLocalHost(), SystemProperty.getInstance().getDefaultQuickSaleAccType());
            this.currentAccount.lock(user);
            this.currentAccount.setQuickSaleOriginated(true);
            this.currentAccount.setRequiresEatInTicket(true);
            if (this.isPresetDineInTakeAway()) {
                this.currentAccount.setRequiresEatInTicket(false);
                this.changeAccountType(this.currentAccount.getAccountType());
            }
        }
        this.cashTransaction = null;
        this.gui.newAccount((Account)this.getCurrentAccount());
        this.nav.setAccount(this.getCurrentAccount());
        this.emitAccountChanged();
        this.setupNavButtons();
        if (previousAccount == null || !previousAccount.isPersistent()) {
            this.setupScreen();
        }
    }

    private boolean isPresetDineInTakeAway() {
        return TicketDataConfig.NoAccountTypePrompt.equals((Object)Terminal.getLocalHost().getTicketDataConfig()) || this.nav.isDineInTakeawayManual();
    }

    protected FinanceTransaction getCashTransaction() {
        return this.cashTransaction;
    }

    private void setupScreen() {
        this.updatePaid();
        this.gui.showAccount((Account)this.getCurrentAccount());
        this.setupNavButtons();
        this.updateFinanceInfo(this.cashTransaction);
        this.gui.setOrderInfo(this.getCurrentAccount().getTicketData());
        this.setupDiscountSurcharge((Account)this.getCurrentAccount());
        if (Terminal.getLocalHost().getPrintPrepAsOrdering() && WaitermateSaveAccount.getInstance().getTicketData((Account)this.getCurrentAccount()) && this.getCurrentAccount().hasItems()) {
            WaitermateSaveAccount.getInstance().lockAccount((Lockable)this.getCurrentAccount());
            WaitermateSaveAccount.getInstance().saveAccount((Account)this.getCurrentAccount(), LoginManager.getEventContext());
            WaitermateSaveAccount.getInstance().printPrep((Account)this.getCurrentAccount());
            WaitermateSaveAccount.getInstance().unlock((Lockable)this.getCurrentAccount());
        }
        this.enablifyMakeCombos();
        this.changed.emit((Object)this);
        this.emitAccountChanged();
        CouponAdministratorRemote.getInstance().setHandlerFactory(this.couponHandlerFactory);
    }

    private void updatePaid() {
        if (this.cashTransaction == null) {
            if (!this.inBistroMode && this.lastCashTransaction != null && this.currentAccount.equals((Object)this.lastCashTransaction.getPayoffGroup())) {
                List txns = this.currentAccount.getFinanceTransactions();
                for (int i = txns.size() - 1; i >= 0; ++i) {
                    if (!((FinanceTransaction)txns.get(i)).isActive()) continue;
                    this.cashTransaction = (FinanceTransaction)txns.get(i);
                    break;
                }
            }
        } else if (this.cashTransaction.getPayoffGroup() == null) {
            double paid = 0.0;
            List payments = this.getCurrentAccount().getFinanceTransactions();
            for (FinanceTransaction payment : payments) {
                if (payment == this.cashTransaction) continue;
                paid += payment.getPaid().doubleValue();
            }
            paid = this.getCurrentAccount().getTotal().doubleValue() - paid;
            Price newPaid = new Price(paid, Price.DEFAULT_ROUND_AMOUNT);
            if (newPaid.doubleValue() < this.cashTransaction.getTendered().doubleValue()) {
                this.cashTransaction.setPaid(newPaid);
                if (this.getCurrentAccount().getTotalRoundingAmt().isZero()) {
                    this.cashTransaction.setRoundingAmt(newPaid.getAppliedRoundingAmt());
                }
            } else {
                this.cashTransaction.setPaid(this.cashTransaction.getTendered());
            }
        }
    }

    private void setupNavButtons() {
        AccountType accType;
        boolean zeroDue;
        boolean accountEmpty;
        Price due = Price.ZERO_DOLLAR;
        if (this.getCurrentAccount() != null) {
            due = this.getCurrentAccount().getDue(Price.DEFAULT_ROUND_AMOUNT);
            accountEmpty = !this.getCurrentAccount().hasSellables();
            zeroDue = due.equals((Object)Price.ZERO_DOLLAR);
            accType = this.getCurrentAccount().getAccountType();
        } else {
            accountEmpty = true;
            zeroDue = true;
            accType = SystemProperty.getInstance().getDefaultQuickSaleAccType();
        }
        this.nav.setAccountHasItems(!accountEmpty, zeroDue, this.inBistroMode);
        boolean enabled = true;
        if (this.cashTransaction != null) {
            enabled = this.cashTransaction.getPaid().equals((Object)Price.ZERO_DOLLAR) || this.cashTransaction.getPaid().greaterThan((Object)due) || this.cashTransaction.getPaid().equals((Object)due);
        }
        this.nav.setDoneEnabled(!accountEmpty && (!zeroDue || !this.inBistroMode) && enabled);
        this.nav.setEnableQuickEftpos(!accountEmpty && (!zeroDue || !this.inBistroMode));
        this.nav.setAccountType(accType);
        this.nav.reset();
    }

    public void gotSetCustomer() {
        Customer newCustomer = SelectCustomer.startModal(Customer.REQUIRE_BASIC, false);
        if (newCustomer != null) {
            this.setCustomer(newCustomer);
        }
    }

    private void setCustomer(Customer customer) {
        if (this.isDisplaying()) {
            if (SystemProperty.getInstance().isLoyaltyEnabled()) {
                ProgressDialog.doProgressDialog((Task)new LoyaltyResyncTask((GuiHandler)new WaitermateGuiHandler(), customer));
            }
            boolean changed = this.getCurrentAccount().getCustomer() == null && customer != null || !this.getCurrentAccount().getCustomer().equals((Object)customer);
            EventContext context = LoginManager.getEventContext();
            List items = this.getCurrentAccount().setCustomer(customer, context);
            SystemProperty props = SystemProperty.getInstance();
            if (props.isAutoFillLastItemsQuicksale()) {
                if (items.isEmpty()) {
                    this.getCurrentAccount().autoFillLastAccountForCustomer(context);
                }
                this.setupNavButtons();
            } else if (!items.isEmpty()) {
                this.getCurrentAccount().removeAllItems(context);
            }
            this.setupDiscountSurcharge((Account)this.getCurrentAccount());
            this.updateFinanceInfo(this.cashTransaction);
            this.gui.showAccount((Account)this.getCurrentAccount());
            WaitermateAccountGui.getInstance().accountChanged((Account)this.getCurrentAccount());
            this.nav.customerChanged();
            if (changed) {
                ActionManager.getInstance().triggerAction(ActionFireOn.CustomerSet, new TriggerActivationContext(LoginManager.getEventContext(), customer));
            }
            CustomerUpdateManager.getInstance().addCustomerToUpdate(customer);
            if (SystemProperty.getInstance().formAutoCombosOnOrder() && AutoComboSelector.canMakeCombos((ItemGroup)this.currentAccount, null)) {
                AutoComboSelector selector = AutoComboSelector.getInstance();
                selector.configureSignal(this.autoComboDone);
                selector.setContext((ItemGroup)this.currentAccount, null, LoginManager.getEventContext());
                selector.startMake();
            }
            if (changed) {
                WaiterMateCoupons coupons = new WaiterMateCoupons((Account)this.getCurrentAccount());
                coupons.getRedeemDoneSignal().disconnect((Object)this);
                coupons.getRedeemDoneSignal().connect((Object)this, "gotCouponRedeemDone");
                coupons.showCustomerCoupons();
                this.bistroModeHelper.setCurrentSaleLineItems(this.getCurrentAccount().getItems());
                this.setupScreen();
            }
        }
    }

    public void gotUpdateCustomer(Customer toUpdate) {
        if (this.isDisplaying() && this.getCurrentAccount().getCustomer() != null && this.getCurrentAccount().getCustomer().equals((Object)toUpdate)) {
            this.setupDiscountSurcharge((Account)this.getCurrentAccount());
            this.updateFinanceInfo(this.cashTransaction);
            this.gui.showAccount((Account)this.getCurrentAccount());
            WaitermateAccountGui.getInstance().accountChanged((Account)this.getCurrentAccount());
            this.nav.customerChanged();
        }
    }

    public void gotBarcode(String data) {
        InventoryItemUnit theUnit;
        if (this.isDisplaying() && !ScreenResource.isDialogShowing() && (theUnit = WaiterMateInputAdapter.getInstance().parseBarcodeString(data, this.getCurrentAccount().getAccountType())) != null) {
            this.addItemState.startAddingItem((Account)this.getCurrentAccount(), theUnit, new OrderedItemDetails(), this.gui.getKeyPadQuantity(), this.gui.getIncrementQuantityFlag());
        }
    }

    public void gotBarcodedItemScanned(String PLU, Double payload) {
        InventoryItemUnit theUnit;
        if (this.isDisplaying() && !ScreenResource.isDialogShowing() && (theUnit = WaiterMateInputAdapter.getInstance().parseBarcodeString(PLU, this.getCurrentAccount().getAccountType())) != null) {
            if (ItemBarcodeType.Price.equals((Object)SystemProperty.getInstance().getItemBarcodeType())) {
                this.addItemState.startAddingItem((Account)this.getCurrentAccount(), theUnit, new OrderedItemDetails(0, 0, new Price(payload.doubleValue(), 0.01)), SalesQuantity.ONE, false);
            } else {
                SalesQuantity qty = SalesQuantity.ONE;
                if (payload != null && payload > 0.0) {
                    qty = new SalesQuantity(new BigDecimal(payload));
                }
                this.addItemState.startAddingItem((Account)this.getCurrentAccount(), theUnit, new OrderedItemDetails(0, 0, null), qty, false);
            }
        }
    }

    @Override
    protected List<Terminal> getTerminals() {
        return Arrays.asList(Terminal.getLocalHost());
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    @Override
    public void setUp() {
        boolean gotUserShouldShowAccount = true;
        User user = LoginManager.getInstance().getUser();
        if (this.getCurrentAccount() == null || !this.getCurrentAccount().isOpen()) {
            this.newAccount();
        } else if (this.isMoved()) {
            if (!this.isEmpty()) {
                Dialogs.displayOkDialog((String)(user + " concurrent log in"), (String)Internationalization.getLiteralFor((String)"ACCOUNT_HAS_MOVED_TO_ANOTHER_TERMINAL"));
            }
            this.newAccount();
            this.lock(user);
        } else {
            gotUserShouldShowAccount = false;
            this.itemsUpdated();
            this.gotPayDone = false;
            if (!this.getCurrentAccount().hasSellables() && !this.getCurrentAccount().isPersistent()) {
                this.getCurrentAccount().getPriceAdjHelper().applyAutomaticAdjustment(LoginManager.getEventContext(), null);
            }
        }
        this.moved = false;
        this.setupDiscountSurcharge((Account)this.getCurrentAccount());
        if (user != null) {
            this.gotNewUser(user, gotUserShouldShowAccount);
        }
        WaiterMateInputAdapter.getInstance().getUnknownCardHandler().done.connect((Object)this, "display");
        WaiterMateInputAdapter.getInstance().enableUnknownCardHandler(true);
    }

    private void gotNewUser(User newUser, boolean showAccount) {
        if (!(this.getCurrentAccount() == null || this.getCurrentAccount().isPersistent() && this.getCurrentAccount().isLocked() && !this.getCurrentAccount().isLocked(newUser))) {
            this.getCurrentAccount().relock(newUser);
            if (showAccount && this.isDisplaying()) {
                this.gui.showAccount((Account)this.getCurrentAccount());
            }
            this.addItemState.refreshItems();
        }
        this.nav.setPayFunctionalityVisible(Terminal.getLocalHost().getPayableCashDrawers(newUser));
        this.setupNavButtons();
    }

    private void gotNewUser(User newUser) {
        this.gotNewUser(newUser, true);
    }

    public void autoMenuSelect() {
        InventoryProfile profile = InventoryProfile.getProfile((AccountType)TakeawayAccount.TYPE, (Terminal)Terminal.getLocalHost());
        List groups = InventoryProfile.getProfileGroups((InventoryProfile)profile);
        if (!groups.isEmpty()) {
            InventoryGroup firstGroup = (InventoryGroup)groups.get(0);
            this.gotGroupSelected(firstGroup);
        }
    }

    public void gotRefreshUser() {
        User newUser = LoginManager.getInstance().getUser();
        this.gotNewUser(newUser);
    }

    void gotAdmin() {
        AccountAdmin.getInstance().startAdmin((Account)this.getCurrentAccount(), this.display, this.display, this.itemFound, this.display);
    }

    void gotSysAdmin() {
    }

    public void gotUpdate() {
        if (this.getCurrentAccount() != null && !this.getCurrentAccount().hasSellables()) {
            this.newAccount();
        }
    }

    private void enablifyMakeCombos() {
        AutoComboSelector autoComboSelector = AutoComboSelector.getInstance();
        autoComboSelector.configureSignal(this.autoComboDone);
        autoComboSelector.setContext(null, null, LoginManager.getEventContext());
        this.nav.setMakeComboEnabled(AutoComboSelector.canMakeCombos((ItemGroup)this.getCurrentAccount(), null));
    }

    void startQuickLogoutDialog() {
        if (Terminal.getLocalHost().getQuickLogout()) {
            this.showQuickLogOut();
        }
    }

    public void showQuickLogOut() {
        LoginManager.getInstance().logout();
        this.showAppropriateLogoutDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAppropriateLogoutDialog() {
        block9: {
            if (!Terminal.getLocalHost().getQuickLogout()) {
                this.logout.emit();
                return;
            }
            try {
                if (WaiterMateCustomerDisplay.isActive()) {
                    WaiterMateCustomerDisplay.getInstance().accountChanged(null);
                }
                this.nav.startNavOverlay();
                if (Terminal.getLocalHost().getShowPin()) {
                    Dimension dialogSize = this.getQuickLogoutDialog();
                    Point location = new Point(this.gui.getLocation().x + (this.gui.getWidth() - dialogSize.width) / 2, this.gui.getTopLevelAncestor() != null ? this.gui.getTopLevelAncestor().getY() + ScreenResource.getMenuHeight() : 0);
                    while (!LoginManager.getInstance().hasUser()) {
                        String PIN = Dialogs.showKeypadQuickLogout((Dimension)dialogSize, (Point)location);
                        if (PIN.equals("\u0000")) {
                            if (LoginManager.getInstance().hasUser()) continue;
                            this.logout.emit();
                            break block9;
                        }
                        LoginManager.getInstance().gotPinLogin(PIN);
                    }
                    break block9;
                }
                if (this.quickLogoutPanel == null) {
                    this.createNoPinLogoutPanel();
                }
                LoginManager.getInstance().logout();
                ScreenResource.startModalWindow((JPanel)this.quickLogoutPanel);
            }
            finally {
                this.nav.stopNavOverlay();
            }
        }
    }

    public Dimension getQuickLogoutDialog() {
        return new Dimension(400, Math.min(550, this.gui.getFinanceInfoBounds().getLocation().y + this.gui.getLocation().y));
    }

    private void createNoPinLogoutPanel() {
        this.quickLogoutPanel = new JPanel();
        this.quickLogoutPanel.setLayout(new GridBagLayout());
        JLabel messageLabel = new JLabel(Internationalization.getLiteralFor((String)"PLEASE_SWIPE_CARD_TO_LOGON"));
        messageLabel.setFont(OrderMateTheme.getMediumFont());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(10, 10, 10, 10);
        this.quickLogoutPanel.add((Component)messageLabel, c);
        JButton logoutButton = this.nav.constructButton(IconLoader.get((String)"/waitermate/images/lock.png"), Internationalization.getLiteralFor((String)"LOGOUT"), "QuickLogout");
        logoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenResource.stopWindow((JComponent)QuickSale.this.quickLogoutPanel);
                QuickSale.this.logout.emit();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.quickLogoutPanel.add((Component)logoutButton, c);
        this.quickLogoutPanel.setBackground(Color.WHITE);
    }

    public boolean stopQuickLogout() {
        if (Terminal.getLocalHost().getShowPin()) {
            return Dialogs.stopQuickLogoutPinDialog();
        }
        if (this.quickLogoutPanel != null && this.quickLogoutPanel.isDisplayable()) {
            ScreenResource.stopWindow((JComponent)this.quickLogoutPanel);
            return true;
        }
        return false;
    }

    void gotNoSale() {
        User user = LoginManager.getInstance().getUser();
        CashDrawerManager.getInstance().openAllCashDrawersNoSale(user, Terminal.getLocalHost());
        if (SystemProperty.getInstance().isCctvEnabled() && Terminal.getLocalHost().getCCTVCamera() != null) {
            CCTVIntegration.showNoSale((String)"quick sale", (User)user, (Terminal)Terminal.getLocalHost());
        }
        this.startQuickLogoutDialog();
    }

    public void gotTabPay() {
        this.selectTabScreen.start();
    }

    public void gotDebtorPay() {
        this.startPayToDebtor(CustomerDebtor.class);
    }

    public void gotRoomAccountPay() {
        this.startPayToDebtor(RoomAccount.class);
    }

    private void startPayToDebtor(Class debtorClass) {
        DebtorTransaction.getInstance().start(debtorClass, this.debtorScreenCancelled, this.debtorSelected, this.getCurrentAccount().getCustomer(), (Account)this.getCurrentAccount(), "");
    }

    void gotShowItems() {
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItems((ItemGroup)this.getCurrentAccount());
    }

    public void gotPurchaseVoucher() {
        WaiterMateGiftVouchers dialog = new WaiterMateGiftVouchers((Account)this.currentAccount, this.display, false);
        dialog.start();
    }

    public synchronized TakeawayAccount getCurrentAccount() {
        return this.currentAccount;
    }

    public boolean canStartLogoutTimer() {
        return this.getCurrentAccount() == null || !this.getCurrentAccount().isOpen() || this.getCurrentAccount().getItems().size() == 0;
    }

    private TriggerActivationContext getTriggerActivationContext() {
        return new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.getCurrentAccount());
    }

    @Override
    public void showPreviousAccount(Account account) {
        if (account != null) {
            ClosedAccountItems instance = ClosedAccountItems.getInstance(this.closedAccountSignals);
            instance.getNavBar().getOkButton().setVisible(false);
            instance.startSelectItems(account);
        }
    }

    @Override
    public void showPreviousAccountDone() {
        this.display();
    }

    public void displose() {
        super.displose();
        NotificationManager.getInstance().newUserSignal.disconnect((Object)this);
        LoginManager.getInstance().refreshUserSignal.disconnect((Object)this);
        WaiterMateUpdater.getInstance().updatePerformed.disconnect((Object)this);
        WaiterMateInputAdapter.getInstance().barcodeInput.disconnect((Object)this);
        WaiterMateInputAdapter.getInstance().customerInput.disconnect((Object)this);
        CustomerUpdateManager.getInstance().customerUpdated.disconnect((Object)this);
    }

    public void gotMakeCombo() {
        AutoComboSelector autoComboSelector = AutoComboSelector.getInstance();
        autoComboSelector.configureSignal(this.autoComboDone);
        autoComboSelector.setContext((ItemGroup)this.getCurrentAccount(), null, LoginManager.getEventContext());
        autoComboSelector.startMake();
    }

    public void gotMakeComboDone() {
        this.itemsUpdated();
    }

    @Override
    public synchronized void gotQuickTransfer() {
        if (!this.getCurrentAccount().getItemHelper().getUnpaidItems().isEmpty()) {
            if (WaitermateSaveAccount.getInstance().addInfo((Account)this.getCurrentAccount())) {
                WaitermateSaveAccount.getInstance().saveAccount((Account)this.getCurrentAccount(), LoginManager.getEventContext());
                WaitermateSaveAccount.getInstance().printPrep((Account)this.getCurrentAccount());
                TransferItems.getInstance().startTransfer((Account)this.getCurrentAccount(), this.quickTransferDone, this.quickTransferDone, true);
            }
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_TO_TRANSFER"), (String)Internationalization.getLiteralFor((String)"NO_ITEMS"));
        }
    }

    @Override
    public synchronized void gotQuickTransferDone() {
        this.display();
    }

    public void setUnlockedName(String name) {
        this.unlockedName = name;
    }

    public void gotFindItem(Boolean resetSearch) {
        if (this.searchPanel == null) {
            this.searchPanel = new InventoryItemSearchPanel();
            this.searchPanel.back.connect((Object)this, "gotFindItemBack");
            this.searchPanel.objectSelected.connect((Object)this, "gotFoundItem");
        }
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.getCurrentAccount());
        this.searchPanel.startSearch(context, this.gui.getDisplayingGroup(), (boolean)resetSearch);
        ScreenResource.startModalWindow((JPanel)this.searchPanel);
    }

    void gotFindItemBack() {
        ScreenResource.stopWindow((JComponent)this.searchPanel);
        this.display();
    }

    void gotFoundItem(Account account, InventoryItem item) {
        if (account != this.getCurrentAccount()) {
            throw new IllegalArgumentException("Recieved different account from find item : " + account + " != " + this.getCurrentAccount());
        }
        if (item != null) {
            this.itemOrderedFromSearch = true;
            this.gotNewItem(item);
        }
    }

    public void gotFoundItem(Object item) {
        ScreenResource.stopWindow((JComponent)this.searchPanel);
        this.gotFoundItem((Account)this.getCurrentAccount(), (InventoryItem)item);
    }

    void gotItemOrderingComplete() {
        this.itemOrderedFromSearch = false;
    }

    void gotAddItemDone() {
        this.currentSaleLineItems = new ArrayList<SalesLineItem>();
        this.currentSaleLineItems.addAll(this.getCurrentAccount().getItemHelper().getUnpaidItems());
        this.bistroModeHelper.setCurrentSaleLineItems(this.currentSaleLineItems);
        if (this.inBistroMode) {
            this.resetFinanceInfo();
        }
        if (this.itemOrderedFromSearch) {
            this.itemOrderedFromSearch = false;
            this.gotFindItem(Boolean.FALSE);
        } else {
            this.display();
            this.gui.showLastPage();
        }
    }

    public String getTabName() {
        return this.currentName;
    }

    public void setCurrentName(String name) {
        String oldVal = this.currentName;
        this.currentName = name;
        this.pcs.firePropertyChange(QUICKSALE_TAB_NAME_PROP, oldVal, name);
    }

    public boolean isEmpty() {
        if (this.getCurrentAccount() != null) {
            return !this.getCurrentAccount().hasSellables();
        }
        return true;
    }

    public void lock(User user) {
        this.quickSaleUser = user;
        this.setCurrentName(user.getFirstName());
    }

    public void unlock() {
        this.quickSaleUser = null;
        this.setCurrentName(this.unlockedName);
    }

    public boolean isLockedBy(User user) {
        if (this.isLocked()) {
            return this.quickSaleUser.equals((Object)user);
        }
        return false;
    }

    public boolean isLocked() {
        return this.quickSaleUser != null;
    }

    public User getLockingUser() {
        return this.quickSaleUser;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentAccount(TakeawayAccount account) {
        if (account != null) {
            QuickSale quickSale = this;
            synchronized (quickSale) {
                if (this.currentAccount != account) {
                    this.debtorTransactionManager = null;
                }
                this.currentAccount = account;
            }
            this.setupScreen();
        } else {
            this.newAccount();
        }
    }

    public void setPrintLastEnabled(Boolean value) {
        this.nav.setPrintLastEnabled(value);
    }

    private void emitAccountChanged() {
        this.accountChanged.emit((Object)this.getCurrentAccount(), (Object)this.quickSaleUser);
        WaitermateAccountGui.getInstance().accountChanged((Account)this.getCurrentAccount());
    }

    public boolean isMoved() {
        return this.moved;
    }

    public void setMoved(boolean isMoved) {
        this.moved = isMoved;
    }

    @Override
    public List<AccountType> getAccountTypes() {
        return Arrays.asList(TakeawayAccount.TYPE);
    }

    public void gotCreditPay(FinanceUnit unit) {
        if (this.preTransaction()) {
            FinanceTransaction transaction = null;
            FinanceUnit chosenUnit = null;
            boolean surcharged = true;
            if (AdyenIntegrationConfig.getInstance().isConfigured()) {
                chosenUnit = FinanceUnit.getDefaultUnitFor((FinanceUnit.FinanceUnitType)FinanceUnit.CREDIT_TYPE);
            } else {
                ConfirmFinanceUnit confirm = new ConfirmFinanceUnit((Account)this.currentAccount, FinanceUnit.getCardPayableUnits());
                chosenUnit = confirm.confirmUnit(unit);
                surcharged = confirm.isSurcharged();
            }
            if (chosenUnit == null) {
                return;
            }
            Price surcharge = Price.ZERO_DOLLAR;
            if (surcharged) {
                surcharge = FinanceSurchargeCalculator.calculateSurcharge((Price)this.currentAccount.getDue(), (Price)Price.ZERO_DOLLAR, (FinanceUnit)chosenUnit);
            }
            Price toPay = this.currentAccount.getDue().add(surcharge);
            if (chosenUnit.getType().equals(FinanceUnit.CREDIT_TYPE.toString())) {
                transaction = this.transactionFactory.createCreditTransaction(LoginManager.getEventContext(), toPay, Price.ZERO_DOLLAR, unit);
            } else if (chosenUnit.getType().equals(FinanceUnit.DEBIT_TYPE.toString())) {
                transaction = this.transactionFactory.createDebitTransaction(LoginManager.getEventContext(), toPay, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, unit);
            } else {
                throw new IllegalArgumentException("Unsupported electronic type : " + unit + " type: " + unit.getType());
            }
            transaction.setSurcharge(surcharge);
            this.eftposController.performTransaction((EftposTransaction)transaction, false, (Payable)this.getCurrentAccount());
        }
    }

    public void gotPayPalPay() {
        if (!Terminal.getLocalHost().showQuickOrderInfoButton() && !WaitermateSaveAccount.getInstance().getTicketData((Account)this.getCurrentAccount())) {
            return;
        }
        this.webPay = new WaitermateWebPayment();
        this.webPay.done.connect((Object)this, "gotWebPayDone");
        this.webPay.startQuicksaleProcess((Payable)this.currentAccount, WebPaymentType.PayPal);
    }

    public void gotWebPayDone(FinanceTransaction txn) {
        this.webPay.done.disconnect((Object)this);
        this.postTransaction(txn);
        this.closeAccount();
    }

    public void gotVoucherPay() {
        if (!Terminal.getLocalHost().showQuickOrderInfoButton() && !WaitermateSaveAccount.getInstance().getTicketData((Account)this.getCurrentAccount())) {
            return;
        }
        this.voucherPay = new VoucherPayment();
        this.voucherPay.done.connect((Object)this, "gotVoucherPaymentDone");
        this.voucherPay.startQuicksaleProcess((Payable)this.currentAccount);
    }

    public void gotVoucherPaymentDone(FinanceTransaction txn) {
        this.voucherPay.done.disconnect((Object)this);
        this.postTransaction(txn);
        this.closeAccount();
    }

    public void gotEftposAdded(EftposTransaction txn) {
        if ("ACTIVE".equals(txn.getSystemState())) {
            FinanceSurchargeCalculator.applySurcharge((Payable)this.currentAccount, (FinanceUnit)txn.getSubType(), (Price)txn.getSurcharge(), (EventContext)LoginManager.getEventContext());
        }
    }

    public void gotEftposRemoved(EftposTransaction txn) {
        FinanceSurchargeCalculator.removeSurcharge((Payable)this.currentAccount, (Price)txn.getSurcharge(), (EventContext)LoginManager.getEventContext(), (FinanceUnit)txn.getSubType());
    }

    public void gotEftposFinished(EftposTransaction txn) {
        this.updateFinanceInfo((FinanceTransaction)txn);
        this.postTransaction((FinanceTransaction)txn);
        if (this.getCurrentAccount().getDue().approximatelyEquals(Price.ZERO_DOLLAR)) {
            this.closeAccount();
        }
    }

    void gotCustomerCard(CustomerCard card) {
        if (this.isDisplaying() && this.getCurrentAccount() != null) {
            if (!SystemState.ACTIVE_STATE.equals((Object)card.getSystemState())) {
                Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THAT_CARD_HAS_BEEN_SET_TO_INACTIVE"), (String)Internationalization.getLiteralFor((String)"INACTIVE_CARD"));
                return;
            }
            if (!card.getCardId().equals(this.getCurrentAccount().getCardId())) {
                this.getCurrentAccount().setCardId(card.getCardId());
                this.gui.showAccount((Account)this.getCurrentAccount());
                this.setupNavButtons();
                WaitermateAccountGui.getInstance().accountChanged((Account)this.getCurrentAccount());
            }
        }
    }

    void gotPayToCard() {
        if (this.getCurrentAccount() != null && !this.getCurrentAccount().getItems().isEmpty()) {
            CustomerCardHelper helper = new CustomerCardHelper();
            CustomerCard card = helper.getCardByCardId(this.getCurrentAccount().getCardId());
            if (card == null) {
                OrderMate.LOG.warn("Should not be able to pay to a card if no card is present.");
                return;
            }
            if (!helper.transferToBarTab(card, (Account)this.getCurrentAccount(), LoginManager.getEventContext(), (SaveAccount)WaitermateSaveAccount.getInstance())) {
                Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"THE_CURRENT_BARTAB_FOR") + " " + helper.getNeatString(card) + " " + Internationalization.getLiteralFor((String)"IS_CURRENTLY_LOCKED_TO_ANOTHER_USER")), (String)Internationalization.getLiteralFor((String)"CANNOT_TRANSFER_TO_TAB"));
            } else {
                this.closeAccount();
            }
            this.gui.showAccount((Account)this.getCurrentAccount());
        }
    }

    void gotPayByLoyalty() {
        if (!Terminal.getLocalHost().showQuickOrderInfoButton() && !WaitermateSaveAccount.getInstance().getTicketData((Account)this.getCurrentAccount())) {
            return;
        }
        if (this.cashTransaction != null) {
            this.getCurrentAccount().removeFinanceTransaction(this.cashTransaction);
            this.cashTransaction = null;
        }
        this.nav.setEnableQuickEftpos(true);
        if (!this.getCurrentAccount().getItems().isEmpty()) {
            this.loyaltyScreen.startRedeemingItems((ItemGroup)this.getCurrentAccount());
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_TO_PAY_OFF"), (String)Internationalization.getLiteralFor((String)"NO_ITEMS"));
        }
    }

    void gotLoyaltyDone() {
        if (this.getCurrentAccount().getDue().isZero()) {
            this.closeAccount();
        }
    }

    void gotCustomerMessage() {
        if (WaiterMateCustomerDisplay.isActive()) {
            WaiterMateCustomerDisplay.getInstance().sendMessage();
        }
    }

    public void tearDown() {
        WaiterMateInputAdapter.getInstance().enableUnknownCardHandler(false);
        super.tearDown();
    }

    void gotChangeToDineIn() {
        this.currentAccount.replaceTicketData(WaiterMateTicketData.TAKE_AWAY, WaiterMateTicketData.DINE_IN);
        this.changeAccountType(AccountType.quickSaleDineInType);
    }

    void gotChangeToTakeaway() {
        this.currentAccount.replaceTicketData(WaiterMateTicketData.DINE_IN, WaiterMateTicketData.TAKE_AWAY);
        this.changeAccountType(AccountType.takeawayType);
    }

    private void changeAccountType(AccountType type) {
        this.currentAccount.setAccountType(type);
        if (this.getCurrentAccount().getAllItems().size() > 0) {
            this.gui.showAccount((Account)this.getCurrentAccount());
        } else {
            this.gui.newAccount((Account)this.getCurrentAccount());
        }
        if (this.currentAccount.requiresTicketDataEatIn(Terminal.getLocalHost()) && this.isPresetDineInTakeAway()) {
            String typeString = type.equals((Object)AccountType.takeawayType) ? WaiterMateTicketData.TAKE_AWAY : WaiterMateTicketData.DINE_IN;
            this.currentAccount.clearTicketData();
            this.currentAccount.addToTicketData(typeString);
            this.currentAccount.setRequiresEatInTicket(false);
        }
        WaitermateAccountGui.getInstance().accountChanged((Account)this.getCurrentAccount());
    }

    public void gotCouponScanned(String uniqueId) {
        if (!this.isDisplaying()) {
            return;
        }
        WaiterMateCoupons coupons = new WaiterMateCoupons((Account)this.getCurrentAccount());
        coupons.getRedeemDoneSignal().disconnect((Object)this);
        coupons.getRedeemDoneSignal().connect((Object)this, "gotCouponRedeemDone");
        coupons.gotCoupon(uniqueId);
    }

    public void gotCouponRedeemDone(Boolean success) {
        WaiterMateCoupons coupons = new WaiterMateCoupons((Account)this.getCurrentAccount());
        coupons.getRedeemDoneSignal().disconnect((Object)this);
        this.display();
    }

    private DebtorTransactionManager getTransactionManager() {
        if (this.debtorTransactionManager == null || this.debtorTransactionManager.isFinalised()) {
            this.debtorTransactionManager = new DebtorTransactionManager((Payable)this.currentAccount, (GuiHandler)new WaitermateGuiHandler());
        }
        return this.debtorTransactionManager;
    }

    public void gotResyncPoints() {
        Customer customer;
        if (this.currentAccount != null && (customer = this.currentAccount.getCustomer()) != null) {
            ProgressDialog.doProgressDialog((Task)new AbstractTask(){

                public String getName() {
                    return "Synchronising Customer Points";
                }

                protected void performTask() throws Exception {
                    final boolean allGood = LoyaltyPointAdministrator.getInstance().resynchPointsForCustomer(customer);
                    if (allGood) {
                        customer.getCustomerPoints().save();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (allGood) {
                                Dialogs.displayOkDialog((String)("The Customer Points have been synchronised: " + customer.getLoyaltyPoints()), (String)"Customer Points Synchronised");
                            } else {
                                Dialogs.displayOkDialog((String)"The Customer Points could not be synchronised. Please try again later.", (String)"Cannot Synchronise Customer Points");
                            }
                            QuickSale.this.setupScreen();
                        }
                    });
                }

                protected int getTotalSubTasks() {
                    return -1;
                }
            });
        }
    }

    public void relayoutNav() {
        this.nav.relayout();
    }
}

