/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.image.IconLoader;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import ordermate.OrderMate;
import ordermate.database.Lockable;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalMode;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.logging.log4j.Level;
import waitermate.LoginManager;
import waitermate.gui.dialogs.UnlockDialog;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.SelectAccount;
import waitermate.gui.screens.selectaccount.quicksale.QuickSale;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.TabScreen;
import waitermate.guikit.dialogs.ProgressDialog;

public class QuickSaleController {
    private final SelectAccount selectAccount;
    private final LockPanel lockPanel = new LockPanel();
    private final QuickSale emptyQuickSale;
    private final List<QuickSale> quickSaleScreens = new ArrayList<QuickSale>();
    private QuickSale currentUserQuicksale;
    private static QuickSaleController instance = null;
    private Account previousAccount;
    private Signal<Boolean, ?, ?, ?, ?> printEnabled = Signals.createSignal(Boolean.class, (String)"enabled");

    public static QuickSaleController init(SelectAccount sa) {
        if (instance != null) {
            instance.disconnect();
        }
        instance = new QuickSaleController(sa);
        return instance;
    }

    public static QuickSaleController getInstance() {
        return instance;
    }

    private QuickSaleController(SelectAccount selectAccountController) {
        this.selectAccount = selectAccountController;
        this.selectAccount.tabChange.connect((Object)this, "gotTabChanged");
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotUserLogin");
        LoginManager.getInstance().logout.connect((Object)this, "gotLogout");
        NotificationManager.getInstance().noUser.connect((Object)this, "gotNoUser");
        this.emptyQuickSale = this.createQuickSale(new TerminalMode("Quick Sale"));
        this.quickSaleScreens.remove((Object)this.emptyQuickSale);
        this.initPreviousAccount();
        this.selectAccount.addQuickSale(this.emptyQuickSale);
    }

    private void disconnect() {
        this.selectAccount.tabChange.disconnect((Object)this);
        NotificationManager.getInstance().newUserSignal.disconnect((Object)this);
        LoginManager.getInstance().logout.disconnect((Object)this);
        NotificationManager.getInstance().noUser.disconnect((Object)this);
    }

    public QuickSale createQuickSale(TerminalMode mode) {
        QuickSale newQuickSale = new QuickSale();
        this.quickSaleScreens.add(newQuickSale);
        newQuickSale.payToTab.connect((Object)this, "gotPayToTab");
        Terminal myTerminal = Terminal.getLocalHost();
        if (myTerminal.getNumQuickSale() == 1 || !mode.getLabel().equals("Quick Sale")) {
            newQuickSale.setUnlockedName(mode.getLabel());
        } else {
            newQuickSale.setUnlockedName("QS " + this.quickSaleScreens.size());
        }
        this.setUpQuickSale(newQuickSale);
        return newQuickSale;
    }

    protected void gotPayToTab(final QuickSale quickSale, final BarTabAccount barTab) {
        this.emptyQuickSale.display();
        this.gotTabChanged(this.emptyQuickSale);
        this.selectAccount.removeQuickSale(quickSale);
        quickSale.lock(User.getSystemAdministrator());
        new SwingWorker<QuickSale, Object>(){
            final long startTime = System.nanoTime();

            @Override
            protected QuickSale doInBackground() throws Exception {
                TakeawayAccount currentAccount = quickSale.getCurrentAccount();
                WaitermateSaveAccount.getInstance().saveAndTransferToBarTabAccount(barTab, (Account)currentAccount, currentAccount.getItemHelper().getUnpaidItems(), LoginManager.getEventContext(), false);
                for (SalesLineItem item : currentAccount.getAllItems()) {
                    item.markPrinted();
                }
                return quickSale;
            }

            /*
             * Exception decompiling
             */
            @Override
            protected void done() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }.execute();
    }

    public void gotTabChanged(TabScreen currentScreen) {
        QuickSale quickSale;
        User user = LoginManager.getInstance().getUser();
        if (currentScreen instanceof QuickSale && (quickSale = (QuickSale)currentScreen) == this.emptyQuickSale) {
            if (this.getQuickSalesForUser(user).size() == 0) {
                quickSale.showQuickLogOut();
                return;
            }
            this.currentUserQuicksale = this.findEmptyQuickSale(user);
            this.selectQuickSale(this.currentUserQuicksale, user);
            return;
        }
        this.displayLockPanel(currentScreen, user);
    }

    public void gotUserLogin(User user) {
        List<QuickSale> quickSales = this.getQuickSalesForUser(user);
        if (quickSales.size() == 0) {
            this.currentUserQuicksale = this.findEmptyQuickSale(user);
        } else if (quickSales.size() > 0) {
            this.currentUserQuicksale = quickSales.get(0);
        }
        if (this.selectAccount.getCurrentState() instanceof QuickSale) {
            this.selectQuickSale(this.currentUserQuicksale, user);
            boolean wasVisible = this.currentUserQuicksale.stopQuickLogout();
            if (wasVisible && Terminal.getLocalHost().getHasAutoMenuSelect() && !Terminal.getLocalHost().getQuickSaleSingleScreenOrdering()) {
                this.currentUserQuicksale.autoMenuSelect();
            }
        }
        this.cleanEmptyQuickSales();
        this.currentUserQuicksale.setUp();
    }

    public void gotLogout() {
        QuickSale currentScreen;
        this.currentUserQuicksale = null;
        TabScreen screen = this.selectAccount.getCurrentState();
        if (screen instanceof QuickSale && (currentScreen = (QuickSale)screen).isEmpty()) {
            currentScreen.getCurrentAccount().clearCustomerFields(LoginManager.getEventContext());
            currentScreen.unlock();
        }
    }

    public void gotNoUser() {
    }

    private void initPreviousAccount() {
        AccountSearcher searcher = new AccountSearcher(1, null);
        searcher.getTerminalSearch().setSearchValue(Arrays.asList(Terminal.getLocalHost()));
        searcher.getAccountTypeListSearch().setSearchValue((Object)AccountType.takeawayType);
        searcher.setFinanceShift(LoginManager.getEventContext().getShift());
        List list = PersistenceManager.getObjectList((ObjectQuerySearcher)searcher);
        if (list != null && list.size() > 0) {
            this.gotPreviousAccount((Account)list.get(0));
        } else {
            this.gotPreviousAccount(null);
        }
    }

    private void displayLockPanel(TabScreen screen, User user) {
        if (this.lockPanel.getParent() == null && screen.getMainArea().getRootPane() != null) {
            screen.getMainArea().getRootPane().getLayeredPane().add(this.lockPanel);
        }
        if (screen instanceof QuickSale) {
            QuickSale quickSale = (QuickSale)screen;
            TakeawayAccount account = quickSale.getCurrentAccount();
            if (account != null && quickSale.isDisplaying() && !quickSale.isLockedBy(account.getUser()) && account.isPersistent()) {
                UnlockDialog dialog = new UnlockDialog();
                dialog.displayLockInfo((Lockable)account, account.getLabel());
                this.selectQuickSale(this.emptyQuickSale, user);
                return;
            }
            if (!quickSale.isLockedBy(user) && quickSale.getLockingUser() != null) {
                Point location = quickSale.getLocationRelativeToRootPane();
                Dimension size = quickSale.getSize();
                this.lockPanel.setBounds(new Rectangle(location.x, location.y, size.width, size.height));
                this.lockPanel.setUser(quickSale.getLockingUser());
                this.lockPanel.setVisible(true);
                this.lockPanel.validate();
                return;
            }
        }
        this.lockPanel.setVisible(false);
    }

    private void cleanEmptyQuickSales() {
        for (QuickSale quickSale : this.quickSaleScreens) {
            if (!quickSale.isEmpty() || quickSale == this.currentUserQuicksale) continue;
            quickSale.unlock();
            this.selectAccount.removeQuickSale(quickSale);
        }
    }

    public void refreshEmptyQuickSales() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuickSaleController.this.doRefreshEmptyQuickSales();
                }
            });
        } else {
            this.doRefreshEmptyQuickSales();
        }
    }

    private void doRefreshEmptyQuickSales() {
        OrderMate.LOG.info("Refreshing Empty QuickSales");
        for (QuickSale quickSale : this.quickSaleScreens) {
            if (!quickSale.isEmpty()) continue;
            try {
                quickSale.unlock();
                quickSale.newAccount();
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "Error refreshing QuickSale", (Throwable)ex);
            }
        }
    }

    public QuickSale getFirstQuickSale() {
        return this.quickSaleScreens.get(0);
    }

    private List<QuickSale> getQuickSalesForUser(User user) {
        ArrayList<QuickSale> usersQuickSales = new ArrayList<QuickSale>();
        for (QuickSale currentScreen : this.quickSaleScreens) {
            if (!currentScreen.isLockedBy(user)) continue;
            usersQuickSales.add(currentScreen);
        }
        return usersQuickSales;
    }

    private void selectQuickSale(QuickSale quickSaleScreen, User user) {
        this.selectAccount.setActiveQuickSale(quickSaleScreen);
        this.displayLockPanel(quickSaleScreen, user);
    }

    private QuickSale findEmptyQuickSale(User user) {
        for (QuickSale quickSale : this.quickSaleScreens) {
            if (!quickSale.isEmpty() || !quickSale.isLockedBy(user)) continue;
            return quickSale;
        }
        for (QuickSale quickSale : this.quickSaleScreens) {
            if (quickSale.isLocked()) continue;
            quickSale.lock(user);
            if (!this.selectAccount.hasScreen(quickSale)) {
                this.selectAccount.addQuickSale(quickSale);
            }
            return quickSale;
        }
        ProgressDialog.doProgressDialog((Task)new AbstractTask(){

            public String getName() {
                return Internationalization.getLiteralFor((String)"CREATE_MORE_QUICKSALES");
            }

            protected int getTotalSubTasks() {
                return 5;
            }

            protected void performTask() throws Exception {
                for (int i = 0; i < 3; ++i) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            QuickSaleController.this.createQuickSale(new TerminalMode("Quick Sale"));
                        }
                    });
                    this.emitProgress();
                }
            }
        });
        return this.findEmptyQuickSale(user);
    }

    private void setUpQuickSale(QuickSale quickSale) {
        NavBar nav = quickSale.getNavBar();
        nav.admin.connect((Object)this.selectAccount.admin, "emit");
        nav.logout.connect((Object)this.selectAccount.back, "emit");
        quickSale.logout.connect((Object)this.selectAccount.back, "emit");
        quickSale.changed.connect((Object)this.selectAccount, "gotQuickSaleChanged");
        quickSale.prevAccount.connect((Object)this, "gotPreviousAccount");
        quickSale.printLast.connect((Object)this, "gotPrintLastReceipt");
        this.printEnabled.connect((Object)quickSale, "setPrintLastEnabled");
        quickSale.setPrintLastEnabled(this.previousAccount != null);
    }

    private void gotPreviousAccount(Account newAccount) {
        if (newAccount != null) {
            this.previousAccount = newAccount;
            this.printEnabled.emit((Object)Boolean.TRUE);
        }
    }

    protected void gotPrintLastReceipt() {
        try {
            if (this.previousAccount != null) {
                boolean locked;
                if (this.previousAccount.isPersistent()) {
                    this.previousAccount = (Account)PersistenceManager.reacquire((PersistentObjectI)this.previousAccount);
                }
                if (locked = WaitermateSaveAccount.getInstance().lockAccount((Lockable)this.previousAccount)) {
                    WaitermateSaveAccount.getInstance().printReceiptDockets((ItemGroup)this.previousAccount);
                    this.previousAccount.unlock();
                }
            }
        }
        catch (Exception e) {
            WaitermateSaveAccount.getInstance().handlePrinterError(e, "account " + this.previousAccount.getLabel());
        }
    }

    public void removeAllQuicksales() {
        ArrayList<QuickSale> quickies = new ArrayList<QuickSale>(this.quickSaleScreens);
        for (QuickSale quicksale : quickies) {
            quicksale.unlock();
            this.selectAccount.removeQuickSale(quicksale);
        }
        this.quickSaleScreens.clear();
        this.currentUserQuicksale = null;
    }

    public void relayoutNavs() {
        ArrayList<QuickSale> quickies = new ArrayList<QuickSale>(this.quickSaleScreens);
        for (QuickSale quicksale : quickies) {
            quicksale.relayoutNav();
            quicksale.setCurrentAccount(null);
        }
        this.emptyQuickSale.relayoutNav();
    }

    public void resetAllQSAccounts() {
        ArrayList<QuickSale> quickies = new ArrayList<QuickSale>(this.quickSaleScreens);
        for (QuickSale quicksale : quickies) {
            quicksale.setCurrentAccount(null);
        }
        this.emptyQuickSale.relayoutNav();
    }

    private class LockPanel
    extends JPanel
    implements ActionListener {
        private String labelText;
        private final JLabel label;
        private final StandardSecurityDecorator unlockButton;

        public LockPanel() {
            super(new GridBagLayout());
            this.labelText = Internationalization.getLiteralFor((String)"QUICK_SALE_IS_LOCKED_BY") + " ";
            this.label = new JLabel(this.labelText);
            this.unlockButton = new StandardSecurityDecorator((JComponent)new JButton(Internationalization.getLiteralFor((String)"UNLOCK"), IconLoader.get((String)"/waitermate/images/lock.png")), AllPermissions.QUICK_SALE_OVERRIDE);
            this.setOpaque(false);
            JPanel centralPanel = new JPanel(new BorderLayout());
            centralPanel.add((Component)this.label, "Center");
            this.label.setFont(OrderMateTheme.getLargeFont());
            this.label.setForeground(Color.WHITE);
            ((JButton)this.unlockButton.getDecorateComponent()).addActionListener(this);
            centralPanel.add((Component)this.unlockButton, "South");
            centralPanel.setOpaque(false);
            this.add((Component)centralPanel, new GridBagConstraints());
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    e.consume();
                }
            });
        }

        public void setUser(User user) {
            this.label.setText(this.labelText + user.getName());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (LoginManager.getInstance().getUser().hasPermission(AllPermissions.QUICK_SALE_OVERRIDE) && QuickSaleController.this.selectAccount.getCurrentState() instanceof QuickSale) {
                QuickSale quickSale = (QuickSale)QuickSaleController.this.selectAccount.getCurrentState();
                this.transferAccountToNewUser(quickSale);
                quickSale.setUp();
                this.setVisible(false);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
            g2.setColor(new Color(0, 0, 0));
            Rectangle bounds = this.getBounds();
            g2.fillRect(0, 0, bounds.width, bounds.height);
            g2.setComposite(oldComposite);
            super.paintComponent(g2);
        }

        private void transferAccountToNewUser(QuickSale quickSale) {
            quickSale.lock(LoginManager.getInstance().getUser());
        }
    }
}

