/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.ComponentDecorator;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.QuickSaleButtonId;
import ordermate.database.hardware.QuickSaleNavConfig;
import ordermate.database.hardware.QuickSaleNavInfo;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.integration.eftpos.manager.EftposManager;
import ordermate.internationalization.Internationalization;
import ordermate.internationalization.base.LocalizationProvider;
import ordermate.internationalization.base.MonetaryObject;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import ordermate.startup.OrderMateSetupException;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.swingx.VerticalLayout;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.accountitems.PriceLevelList;
import waitermate.gui.screens.selectaccount.quicksale.ButtonParams;
import waitermate.gui.screens.selectaccount.quicksale.PreviousSalesListPanel;
import waitermate.gui.screens.selectaccount.quicksale.QuickSaleNavPriceLevelsHandler;
import waitermate.gui.screens.selectaccount.quicksale.SelectQuickTabTypePanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.animator.PathMapper;
import waitermate.guikit.animator.QuadraticPathMapper;
import waitermate.guikit.animator.SimpleMotionBoundsAnimator;
import waitermate.guikit.components.DrawerToggleButton;
import waitermate.guikit.dialogs.Dialogs;

public class QuickSaleNav
extends NavBar
implements ActionListener {
    private final int BUTTON_WIDTH;
    public final Signal<Price, ?, ?, ?, ?> addCash = Signals.createSignal(Price.class, (String)"amount");
    public final Signal quickPay = Signals.createSignal();
    public final Signal pay = Signals.createSignal();
    public final Signal cashdrawer = Signals.createSignal();
    public final Signal printLast = Signals.createSignal();
    public final Signal quickTabPay = Signals.createSignal();
    public final Signal tabPay = Signals.createSignal();
    public final Signal customerDebtorPay = Signals.createSignal();
    public final Signal roomAccountPay = Signals.createSignal();
    public final Signal discount = Signals.createSignal();
    public final Signal customer = Signals.createSignal();
    public final Signal printOrder = Signals.createSignal();
    public final Signal showOrder = Signals.createSignal();
    public final Signal<PriceLevel, Boolean, ?, ?, ?> usePriceLevel = Signals.createSignal(PriceLevel.class, (String)"toUse", Boolean.class, (String)"showDialog");
    public final Signal useCheapestPriceLevels = Signals.createSignal();
    public final Signal ticketData = Signals.createSignal();
    public final Signal<Account, ?, ?, ?, ?> showPreviousAccount = Signals.createSignal(Account.class, (String)"account");
    public final Signal makeCombo = Signals.createSignal();
    public final Signal quickTransfer = Signals.createSignal();
    public final Signal<Boolean, ?, ?, ?, ?> findItem = Signals.createSignal(Boolean.class, (String)"resetSearch");
    public final Signal<FinanceUnit, ?, ?, ?, ?> creditPay = Signals.createSignal(FinanceUnit.class, (String)"financeUnit");
    public final Signal payToCard = Signals.createSignal();
    public final Signal payPalPay = Signals.createSignal();
    public final Signal payByLoyalty = Signals.createSignal();
    public final Signal customerMessage = Signals.createSignal();
    public final Signal changeToDineIn = Signals.createSignal();
    public final Signal changeToTakeaway = Signals.createSignal();
    public final Signal payToDebtor = Signals.createSignal();
    public final Signal voucherPay = Signals.createSignal();
    public final Signal purchaseVoucher = Signals.createSignal();
    private final List<JButton> notes;
    private final List<JButton> coins;
    private StandardSecurityDecorator quickEftposButton;
    private StandardSecurityDecorator amexButton;
    private StandardSecurityDecorator dinersButton;
    private StandardSecurityDecorator mastercardButton;
    private StandardSecurityDecorator visaButton;
    private StandardSecurityDecorator eftposButton;
    private StandardSecurityDecorator payPalButton;
    private StandardSecurityDecorator voucherPayButton;
    private final StandardSecurityDecorator quickPayButton;
    private final StandardSecurityDecorator payButton;
    private final StandardSecurityDecorator printLastReceipt;
    private final StandardSecurityDecorator tabPayButton;
    private final StandardSecurityDecorator loyaltyButton;
    private final AbstractButton customerMessageButton;
    private final AbstractButton orderInfoButton;
    private final StandardSecurityDecorator showOrderButton;
    private final StandardSecurityDecorator printOrderDecorator;
    private final DrawerToggleButton priceLevelButton;
    private final StandardSecurityDecorator priceLevelSecurity;
    private final PriceLevelList priceLevelList;
    private final DrawerToggleButton previousSales;
    private final PreviousSalesListPanel previousSalesListPanel;
    private final AbstractButton makeComboButton;
    private final StandardSecurityDecorator quickTransferButton;
    private final AbstractButton findItemButton;
    private final StandardSecurityDecorator noSaleButton;
    private final StandardSecurityDecorator payToCardButton;
    private final AbstractButton quickDebtor;
    private final StandardSecurityDecorator purchaseVoucherButton;
    private final CustomerCardHelper customerCardHelper;
    private final AbstractButton dineInSaleBtn;
    private final AbstractButton takeawaySaleBtn;
    private final Insets dummyInsets = new Insets(0, 0, 0, 0);
    private final Insets buttonInsets = new Insets(0, 0, 0, 0);
    private static final int PAGEONE = 1;
    private static final int PAGETWO = 2;
    private int currentPage;
    private final JButton upButton;
    private final JButton downButton;
    private final JComponent left;
    private final Map<QuickSaleButtonId, JComponent> buttonsMap = new EnumMap<QuickSaleButtonId, JComponent>(QuickSaleButtonId.class);
    private boolean oneTouchPayment;
    private TakeawayAccount account;
    private final Terminal terminal = Terminal.getLocalHost();
    private Animator navOverlayAnimator;
    private JPanel navOverlay;
    private final JPanel rightPage1 = new JPanel();
    private final JPanel rightPage2 = new JPanel();
    private QuickSaleNavPriceLevelsHandler priceLevelHandler;

    public QuickSaleNav() {
        this.customerCardHelper = new CustomerCardHelper();
        QuickSaleNavConfig navConfig = this.terminal.getQuickSaleNavConfig();
        if (navConfig == null) {
            throw new OrderMateSetupException(null, "QuickSale does not have nav bar configuration", new String[]{"Assign a nav bar config to this terminal in OfficeMate under WaiterMate properties."}, true);
        }
        this.BUTTON_WIDTH = navConfig.getButtonWidth().getPixelWidth();
        this.left = new JPanel((LayoutManager)new GraphPaperLayout(1, 2));
        this.left.setOpaque(false);
        Box leftBoxTop = new Box(0);
        Box leftBoxBottom = new Box(0);
        this.getRightBox().setLayout((LayoutManager)new VerticalLayout(0));
        this.left.add((Component)leftBoxTop, new Rectangle(0, 0, 1, 1));
        this.left.add((Component)leftBoxBottom, new Rectangle(0, 1, 1, 1));
        this.addLeft(this.left);
        this.coins = new ArrayList<JButton>();
        LocalizationProvider provider = Internationalization.getActiveResourceBundleForMoney();
        if (provider != null) {
            Iterator<Object> basePathForIcons = provider.getBasePathForIcons();
            for (MonetaryObject coinage : provider.getAllCoins()) {
                this.coins.add(this.constructMoneyButton(IconLoader.get((String)((String)((Object)basePathForIcons) + coinage.getIconPath())), coinage.getIconCaption(), this.dummyInsets));
            }
        } else {
            this.coins.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/fiveCents.png"), "0.05", this.dummyInsets));
            this.coins.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/tenCents.png"), "0.10", this.dummyInsets));
            this.coins.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/twentyCents.png"), "0.20", this.dummyInsets));
            this.coins.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/fiftyCents.png"), "0.50", this.dummyInsets));
            this.coins.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/oneDollar.png"), "1.00", this.dummyInsets));
            this.coins.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/twoDollars.png"), "2.00", this.dummyInsets));
        }
        for (JButton nextCoin : this.coins) {
            int coinWidth = 65;
            leftBoxTop.add(nextCoin);
            nextCoin.setPreferredSize(new Dimension(coinWidth, ScreenResource.getNavHeight() / 2));
            nextCoin.setMinimumSize(new Dimension(coinWidth, ScreenResource.getNavHeight() / 2));
            nextCoin.setMaximumSize(new Dimension(coinWidth, ScreenResource.getNavHeight() / 2));
        }
        this.notes = new ArrayList<JButton>();
        if (provider != null) {
            for (MonetaryObject bills : provider.getAllNotes()) {
                this.notes.add(this.constructMoneyButton(IconLoader.get((String)(provider.getBasePathForIcons() + bills.getIconPath())), bills.getIconCaption(), this.dummyInsets));
            }
        } else {
            this.notes.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/fiveDollars.png"), "5.00", this.dummyInsets));
            this.notes.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/tenDollars.png"), "10.00", this.dummyInsets));
            this.notes.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/twentyDollars.png"), "20.00", this.dummyInsets));
            this.notes.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/fiftyDollars.png"), "50.00", this.dummyInsets));
            this.notes.add(this.constructMoneyButton(IconLoader.get((String)"/waitermate/images/hundredDollars.png"), "100.00", this.dummyInsets));
        }
        for (JButton nextNote : this.notes) {
            leftBoxBottom.add(nextNote);
            int noteWidth = 78;
            nextNote.setPreferredSize(new Dimension(noteWidth, ScreenResource.getNavHeight() / 2));
            nextNote.setMinimumSize(new Dimension(noteWidth, ScreenResource.getNavHeight() / 2));
            nextNote.setMaximumSize(new Dimension(noteWidth, ScreenResource.getNavHeight() / 2));
        }
        this.loyaltyButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"LOYALTY")).icon("/waitermate/images/loyalty.png").name("loyalty").permission(AllPermissions.PAY_TO_LOYALTY).signal(this.payByLoyalty).buttonId(QuickSaleButtonId.loyalty));
        this.voucherPayButton = this.constructPermissionedButton(new ButtonParams(this).text("Redeem").name("voucherPay").icon("/waitermate/images/voucher.png").buttonId(QuickSaleButtonId.voucherPay).signal(this.voucherPay).permission(AllPermissions.PAY));
        this.customerMessageButton = this.constructButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"CUSTOMER_MESSAGE")).icon("/waitermate/images/barcode.png").signal(this.customerMessage).buttonId(QuickSaleButtonId.customerMessage));
        this.quickPayButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"QUICK_PAY")).icon("/waitermate/images/fastPay.png").name("fastCash").permission(AllPermissions.PAY).signal(this.quickPay).buttonId(QuickSaleButtonId.fastCash));
        this.payButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"PAY")).name("Pay").icon("/waitermate/images/pay.png").buttonId(QuickSaleButtonId.Pay).signal(this.pay).permission(AllPermissions.PAY));
        this.orderInfoButton = this.constructButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"ORDER_INFO")).name("ticketData").icon("/waitermate/images/tablet.png").buttonId(QuickSaleButtonId.ticketData));
        this.noSaleButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"NO_SALE")).name("cashdrawer").icon("/waitermate/images/nosale.png").permission(AllPermissions.CASHDRAWER).buttonId(QuickSaleButtonId.cashdrawer).signal(this.cashdrawer));
        this.downButton = this.constructButton(IconLoader.get((String)"/waitermate/images/down.png"), "", "down");
        this.downButton.setMargin(this.buttonInsets);
        this.downButton.setBorder(new BevelBorder(0));
        this.upButton = this.constructButton(IconLoader.get((String)"/waitermate/images/up.png"), "", "up");
        this.upButton.setMargin(this.buttonInsets);
        this.upButton.setBorder(new BevelBorder(0));
        this.printLastReceipt = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"PRINT_LAST")).name("printReceipt").icon("/waitermate/guikit/images/print.png").permission(AllPermissions.PRINT_BILL).buttonId(QuickSaleButtonId.printReceipt).signal(this.printLast));
        DrawerToggleButton tabPayDrawerButton = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"TAB_DEBTOR"), IconLoader.get((String)"/waitermate/images/card.png"), IconLoader.get((String)"/waitermate/images/card.png"));
        tabPayDrawerButton.setName("tabDebtor");
        SelectQuickTabTypePanel panel = new SelectQuickTabTypePanel();
        tabPayDrawerButton.setDrawer((JComponent)panel);
        panel.barTabSelected.connect(this.tabPay);
        panel.customerDebtorSelected.connect(this.customerDebtorPay);
        panel.roomAccountSelected.connect(this.roomAccountPay);
        tabPayDrawerButton.addActionListener((ActionListener)this);
        this.tabPayButton = this.constructPermissionedButton(new ButtonParams(this).button((AbstractButton)tabPayDrawerButton).permission(AllPermissions.PAY_TABS).buttonId(QuickSaleButtonId.tabDebtor));
        tabPayDrawerButton.setBorder((Border)new BevelBorder(0));
        tabPayDrawerButton.setPreferredSize(new Dimension(this.BUTTON_WIDTH, ScreenResource.getNavHeight() / navConfig.getRowsPerPage()));
        this.tabPayButton.setPreferredSize(new Dimension(this.BUTTON_WIDTH, ScreenResource.getNavHeight() / navConfig.getRowsPerPage()));
        this.loyaltyButton.setPreferredSize(new Dimension(this.BUTTON_WIDTH, ScreenResource.getNavHeight() / navConfig.getRowsPerPage()));
        this.customerMessageButton.setPreferredSize(new Dimension(this.BUTTON_WIDTH, ScreenResource.getNavHeight() / navConfig.getRowsPerPage()));
        tabPayDrawerButton.setBorderPainted(true);
        this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"DISCOUNT")).name("discount").icon("/waitermate/images/money.png").signal(this.discount).permission(AllPermissions.DISCOUNT).buttonId(QuickSaleButtonId.discount));
        this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"CUSTOMER")).name("SetCustomer").icon("/waitermate/images/customer.png").buttonId(QuickSaleButtonId.SetCustomer).signal(this.customer));
        this.printOrderDecorator = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"PRINT_ORDER")).name("PrintOrder").icon("/waitermate/images/printOrder.png").permission(AllPermissions.SAVE).buttonId(QuickSaleButtonId.PrintOrder).signal(this.printOrder));
        this.showOrderButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"SHOW_ORDER")).name("ShowOrder").icon("/waitermate/images/page.png").permission(AllPermissions.PAY).buttonId(QuickSaleButtonId.ShowOrder).signal(this.showOrder));
        this.getAdminButton().setText(Internationalization.getLiteralFor((String)"SYSTEM"));
        this.constructPermissionedButton(new ButtonParams(this).button(this.getAdminButton()).permission(AllPermissions.SYSTEM_ADMIN).buttonId(QuickSaleButtonId.adminButton));
        this.getConfigButton().setText(Internationalization.getLiteralFor((String)"ACC_ADMIN"));
        this.constructButton(new ButtonParams(this).button(this.getConfigButton()).buttonId(QuickSaleButtonId.configButton));
        this.setupEftposPaymentButtons();
        this.previousSales = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"PREV_SALES"), IconLoader.get((String)"/waitermate/images/selectItemsUp.png"), IconLoader.get((String)"/waitermate/images/selectItemsDown.png"));
        this.previousSales.setPreferredSize(new Dimension(this.BUTTON_WIDTH, ScreenResource.getNavHeight() / navConfig.getRowsPerPage()));
        this.previousSales.setBorder((Border)new BevelBorder(0));
        this.previousSalesListPanel = new PreviousSalesListPanel(Arrays.asList(AccountType.takeawayType, AccountType.quickSaleDineInType), Arrays.asList(Terminal.getLocalHost()));
        this.previousSalesListPanel.accountSelected.connect((Object)this, "gotShowPreviousAccount");
        this.previousSales.setBorderPainted(true);
        this.previousSales.setDrawer((JComponent)this.previousSalesListPanel);
        this.previousSales.setName("previousSales");
        this.previousSales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickSaleNav.this.previousSalesListPanel.updateList(QuickSaleNav.this.previousSales.isSelected());
            }
        });
        StandardSecurityDecorator comp = this.constructPermissionedButton(new ButtonParams(this).button((AbstractButton)this.previousSales).permission(AllPermissions.VIEW_PREVIOUS_SALES).buttonId(QuickSaleButtonId.previousSales));
        comp.setPreferredSize(new Dimension(this.BUTTON_WIDTH, ScreenResource.getNavHeight() / navConfig.getRowsPerPage()));
        this.makeComboButton = this.constructButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"COMBO")).name("makeCombo").icon("/waitermate/images/comboMake.png").signal(this.makeCombo).buttonId(QuickSaleButtonId.makeCombo));
        this.makeComboButton.setEnabled(false);
        this.quickTransferButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"TRANSFER")).name("quickTransfer").icon("/waitermate/images/transfer.png").buttonId(QuickSaleButtonId.quickTransfer).permission(AllPermissions.TRANSFER_ITEMS).signal(this.quickTransfer));
        this.findItemButton = this.constructButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"FIND_ITEM")).name("findItem").icon("/waitermate/images/find.png").buttonId(QuickSaleButtonId.findItem));
        this.payToCardButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"PAY_TO_CARD")).name("Pay To Card").icon("/waitermate/images/card.png").buttonId(QuickSaleButtonId.payToCard).permission(AllPermissions.PAY).signal(this.payToCard));
        this.priceLevelButton = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"PRICES_CAPITAL"), IconLoader.get((String)"/waitermate/guikit/images/selectTypeUp.png"), IconLoader.get((String)"/waitermate/guikit/images/selectTypeDown.png"));
        this.priceLevelList = new PriceLevelList();
        this.priceLevelList.setSingleItem(false);
        this.priceLevelList.usePriceLevel.connect((Object)this, "gotPriceLevel");
        this.priceLevelList.useCheapest.connect((Object)this, "gotUseCheapest");
        this.priceLevelButton.setDrawer((JComponent)this.priceLevelList);
        this.priceLevelSecurity = this.constructPermissionedButton(new ButtonParams(this).button((AbstractButton)this.priceLevelButton).buttonId(QuickSaleButtonId.priceLevel).permission(AllPermissions.MANUALLY_CHANGE_PRICE_LEVEL));
        this.priceLevelSecurity.setEnabled(false);
        this.priceLevelButton.setBorderPainted(true);
        this.constructButton(new ButtonParams(this).button(this.getLogoutButton()).buttonId(QuickSaleButtonId.logoutButton));
        this.changeToDineIn.connect((Object)this, "gotChangeToDineIn");
        this.changeToTakeaway.connect((Object)this, "gotChangeToTakeaway");
        this.dineInSaleBtn = this.constructButton(new ButtonParams(this).button(this.constructToggleButton(IconLoader.get((String)"/waitermate/images/dineIn.png"), Internationalization.getLiteralFor((String)"DINE_IN"))).buttonId(QuickSaleButtonId.dineInSaleBtn).signal(this.changeToDineIn).name("Dine In"));
        this.takeawaySaleBtn = this.constructButton(new ButtonParams(this).button(this.constructToggleButton(IconLoader.get((String)"/waitermate/images/takeaway.png"), Internationalization.getLiteralFor((String)"TAKEAWAY"))).buttonId(QuickSaleButtonId.takeawaySaleBtn).signal(this.changeToTakeaway).name("Takeaway"));
        ButtonGroup quickSaleTypeBtnGrp = new ButtonGroup();
        quickSaleTypeBtnGrp.add(this.dineInSaleBtn);
        quickSaleTypeBtnGrp.add(this.takeawaySaleBtn);
        this.quickDebtor = this.constructButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"QUICK_DEBTOR")).name("Quick Debtor").icon("/waitermate/images/customer.png").buttonId(QuickSaleButtonId.quickDebtorPayment).permission(AllPermissions.PAY).signal(this.payToDebtor));
        this.purchaseVoucherButton = this.constructPermissionedButton(new ButtonParams(this).text("Purchase").name("Purchase Voucher").icon("/waitermate/images/voucher.png").buttonId(QuickSaleButtonId.purchaseVoucher).permission(AllPermissions.CONFIG_GIFT_VOUCHERS).signal(this.purchaseVoucher));
        this.priceLevelHandler = new QuickSaleNavPriceLevelsHandler(this);
        this.priceLevelHandler.buildPriceLevelButtons();
        this.currentPage = 1;
        this.oneTouchPayment = this.terminal.isQuickSaleOneTouch();
        if (this.oneTouchPayment) {
            this.setCoinsVisible(false);
        }
        this.getRightBox().setBorder(new EmptyBorder(0, 0, 0, 0));
        this.relayout();
        this.setupTerminalHasCashdrawer();
        this.showPage(this.currentPage);
    }

    private void setupEftposPaymentButtons() {
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled)) {
            this.eftposButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"EFTPOS")).name("Eftpos").icon("/waitermate/images/dcard.png").buttonId(QuickSaleButtonId.eftposPay).permission(AllPermissions.PAY));
            this.visaButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"VISA")).name("Visa").icon("/waitermate/images/cardvisa.png").buttonId(QuickSaleButtonId.visaPay).permission(AllPermissions.PAY));
            this.mastercardButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"MASTERCARD")).name("MasterCard").icon("/waitermate/images/cardmastercard.png").buttonId(QuickSaleButtonId.mastercardPay).permission(AllPermissions.PAY));
            this.amexButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"AMEX")).name("Amex").icon("/waitermate/images/cardamex.png").buttonId(QuickSaleButtonId.amexPay).permission(AllPermissions.PAY));
            this.dinersButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"DINERS")).name("Diners").icon("/waitermate/images/carddiners.png").buttonId(QuickSaleButtonId.dinersPay).permission(AllPermissions.PAY));
            this.quickEftposButton = null;
        } else {
            this.eftposButton = null;
            this.visaButton = null;
            this.mastercardButton = null;
            this.dinersButton = null;
            this.amexButton = null;
            this.quickEftposButton = this.constructPermissionedButton(new ButtonParams(this).text(Internationalization.getLiteralFor((String)"QUICK_EFTPOS")).name("QuickEftpos").icon("/waitermate/images/dcard.png").buttonId(QuickSaleButtonId.quickEftpos).permission(AllPermissions.PAY));
        }
        this.payPalButton = this.constructPermissionedButton(new ButtonParams(this).text("PayPal").name("PayPal").icon("/waitermate/images/partners/paypal-icon.png").buttonId(QuickSaleButtonId.payPal).signal(this.payPalPay).permission(AllPermissions.PAY));
    }

    private List<QuickSaleButtonId> getQuickEftposButtonsIds() {
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled)) {
            return Collections.singletonList(QuickSaleButtonId.quickEftpos);
        }
        return Arrays.asList(QuickSaleButtonId.eftposPay, QuickSaleButtonId.visaPay, QuickSaleButtonId.mastercardPay, QuickSaleButtonId.amexPay, QuickSaleButtonId.dinersPay);
    }

    private List<QuickSaleButtonId> getWebPaymentButtonsIds() {
        return Arrays.asList(QuickSaleButtonId.payPal);
    }

    private JButton constructMoneyButton(ImageIcon imageIcon, String text, Insets dummyInsets2) {
        JButton button = this.constructButton(imageIcon, null, text, dummyInsets2);
        button.setBorder(new BevelBorder(0));
        button.setBorderPainted(true);
        return button;
    }

    private AbstractButton constructButton(ButtonParams builder) {
        AbstractButton button = builder.getButton();
        this.buttonsMap.put(builder.getButtonId(), button);
        button.setBorder(new BevelBorder(0));
        return button;
    }

    private StandardSecurityDecorator constructPermissionedButton(ButtonParams builder) {
        AbstractButton button;
        AbstractButton componentToAdd = button = builder.getButton();
        StandardSecurityDecorator securityDec = null;
        if (builder.getPermission() != null) {
            securityDec = new StandardSecurityDecorator((JComponent)button, builder.getPermission());
            securityDec.setName(button.getName());
            componentToAdd = securityDec;
        }
        this.buttonsMap.put(builder.getButtonId(), componentToAdd);
        return securityDec;
    }

    private void setupPage(int page, JPanel component) {
        component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        QuickSaleNavConfig navConfig = this.terminal.getQuickSaleNavConfig();
        navConfig = (QuickSaleNavConfig)PersistenceManager.reacquire((PersistentObjectI)navConfig);
        GraphPaperLayout layout = new GraphPaperLayout(new Dimension(13, navConfig.getRowsPerPage()), 0, 0);
        component.setLayout((LayoutManager)layout);
        component.setBorder(new EmptyBorder(0, 0, 0, 0));
        boolean hasCashdrawer = !Terminal.getLocalHost().getAvailableLogicallyConnectedCashDrawers().isEmpty();
        for (int rowIndex = 0; rowIndex < navConfig.getRowsPerPage(); ++rowIndex) {
            int colId = 0;
            for (QuickSaleNavInfo button : navConfig.getNavButtons()) {
                if (!button.isActive()) continue;
                int rowNumber = button.getPageNumber();
                int pageNum = (int)Math.ceil((double)rowNumber / (double)navConfig.getRowsPerPage());
                if (pageNum != page || rowIndex != (rowNumber -= navConfig.getRowsPerPage() * (pageNum - 1)) - 1) continue;
                Object buttonComp = null;
                buttonComp = QuickSaleButtonId.specificPriceLevel.equals((Object)button.getButtonIdentifier()) ? this.priceLevelHandler.getButtonForPriceLevel(button.getPriceLevel()) : this.buttonsMap.get(button.getButtonIdentifier());
                if (buttonComp == null) continue;
                if (button.getBgColor() != null) {
                    ((JComponent)buttonComp).setBackground(button.getBgColor());
                    if (buttonComp instanceof AbstractButton) {
                        ((AbstractButton)buttonComp).setContentAreaFilled(true);
                        ((JComponent)buttonComp).putClientProperty("substancelaf.componentFlat", null);
                    } else if (buttonComp instanceof ComponentDecorator) {
                        JComponent decComp = ((ComponentDecorator)buttonComp).getDecorateComponent();
                        decComp.putClientProperty("substancelaf.componentFlat", null);
                        decComp.setBackground(button.getBgColor());
                    }
                }
                if (navConfig.getNumPages() > 1 && colId == 0 && (page == 1 && rowIndex == navConfig.getRowsPerPage() - 1 || page == 2 && rowIndex == 0)) {
                    ++colId;
                }
                if (!button.getButtonIdentifier().isEnabled(Terminal.getLocalHost()) || !hasCashdrawer && button.getButtonIdentifier().isCashdrawerRequired()) continue;
                component.add((Component)buttonComp, new Rectangle(colId++, rowIndex, 1, 1));
            }
        }
    }

    public void setPossiblePriceLevels(Set priceLevelsSet) {
        if (priceLevelsSet == null || priceLevelsSet.size() <= 1) {
            this.priceLevelSecurity.setEnabled(false);
        } else {
            this.priceLevelSecurity.setEnabled(true);
            this.priceLevelList.setPossibleLevels(priceLevelsSet, new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.account));
        }
        this.priceLevelHandler.setPossibleLevelsButtons(priceLevelsSet);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object source = e.getSource();
        if (this.moneyClicked(source)) {
            return;
        }
        if (this.upButton == source) {
            --this.currentPage;
            this.showPage(this.currentPage);
        } else if (this.downButton == source) {
            ++this.currentPage;
            this.showPage(this.currentPage);
        } else if (this.tabPayButton.getDecorateComponent() == source) {
            this.doQuickPayToTab();
        } else if (this.findItemButton == source) {
            this.findItem.emit((Object)Boolean.TRUE);
        } else if (this.quickEftposButton != null && this.quickEftposButton.getDecorateComponent() == source) {
            this.creditPay.emit(null);
        } else if (this.eftposButton != null && this.eftposButton.getDecorateComponent() == source) {
            this.creditPay.emit((Object)FinanceUnit.getUnitForName((String)"Savings Acc"));
        } else if (this.mastercardButton != null && this.mastercardButton.getDecorateComponent() == source) {
            this.creditPay.emit((Object)FinanceUnit.getUnitForName((String)"Mastercard"));
        } else if (this.visaButton != null && this.visaButton.getDecorateComponent() == source) {
            this.creditPay.emit((Object)FinanceUnit.getUnitForName((String)"Visa"));
        } else if (this.dinersButton != null && this.dinersButton.getDecorateComponent() == source) {
            this.creditPay.emit((Object)FinanceUnit.getUnitForName((String)"Diners"));
        } else if (this.amexButton != null && this.amexButton.getDecorateComponent() == source) {
            this.creditPay.emit((Object)FinanceUnit.getUnitForName((String)"Amex"));
        } else if (this.payPalButton != source && this.voucherPayButton != source) {
            if (this.orderInfoButton == source) {
                this.ticketData.emit();
            } else {
                this.priceLevelHandler.checkActionPerformed(source);
            }
        }
    }

    private boolean moneyClicked(Object source) {
        boolean isMoney = false;
        if (this.notes.contains(source)) {
            isMoney = true;
            Price toAdd = new Price(((JButton)source).getName(), 0.01);
            this.addCash.emit((Object)toAdd);
            if (this.oneTouchPayment) {
                this.quickPay.emit();
            }
        } else if (this.coins.contains(source)) {
            isMoney = true;
            Price toAdd = new Price(((JButton)source).getName(), 0.01);
            this.addCash.emit((Object)toAdd);
        }
        return isMoney;
    }

    private void showPage(int page) {
        this.removeAllRight();
        if (page == 1) {
            this.addLeft(this.left);
        } else {
            this.removeLeft(this.left);
        }
        if (page == 1) {
            this.addRight(this.rightPage1);
        } else if (page == 2) {
            this.addRight(this.rightPage2);
        }
        QuickSaleNavConfig navConfig = this.terminal.getQuickSaleNavConfig();
        if (navConfig == null) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"NO_GUI_CONFIGURATION_FOUND_FOR_THIS_QUICK_SALE") + ", " + Internationalization.getLiteralFor((String)"SET_ONE_UP_IN_OFFICEMATE")), (String)Internationalization.getLiteralFor((String)"NO_GUI_CONFIGURATION"));
            navConfig = QuickSaleNavConfig.create();
        }
    }

    public void setPrintLastEnabled(Boolean enabled) {
        if (enabled != null) {
            this.printLastReceipt.setEnabled(enabled.booleanValue());
        }
    }

    public void reset() {
        this.currentPage = 1;
        this.showPage(this.currentPage);
    }

    public void setCoinsVisible(boolean value) {
        boolean visible = value && !this.oneTouchPayment;
        for (JButton nextCoin : this.coins) {
            nextCoin.setVisible(visible);
        }
    }

    private void setCoinsEnabled(boolean value) {
        for (JButton coin : this.coins) {
            coin.setEnabled(value);
        }
    }

    private void setNotesVisible(boolean value) {
        for (JButton note : this.notes) {
            note.setVisible(value);
        }
    }

    private void setNotesEnabled(boolean value) {
        for (JButton note : this.notes) {
            note.setEnabled(value);
        }
    }

    public void setPayFunctionalityVisible(List<CashDrawer> availableCashdrawers) {
        boolean enabled;
        boolean eftposEnabled = enabled = availableCashdrawers.size() > 0;
        for (CashDrawer drawer : availableCashdrawers) {
            eftposEnabled &= EftposManager.getInstance().getEftposForCashDrawer(drawer, Terminal.getLocalHostIfAvailable()) == null;
        }
        for (QuickSaleButtonId buttonId : this.getQuickEftposButtonsIds()) {
            JComponent comp = this.buttonsMap.get(buttonId);
            if (comp == null) continue;
            comp.setVisible(enabled);
        }
        this.showOrderButton.setVisible(enabled);
        this.payButton.setVisible(enabled);
        this.quickPayButton.setVisible(enabled);
        this.loyaltyButton.setVisible(SystemProperty.getInstance().isLoyaltyEnabled() && enabled);
        this.voucherPayButton.setVisible(enabled);
        this.setNotesVisible(enabled);
        this.setCoinsVisible(enabled);
    }

    public void setDoneEnabled(boolean enabled) {
        User currentUser = LoginManager.getInstance().getUser();
        if (Terminal.getLocalHost().getPayableCashDrawers(currentUser).size() > 0 && LoginManager.getInstance().hasPermission(AllPermissions.PAY)) {
            this.quickPayButton.setEnabled(enabled);
        } else {
            this.quickPayButton.setEnabled(false);
            this.setNotesVisible(false);
            this.setCoinsVisible(false);
            this.loyaltyButton.setEnabled(false);
            this.voucherPayButton.setEnabled(false);
        }
    }

    void setAccountHasItems(boolean hasItems, boolean zeroDue, boolean inBistroMode) {
        boolean setEnabled = !zeroDue || !inBistroMode;
        this.setCoinsEnabled(hasItems && !this.oneTouchPayment && setEnabled);
        this.setNotesEnabled(hasItems && setEnabled);
        this.orderInfoButton.setEnabled(hasItems && setEnabled);
        User currentUser = LoginManager.getInstance().getUser();
        if (Terminal.getLocalHost().getPayableCashDrawers(currentUser).size() > 0) {
            JComponent comp;
            this.showOrderButton.setEnabled(hasItems && setEnabled);
            JComponent finishedButtonComp = this.buttonsMap.get(QuickSaleButtonId.Pay);
            AbstractButton button = null;
            if (finishedButtonComp != null) {
                StandardSecurityDecorator finishedButton = (StandardSecurityDecorator)finishedButtonComp;
                button = finishedButton.getButton();
            }
            if (inBistroMode) {
                this.payButton.setEnabled(true);
                if (button != null) {
                    if (hasItems && zeroDue) {
                        button.setText("Finish");
                    } else {
                        button.setText(Internationalization.getLiteralFor((String)"PAY"));
                    }
                }
            } else {
                this.payButton.setEnabled(hasItems && setEnabled);
                if (button != null) {
                    button.setText(Internationalization.getLiteralFor((String)"PAY"));
                }
            }
            this.tabPayButton.setEnabled(hasItems && setEnabled);
            this.quickDebtor.setEnabled(hasItems && setEnabled);
            this.loyaltyButton.setEnabled(hasItems && this.isLoyaltyAvaliable() && setEnabled);
            this.voucherPayButton.setEnabled(hasItems && !zeroDue && setEnabled);
            for (QuickSaleButtonId buttonId : this.getQuickEftposButtonsIds()) {
                comp = this.buttonsMap.get(buttonId);
                if (comp == null) continue;
                comp.setEnabled(hasItems && setEnabled);
            }
            for (QuickSaleButtonId buttonId : this.getWebPaymentButtonsIds()) {
                comp = this.buttonsMap.get(buttonId);
                if (comp == null) continue;
                comp.setEnabled(hasItems && setEnabled);
            }
        } else {
            this.showOrderButton.setEnabled(false);
            this.payButton.setEnabled(false);
            this.tabPayButton.setEnabled(false);
            this.quickDebtor.setEnabled(false);
            this.loyaltyButton.setEnabled(false);
            this.voucherPayButton.setEnabled(false);
        }
        this.printOrderDecorator.setEnabled(hasItems);
        this.quickTransferButton.setEnabled(hasItems);
        if (this.account != null) {
            this.payToCardButton.setEnabled(hasItems && this.customerCardHelper.isValidCardId(this.account.getCardId()));
        } else {
            this.payToCardButton.setEnabled(false);
        }
        if (!hasItems) {
            this.priceLevelHandler.setPossibleLevelsButtons(new HashSet<PriceLevel>());
        }
    }

    private void setupTerminalHasCashdrawer() {
        if (Terminal.getLocalHost().getAvailableLogicallyConnectedCashDrawers().isEmpty()) {
            this.setCoinsVisible(false);
            this.setNotesVisible(false);
            this.tabPayButton.setVisible(false);
            this.quickDebtor.setVisible(false);
            this.noSaleButton.setVisible(false);
            this.payButton.setVisible(false);
            this.loyaltyButton.setVisible(false);
            this.voucherPayButton.setVisible(false);
            List<QuickSaleButtonId> eftIds = this.getQuickEftposButtonsIds();
            for (QuickSaleButtonId nextId : eftIds) {
                this.buttonsMap.get(nextId).setVisible(false);
            }
        }
    }

    void gotPriceLevel(PriceLevel level) {
        this.gotUseSpecificPriceLevel(level, Boolean.TRUE);
        this.priceLevelButton.closeDrawer();
    }

    void gotUseSpecificPriceLevel(PriceLevel level, Boolean showDialog) {
        this.usePriceLevel.emit((Object)level, (Object)showDialog);
    }

    void gotUseCheapest() {
        this.useCheapestPriceLevels.emit();
        this.priceLevelButton.closeDrawer();
    }

    void gotShowPreviousAccount(Account accountToShow) {
        this.showPreviousAccount.emit((Object)accountToShow);
        this.previousSales.closeDrawer();
    }

    void gotCustomerCard(String value) {
        this.payToCardButton.setEnabled(value != null && !value.trim().isEmpty());
    }

    private void doQuickPayToTab() {
        int optionsCount = 0;
        if (Terminal.getLocalHost().hasBarTabsMode()) {
            ++optionsCount;
        }
        if (Terminal.getLocalHost().hasDebtorsMode()) {
            ++optionsCount;
        }
        if (SystemProperty.getInstance().isPropertyManagementIntegrationEnabled()) {
            ++optionsCount;
        }
        if (Terminal.getLocalHost().hasBarTabsMode()) {
            this.tabPay.emit();
        }
        if (optionsCount == 1) {
            DrawerToggleButton button = (DrawerToggleButton)this.tabPayButton.getDecorateComponent();
            button.closeDrawerSlamShut();
            if (Terminal.getLocalHost().hasDebtorsMode()) {
                this.customerDebtorPay.emit();
            }
            if (SystemProperty.getInstance().isPropertyManagementIntegrationEnabled()) {
                this.roomAccountPay.emit();
            }
        }
    }

    public void setAccount(TakeawayAccount currentAccount) {
        this.account = currentAccount;
    }

    public TakeawayAccount getCurrentAccount() {
        return this.account;
    }

    public void setMakeComboEnabled(boolean booleanValue) {
        this.makeComboButton.setEnabled(booleanValue);
    }

    void startNavOverlay() {
        this.configureNavOverlay();
        this.navOverlayAnimator.start();
        this.navOverlay.setVisible(true);
    }

    void stopNavOverlay() {
        if (this.navOverlayAnimator != null) {
            this.navOverlayAnimator.stop();
            this.navOverlay.setVisible(false);
        }
    }

    private void configureNavOverlay() {
        int ANIMATION_DURATION_MS = 1000;
        if (this.navOverlayAnimator == null || this.navOverlay.getPreferredSize().width != this.getWidth() || this.navOverlay.getPreferredSize().height != this.getHeight()) {
            this.navOverlay = new JPanel(new BorderLayout());
            this.navOverlay.add(new JLabel(this.createNavStrip()));
            this.navOverlay.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
            this.navOverlay.setSize(this.navOverlay.getPreferredSize());
            int start = this.getLocation().y + this.getHeight();
            int end = start - this.navOverlay.getHeight() + ScreenResource.getMenuHeight();
            SimpleMotionBoundsAnimator posAnimator = new SimpleMotionBoundsAnimator((Component)this.navOverlay, new Point(0, start), new Point(0, end));
            posAnimator.setPathMapperY((PathMapper)QuadraticPathMapper.getInstance((boolean)false));
            this.navOverlayAnimator = new Animator(1000);
            this.navOverlayAnimator.addTarget((TimingTarget)posAnimator);
            ScreenResource.addToOverlay((Component)this.navOverlay);
        }
        this.navOverlay.setLocation(0, this.getLocation().y + this.getHeight());
    }

    private ImageIcon createNavStrip() {
        ImageIcon stripIcon = Terminal.getLocalHost().isDarkLogo() ? IconLoader.get((String)"/waitermate/images/om_logo_2024_black_navbar.png") : IconLoader.get((String)"/waitermate/images/om_logo_2024_red_navbar.png");
        return new ImageIcon(stripIcon.getImage().getScaledInstance(this.getWidth(), this.getHeight(), 4));
    }

    public void setEnableQuickEftpos(boolean enabled) {
        for (QuickSaleButtonId buttonId : this.getQuickEftposButtonsIds()) {
            JComponent comp = this.buttonsMap.get(buttonId);
            if (comp == null) continue;
            comp.setEnabled(enabled);
        }
    }

    protected void customerChanged() {
        this.loyaltyButton.setEnabled(this.isLoyaltyAvaliable());
    }

    private boolean isLoyaltyAvaliable() {
        return SystemProperty.getInstance().isLoyaltyEnabled() && this.getCurrentAccount() != null && this.getCurrentAccount().getCustomer() != null && this.getCurrentAccount().getCustomer().getCategory() != null && this.getCurrentAccount().getCustomer().getCategory().isLoyaltyPointsEnabled() && this.getCurrentAccount().getCustomer().getLoyaltyPoints() > 0;
    }

    void setAccountType(AccountType accType) {
        if (accType != null && accType.equals((Object)AccountType.quickSaleDineInType)) {
            this.setDineInTakeawayToggleState(AccountType.quickSaleDineInType);
            this.dineInSaleBtn.setSelected(true);
        } else {
            this.setDineInTakeawayToggleState(AccountType.takeawayType);
            this.takeawaySaleBtn.setSelected(true);
        }
    }

    private void setDineInTakeawayToggleState(AccountType accType) {
        if (accType != null && accType.equals((Object)AccountType.quickSaleDineInType)) {
            OrderMateTheme.setupUntoggledButton((AbstractButton)this.takeawaySaleBtn);
            OrderMateTheme.setupToggledButton((AbstractButton)this.dineInSaleBtn);
        } else {
            OrderMateTheme.setupUntoggledButton((AbstractButton)this.dineInSaleBtn);
            OrderMateTheme.setupToggledButton((AbstractButton)this.takeawaySaleBtn);
        }
    }

    boolean isDineInTakeawayManual() {
        return this.dineInSaleBtn.getParent() != null;
    }

    private void gotChangeToDineIn() {
        this.setDineInTakeawayToggleState(AccountType.quickSaleDineInType);
    }

    private void gotChangeToTakeaway() {
        this.setDineInTakeawayToggleState(AccountType.takeawayType);
    }

    public Insets getButtonInsets() {
        return this.buttonInsets;
    }

    public void relayout() {
        QuickSaleNavConfig navConfig = Terminal.getLocalHost().getQuickSaleNavConfig();
        this.rightPage1.removeAll();
        this.rightPage2.removeAll();
        this.setupPage(1, this.rightPage1);
        this.setupPage(2, this.rightPage2);
        if (navConfig.getNumPages() > 1) {
            int downRow = navConfig.getRowsPerPage() == 2 ? 1 : 0;
            this.rightPage1.add((Component)this.downButton, new Rectangle(0, downRow, 1, 1));
            this.rightPage2.add((Component)this.upButton, new Rectangle(0, 0, 1, 1));
        }
    }
}

