/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import ordermate.database.hardware.QuickSaleButtonId;
import ordermate.database.hardware.QuickSaleNavConfig;
import ordermate.database.hardware.QuickSaleNavInfo;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import waitermate.LoginManager;
import waitermate.gui.screens.selectaccount.quicksale.ButtonParams;
import waitermate.gui.screens.selectaccount.quicksale.QuickSaleNav;

class QuickSaleNavPriceLevelsHandler {
    private Map<PriceLevel, StandardSecurityDecorator> priceLevelButtons = new HashMap<PriceLevel, StandardSecurityDecorator>();
    private QuickSaleNav navBar;

    public QuickSaleNavPriceLevelsHandler(QuickSaleNav navBar) {
        this.navBar = navBar;
    }

    public void buildPriceLevelButtons() {
        Terminal terminal = Terminal.getLocalHost();
        QuickSaleNavConfig navConfig = terminal.getQuickSaleNavConfig();
        for (QuickSaleNavInfo button : navConfig.getNavButtons()) {
            if (!QuickSaleButtonId.specificPriceLevel.equals((Object)button.getButtonIdentifier()) || !button.isActive() || button.getPriceLevel() == null || !"ACTIVE".equals(button.getPriceLevel().getSystemState())) continue;
            StandardSecurityDecorator priceLevelSecurity = this.constructPermissionedButton(new ButtonParams(this.navBar).text(button.getButtonName()).name(button.getButtonName()).icon("/waitermate/images/price_level.png").buttonId(QuickSaleButtonId.specificPriceLevel).permission(AllPermissions.MANUALLY_CHANGE_PRICE_LEVEL));
            priceLevelSecurity.setEnabled(false);
            this.priceLevelButtons.put(button.getPriceLevel(), priceLevelSecurity);
        }
    }

    public void setPossibleLevelsButtons(Set<PriceLevel> priceLevels) {
        boolean currUserHasPermission = LoginManager.getInstance().hasPermission(AllPermissions.MANUALLY_CHANGE_PRICE_LEVEL);
        for (PriceLevel priceLevel : this.priceLevelButtons.keySet()) {
            this.priceLevelButtons.get(priceLevel).setEnabled(priceLevels.contains(priceLevel) && currUserHasPermission);
        }
    }

    private StandardSecurityDecorator constructPermissionedButton(ButtonParams builder) {
        AbstractButton button = builder.getButton();
        StandardSecurityDecorator securityDec = null;
        if (builder.getPermission() != null) {
            securityDec = new StandardSecurityDecorator((JComponent)button, builder.getPermission());
            securityDec.setName(button.getName());
        }
        return securityDec;
    }

    public StandardSecurityDecorator getButtonForPriceLevel(PriceLevel priceLevel) {
        return this.priceLevelButtons.get(priceLevel);
    }

    public void checkActionPerformed(Object source) {
        for (PriceLevel priceLevel : this.priceLevelButtons.keySet()) {
            if (!this.priceLevelButtons.get(priceLevel).getDecorateComponent().equals(source)) continue;
            this.navBar.usePriceLevel.emit((Object)priceLevel, (Object)Boolean.FALSE);
            return;
        }
    }
}

