/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.FinanceInfo;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.gui.displayitems.accountitems.DefaultItemRenderer;
import waitermate.gui.displayitems.accountitems.SingleScreenItemRenderer;
import waitermate.gui.screens.ordering.accountitems.WaitermateUpsell;
import waitermate.gui.screens.ordering.additems.selectitem.AbstractMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.MultipleMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.SimpleMenuItemSelectionPanel;
import waitermate.gui.screens.selectaccount.quicksale.GuiFinanceInfo;
import waitermate.upsell.UpsellManager;

class QuickSalePanel
extends JPanel
implements FinanceInfo {
    public final Signal<InventoryGroup, ?, ?, ?, ?> groupSelected = Signals.createSignal(InventoryGroup.class, (String)"group");
    public final Signal<Sellable, ?, ?, ?, ?> item = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<InventoryItem, ?, ?, ?, ?> newItem = Signals.createSignal(InventoryItem.class, (String)"newItem");
    public final Signal<InventoryCombo, ?, ?, ?, ?> newCombo = Signals.createSignal(InventoryCombo.class, (String)"newCombo");
    public final Signal<Sellable, ?, ?, ?, ?> quantity = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<Sellable, ?, ?, ?, ?> delete = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<Sellable, ?, ?, ?, ?> upgrade = Signals.createSignal(Sellable.class, (String)"selectedItme");
    public final Signal clearTendered = Signals.createSignal();
    public final Signal resyncPoints = Signals.createSignal();
    private final RendererScrollPaneModel items;
    private final CustomScrollPane itemsPane;
    private final AbstractMenuItemSelectionPanel groups;
    private final GuiFinanceInfo financeInfo;
    private DefaultItemRenderer renderer;
    private WaitermateUpsell upsell;
    private final JPanel upsellPanel;
    private SellableWrapperFactory sellableFactory;

    QuickSalePanel(int menuWidth) {
        super(null);
        boolean singleScreen = Terminal.getLocalHost().getQuickSaleSingleScreenOrdering();
        this.renderer = singleScreen ? new SingleScreenItemRenderer() : new DefaultItemRenderer();
        this.sellableFactory = new SellableWrapperFactory();
        this.createUpsell();
        int size = this.upsell == null ? 10 : 11;
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(100, size)));
        this.items = new RendererScrollPaneModel((Renderer)this.renderer, 1, 6);
        this.itemsPane = new CustomScrollPane((CustomScrollPaneModel)this.items);
        this.itemsPane.setName("quicksaleItems");
        this.itemsPane.setEmptyMessage(Internationalization.getLiteralFor((String)"SELECT_A_MENU_GROUP_TO_BEGIN_ORDERING"));
        if (singleScreen) {
            boolean tabbed = Terminal.getLocalHost().isQuickSaleTabbedMenuOrdering();
            this.groups = new MultipleMenuItemSelectionPanel(new SelectItemButtonRenderer(Terminal.getLocalHost().isQuickSaleShowQuantity()), tabbed);
            this.add((Component)new NameDecorator((JComponent)this.groups, "ItemScreen"), new Rectangle(0, 0, menuWidth, 9));
        } else {
            this.groups = new SimpleMenuItemSelectionPanel(1, 10, new SelectItemButtonRenderer(Terminal.getLocalHost().isQuickSaleShowQuantity()));
            this.add((Component)new NameDecorator((JComponent)this.groups, "menuGroups"), new Rectangle(0, 0, menuWidth, 9));
            this.groups.groupSelected.connect((Object)this, "gotGroup");
        }
        this.groups.setNumKeypadVisible(singleScreen && Terminal.getLocalHost().getQuickSaleQtyKeyPad());
        this.financeInfo = new GuiFinanceInfo();
        ExperimentalFeature feature = ExperimentalFeature.find((String)"Quicksale Items Button Size");
        int buttonHeight = feature != null ? feature.getIntValue(Integer.valueOf(9)) : 9;
        this.add((Component)new NameDecorator((JComponent)this.itemsPane, "fastBarItemsPane"), new Rectangle(menuWidth, 0, 100 - menuWidth, buttonHeight));
        if (this.upsell != null) {
            this.upsellPanel = new JPanel();
            this.upsellPanel.setOpaque(false);
            this.upsellPanel.setLayout(new BorderLayout());
            this.add((Component)this.upsellPanel, new Rectangle(menuWidth, 9, 100 - menuWidth, 1));
            this.add((Component)this.financeInfo, new Rectangle(0, 10, 100, 1));
        } else {
            this.upsellPanel = null;
            this.add((Component)this.financeInfo, new Rectangle(0, 9, 100, 1));
        }
        this.financeInfo.clearTendered.connect((Object)this.clearTendered, "emit");
        this.financeInfo.resyncPoints.connect((Object)this.resyncPoints, "emit");
        this.groups.itemSelected.connect((Object)this, "gotNewItem");
        this.groups.comboSelected.connect((Object)this, "gotNewCombo");
        this.renderer.item.connect((Object)this, "gotItem");
        this.renderer.quantity.connect((Object)this, "gotQuantity");
        this.renderer.delete.connect((Object)this, "gotDelete");
        this.renderer.upgrade.connect((Object)this, "gotUpgrade");
    }

    private void createUpsell() {
        if (UpsellManager.getInstance() != null) {
            this.upsell = new WaitermateUpsell();
            this.upsell.upgrade.connect((Object)this, "gotUpgrade");
            this.upsell.item.connect((Object)this, "gotNewItem");
            this.upsell.section.connect((Object)this, "gotGroup");
            this.upsell.component.connect((Object)this, "showUpsellComponent");
            UpsellManager.getInstance().upsellSuggested.connect((Object)this.upsell, "gotUpsell");
        }
    }

    void newAccount(Account account) {
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)account);
        if (Terminal.getLocalHost().getHasAutoMenuSelect() || this.groups.getInventoryGroup() == null) {
            this.groups.showRootGroup(context, Collections.EMPTY_LIST, null);
        } else if (this.groups.getInventoryGroup() != null) {
            this.groups.showGroup(context, this.groups.getInventoryGroup(), Collections.EMPTY_LIST, null);
        }
        this.upsell.gotNoAccount();
        this.items.setObjects(new ArrayList(0));
    }

    void showAccount(Account account) {
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)account);
        if (this.groups.getInventoryGroup() != null) {
            this.groups.showGroup(context, this.groups.getInventoryGroup(), account.getItems(), Collections.EMPTY_LIST);
        } else if (account.getAllItems().size() > 0) {
            this.groups.showRootGroup(context, account.getItems(), null);
        } else if (account.getItems().isEmpty()) {
            this.groups.showRootGroup(context, Collections.EMPTY_LIST, null);
        }
        this.upsell.gotAccountChanged(account);
        this.renderer.setTriggerEventContext(new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)account));
        this.financeInfo.setSyncEnabled(account.getCustomer() != null);
        this.items.setObjects(this.sellableFactory.getSellables((ItemGroup)account));
    }

    void showLastPage() {
        this.itemsPane.displayLastPage();
    }

    public void setFinanceInfo(Price total, Price due, Price paid, Price tendered, Price change, Price remaining) {
        this.financeInfo.setFinanceInfo(total, due, paid, tendered, change, remaining);
    }

    void gotGroup(InventoryGroup theGroup) {
        this.groupSelected.emit((Object)theGroup);
    }

    void gotItem(Sellable theItem) {
        this.item.emit((Object)theItem);
    }

    void gotNewCombo(InventoryCombo theNewCombo) {
        this.newCombo.emit((Object)theNewCombo);
    }

    void gotNewItem(InventoryItem theNewItem) {
        this.newItem.emit((Object)theNewItem);
    }

    void gotQuantity(Sellable theItem) {
        this.quantity.emit((Object)theItem);
    }

    void gotDelete(Sellable theItem) {
        this.delete.emit((Object)theItem);
    }

    void gotUpgrade(Sellable theItem) {
        this.upgrade.emit((Object)theItem);
    }

    public void setOrderInfo(List orderInfo) {
        this.financeInfo.setOrderInfo(orderInfo);
    }

    public void setDiscountAndSurcharge(String discount, String surcharge) {
        this.financeInfo.setDiscountAndSurcharge(discount, surcharge);
    }

    public SalesQuantity getKeyPadQuantity() {
        if (!Terminal.getLocalHost().getQuickSaleSingleScreenOrdering()) {
            return SalesQuantity.ONE;
        }
        return this.groups.getQuantity();
    }

    public boolean getIncrementQuantityFlag() {
        if (!Terminal.getLocalHost().getQuickSaleSingleScreenOrdering()) {
            return true;
        }
        return this.groups.getFirstPressQuantityFlag();
    }

    public Rectangle getFinanceInfoBounds() {
        return (Rectangle)this.financeInfo.getBounds().clone();
    }

    public InventoryGroup getDisplayingGroup() {
        return this.groups.getInventoryGroup();
    }

    public void showUpsellComponent(JComponent comp) {
        if (this.upsellPanel != null && comp != null) {
            this.upsellPanel.removeAll();
            this.upsellPanel.add((Component)comp, "Center");
        }
    }
}

