/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class SelectQuickTabTypePanel
extends JPanel {
    public final Signal barTabSelected = Signals.createSignal();
    public final Signal customerDebtorSelected = Signals.createSignal();
    public final Signal roomAccountSelected = Signals.createSignal();

    public SelectQuickTabTypePanel() {
        Terminal localHost = Terminal.getLocalHost();
        this.setLayout(new GridLayout(0, 1, 5, 5));
        JLabel prompt = new JLabel(Internationalization.getLiteralFor((String)"SELECT_DEBTOR_TYPE") + ":");
        prompt.setFont(OrderMateTheme.getMediumFont());
        this.add(prompt);
        if (localHost.hasBarTabsMode()) {
            this.constructButton(this.barTabSelected, Internationalization.getLiteralFor((String)"TABS"), AllPermissions.PAY_TABS);
        }
        if (localHost.hasDebtorsMode()) {
            this.constructButton(this.customerDebtorSelected, Internationalization.getLiteralFor((String)"CUSTOMER_DEBTORS"), AllPermissions.PAY_CUSTOMER_ACCOUNTS);
        }
        if (SystemProperty.getInstance().isPropertyManagementIntegrationEnabled()) {
            this.constructButton(this.roomAccountSelected, Internationalization.getLiteralFor((String)"ROOM_ACCOUNTS"), AllPermissions.PAY_ROOM_ACCOUNT);
        }
        Dimension size = this.getPreferredSize();
        size.width *= 2;
        size.height *= 2;
        this.setPreferredSize(size);
    }

    public void constructButton(final Signal signal, String name, Permission permission) {
        JButton button = new JButton(name);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                signal.emit();
            }
        });
        this.add((Component)new StandardSecurityDecorator((JComponent)button, permission));
    }
}

