/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import au.com.ordermate.glazedlists.PropertyAccessorComparator;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.propertyaccessor.ChainPropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.TristateToggle;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ordermate.database.EventContext;
import ordermate.database.hardware.GTL;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.button.CustomButton;
import ordermate.gui.button.CustomButtonLabelGenerator;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import waitermate.LoginManager;
import waitermate.gui.screens.selectaccount.table.AbstractTableSelectionPanel;

public class ButtonTableSelectionPanel
extends AbstractTableSelectionPanel {
    private static final int ACCOUNT_NUM_COLS = 1;
    private static final int ROWS = 10;
    private DataScrollPaneModel sectionsData;
    private TableGroup currentSection;
    private TablesPanel tablesPanel;
    private boolean includeInactiveSections;

    public ButtonTableSelectionPanel(boolean includeInactiveSections) {
        this.includeInactiveSections = includeInactiveSections;
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(4, 1), 15, 15));
        terminalChanged.connect((Object)this, "gotTerminalChanged");
        List<TableGroup> sections = this.getSections();
        this.sectionsData = new DataScrollPaneModel(1, 6);
        this.sectionsData.objectSelected.connect((Object)this, "gotTableGroup");
        this.sectionsData.setItems(sections, true);
        CustomScrollPane sectionsScrollPane = new CustomScrollPane((CustomScrollPaneModel)this.sectionsData);
        sectionsScrollPane.setEmptyMessage("There are no sections");
        this.tablesPanel = new TablesPanel();
        if (sections.size() > 1) {
            this.add((Component)new NameDecorator((JComponent)sectionsScrollPane, "tableGroups"), new Rectangle(0, 0, 1, 1));
            this.add((Component)new NameDecorator((JComponent)this.tablesPanel, "tables"), new Rectangle(1, 0, 3, 1));
        } else {
            this.add((Component)new NameDecorator((JComponent)this.tablesPanel, "tables"), new Rectangle(0, 0, 4, 1));
        }
        this.setCurrentTableGroup(sections.get(0));
    }

    @Override
    public boolean isInterfaceLocked() {
        return !this.tablesPanel.isEnabled();
    }

    @Override
    public void setInterfaceLocked(boolean locked) {
        this.tablesPanel.setEnabled(!locked);
    }

    @Override
    public void setAllowInterfaceUnlocking(boolean allowIt) {
    }

    @Override
    public void setInterfaceLocked(boolean locked, String dialogText, String unlockButtonText) {
        this.setInterfaceLocked(locked);
    }

    @Override
    public GTL getGTL() {
        return GTL.None;
    }

    public void addTableGroup(TableGroup tableGroup) {
        List data = this.sectionsData.getItems();
        data.add(tableGroup);
        this.sectionsData.setItems(data, true);
    }

    public void removeTableGroup(TableGroup tableGroup) {
        List data = this.sectionsData.getItems();
        data.remove(tableGroup);
        this.sectionsData.setItems(data, true);
        this.setCurrentTableGroup((TableGroup)this.sectionsData.getItems().get(0));
    }

    @Override
    public void setCurrentTableGroup(TableGroup newSection) {
        this.currentSection = newSection;
        this.tablesPanel.setTableSection(newSection);
        if (this.sectionsData != null) {
            this.sectionsData.selectButton((Displayable)newSection);
        }
        User loginUser = LoginManager.getInstance().getUser();
        this.tablesPanel.setEnabled(!newSection.isLocked() || newSection.isLocked(loginUser));
        this.tableGroupSelected.emit((Object)newSection);
        this.repaint();
    }

    @Override
    public void start() {
        this.setCurrentTableGroup(this.currentSection);
        this.refresh();
    }

    @Override
    public TableGroup getCurrentTableGroup() {
        return this.currentSection;
    }

    void gotTableGroup(Displayable selectedTableGroup) {
        TableGroup selTableGroup = (TableGroup)selectedTableGroup;
        selTableGroup.reloadSyncState();
        this.setCurrentTableGroup(selTableGroup);
        this.tableGroupSelected.emit((Object)selTableGroup);
    }

    void gotTable(Displayable selectedTable) {
        this.currentSection.reloadSyncState();
        User loginUser = LoginManager.getInstance().getUser();
        this.tablesPanel.setEnabled(!this.currentSection.isLocked() || this.currentSection.isLocked(loginUser));
        this.tableSelected.emit((Object)((LogicalTable)selectedTable));
    }

    public void replaceCurrentSectionButton() {
        List tableGroupButtons = this.sectionsData.getButtons();
        for (NameDecorator nameDec : tableGroupButtons) {
            CustomToggleButton button = (CustomToggleButton)nameDec.getDecorateComponent();
            if (!button.getData().equals(this.currentSection)) continue;
            button.setData((Displayable)this.currentSection);
            break;
        }
    }

    public void refresh() {
        if (this.currentSection.isReloadRequired()) {
            this.currentSection = (TableGroup)PersistenceManager.preload((PersistentObject)this.currentSection);
        }
        this.tablesPanel.setTableSection(this.currentSection);
        this.replaceCurrentSectionButton();
        this.revalidate();
        this.repaint();
    }

    public List getTableGroups() {
        return this.sectionsData.getItems();
    }

    private List<TableGroup> getSections() {
        if (this.includeInactiveSections) {
            return TableGroupQueries.getTableGroups();
        }
        return TableGroup.getActiveTableGroups((EventContext)LoginManager.getEventContext());
    }

    public void gotTerminalChanged() {
    }

    class LogicalTableGenerator
    implements CustomButtonLabelGenerator<LogicalTable> {
        LogicalTableGenerator() {
        }

        public String getLabelText(LogicalTable table) {
            StringBuilder SB = new StringBuilder("<html><b>").append(table.getLabel()).append("</b>");
            if (table.hasAccount() && table.isLocked()) {
                HtmlUtils.startFontTag((String)"#2C3539", (int)2, (StringBuilder)SB);
                SB.append("<br>Locked by ").append(table.getUser().toString());
                HtmlUtils.endFontTag((StringBuilder)SB);
            }
            SB.append("</html>");
            return SB.toString();
        }
    }

    class LogicalTableGrid
    extends JPanel {
        private LogicalTableGenerator generator;
        private CustomButton button;
        private JLabel createdLabel;
        private JLabel totalLabel;
        private JLabel customerLabel;

        LogicalTableGrid() {
            super((LayoutManager)new GraphPaperLayout(5, 1));
            this.generator = new LogicalTableGenerator();
            this.button = new CustomButton(null, (CustomButtonLabelGenerator)this.generator);
            this.add((Component)this.button, new Rectangle(0, 0, 2, 1));
            this.createdLabel = new JLabel();
            this.add((Component)this.createdLabel, new Rectangle(2, 0, 1, 1));
            this.customerLabel = new JLabel();
            this.add((Component)this.customerLabel, new Rectangle(3, 0, 1, 1));
            this.totalLabel = new JLabel();
            this.add((Component)this.totalLabel, new Rectangle(4, 0, 1, 1));
            this.createdLabel.setHorizontalAlignment(4);
            this.customerLabel.setHorizontalAlignment(4);
            this.totalLabel.setHorizontalAlignment(4);
        }

        void setTable(LogicalTable table) {
            this.button.setData((Displayable)table);
            this.totalLabel.setText("");
            this.customerLabel.setText("");
            this.createdLabel.setText("");
            if (table != null && table.hasAccount()) {
                if (table.getAccount() != null) {
                    TableAccount account = table.getAccount();
                    if (account.getTradingDay().equals((Object)TradingDay.getCurrentTradingDay())) {
                        this.createdLabel.setText("Pax " + account.getNumPatrons() + ", " + DateTimeUtils.getSimpleTimeFormat().format(account.getCreationDateTime()));
                    } else {
                        this.createdLabel.setText("Pax " + account.getNumPatrons() + ", " + DateTimeUtils.formatDateForDisplay((Date)account.getCreationDateTime()));
                    }
                    if (account.hasCustomer()) {
                        this.customerLabel.setText(account.getCustomer().toString());
                    } else {
                        this.customerLabel.setText("-");
                    }
                    this.totalLabel.setText(account.getTotal().toString());
                } else {
                    List tabs = table.getBarTabs();
                    this.customerLabel.setText("Bartabs: " + tabs.size());
                    this.createdLabel.setText(DateTimeUtils.formatDateForDisplay((Date)((BarTabAccount)tabs.get(0)).getCreationDateTime()));
                    Price total = Price.ZERO_DOLLAR;
                    for (BarTabAccount account : tabs) {
                        total = total.add(account.getTotal());
                    }
                    this.totalLabel.setText(total.toString());
                }
            }
        }
    }

    class LogicalTableGridRenderer
    extends DisplayableRenderer {
        LogicalTableGridRenderer() {
        }

        public Component createComponent() {
            LogicalTableGrid holder = new LogicalTableGrid();
            holder.button.setHorizontalAlignment(2);
            holder.button.setBorder((Border)new EmptyBorder(5, 20, 5, 5));
            holder.button.addActionListener((ActionListener)((Object)this));
            return holder;
        }

        public void setupComponent(Component component, Object object, int index) {
            ((LogicalTableGrid)component).setTable((LogicalTable)object);
        }
    }

    class SortButton
    extends JButton {
        private TristateToggle toggle;
        private PropertyAccessorComparator comparator;

        public SortButton(String label, PropertyAccessorComparator comp) {
            super(label);
            this.comparator = comp;
            this.toggle = new TristateToggle();
        }

        @Override
        public Icon getIcon() {
            if (this.toggle != null) {
                if (Boolean.TRUE.equals(this.toggle.getState())) {
                    return IconLoader.get((String)"/waitermate/images/uparrow.png");
                }
                if (Boolean.FALSE.equals(this.toggle.getState())) {
                    return IconLoader.get((String)"/waitermate/images/downarrow.png");
                }
            }
            return null;
        }

        void toggle() {
            this.toggle.toggleState();
        }
    }

    class TablesPanel
    extends JPanel
    implements ActionListener {
        private JPanel sortHolder;
        private SortButton sortName;
        private SortButton sortCreation;
        private SortButton sortTotal;
        private SortButton sortCustomer;
        private JButton clearSort;
        private EventList<LogicalTable> basicList;
        private SortedList<LogicalTable> sortedList;
        private RendererScrollPaneModel tablesData;
        private CustomScrollPane tableScrollPane;
        private SequentialComparator<? super LogicalTable> tableComparator;

        TablesPanel() {
            super(new BorderLayout());
            this.basicList = new BasicEventList();
            this.sortedList = new SortedList(this.basicList);
            this.tableComparator = new SequentialComparator();
            this.sortedList.setComparator(this.tableComparator);
            this.init();
        }

        private void init() {
            this.createSorter();
            this.add((Component)this.sortHolder, "North");
            LogicalTableGridRenderer tableRenderer = new LogicalTableGridRenderer();
            tableRenderer.selected.connect((Object)this, "gotTable");
            this.tablesData = new RendererScrollPaneModel((Renderer)tableRenderer, 1, 10);
            this.tableScrollPane = new CustomScrollPane((CustomScrollPaneModel)this.tablesData);
            this.tableScrollPane.setEmptyMessage("There are no tables in this section");
            this.tableScrollPane.setDecorationLocation(DecoratorLocation.East);
            this.add((Component)this.tableScrollPane, "Center");
        }

        void gotTable(Displayable table) {
            ButtonTableSelectionPanel.this.gotTable(table);
        }

        private void createSorter() {
            this.sortHolder = new JPanel(new BorderLayout());
            JPanel headerPanel = new JPanel((LayoutManager)new GraphPaperLayout(5, 1));
            this.sortName = new SortButton("Table Name", new PropertyAccessorComparator((PropertyAccessor)LogicalTable.Properties.LABEL));
            this.sortName.addActionListener(this);
            this.sortCreation = new SortButton("Seated", new PropertyAccessorComparator((PropertyAccessor)new ChainPropertyAccessor(new PropertyAccessor[]{LogicalTable.Properties.ACCOUNT, Account.Properties.CREATION_DATE_TIME})));
            this.sortCreation.addActionListener(this);
            this.sortCustomer = new SortButton("Customer", new PropertyAccessorComparator((PropertyAccessor)new ChainPropertyAccessor(new PropertyAccessor[]{LogicalTable.Properties.ACCOUNT, Account.Properties.CUSTOMER, Customer.Properties.NAME_AND_TITLE})));
            this.sortCustomer.addActionListener(this);
            this.sortTotal = new SortButton("Total", new PropertyAccessorComparator((PropertyAccessor)new ChainPropertyAccessor(new PropertyAccessor[]{LogicalTable.Properties.ACCOUNT, Account.Properties.SAVED_TOTAL})));
            this.sortTotal.addActionListener(this);
            this.clearSort = new JButton(IconLoader.get((String)"/waitermate/images/clearSmall.png"));
            this.clearSort.addActionListener(this);
            this.clearSort.setPreferredSize(new Dimension(40, 40));
            headerPanel.add((Component)this.sortName, new Rectangle(0, 0, 2, 1));
            headerPanel.add((Component)this.sortCreation, new Rectangle(2, 0, 1, 1));
            headerPanel.add((Component)this.sortCustomer, new Rectangle(3, 0, 1, 1));
            headerPanel.add((Component)this.sortTotal, new Rectangle(4, 0, 1, 1));
            this.sortHolder.add((Component)headerPanel, "Center");
            this.sortHolder.add((Component)this.clearSort, "East");
        }

        public void setTableSection(TableGroup newSection) {
            this.basicList.clear();
            ArrayList<LogicalTable> tables = new ArrayList<LogicalTable>();
            for (LogicalTable table : newSection.getTables()) {
                if (!table.canOrderTo()) continue;
                tables.add(table);
            }
            this.basicList.addAll(tables);
            this.tablesData.setObjects(this.sortedList);
        }

        @Override
        public void setEnabled(boolean value) {
            this.tableScrollPane.setEnabled(value);
            super.setEnabled(value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof SortButton) {
                SortButton sort = (SortButton)e.getSource();
                sort.toggle();
                if (sort.toggle.getState() != null) {
                    sort.comparator.negate(sort.toggle.getState() == false);
                    this.tableComparator.addComparator((Comparator)sort.comparator);
                } else {
                    this.tableComparator.removeComparator((Comparator)sort.comparator);
                }
                ButtonTableSelectionPanel.this.refresh();
            } else if (this.clearSort == e.getSource()) {
                this.tableComparator.clear();
                this.sortName.toggle.setState(null);
                this.sortCustomer.toggle.setState(null);
                this.sortCreation.toggle.setState(null);
                this.sortTotal.toggle.setState(null);
                ButtonTableSelectionPanel.this.refresh();
            }
        }
    }
}

