/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import javax.swing.JComponent;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.internationalization.Internationalization;
import waitermate.WaiterMateInputAdapter;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.DoubleKeypadDialog;

public class CoversHelper {
    private static final String PLEASE_ENTER_SEATS_COVERS = Internationalization.getLiteralFor((String)"PLEASE_ENTER_COVERS_AND_SEATS");
    private static final String INVALID_INPUT_MSG = Internationalization.getLiteralFor((String)"CANNOT_BE_MORE_COVERS_THAN_SEATS");
    private static final String MAX_COVER_WARNING = "<br>A max of 100 " + Internationalization.getLiteralFor((String)"COVERS").toLowerCase() + " allowed per table.";
    private DoubleKeypadDialog dialog;
    private int covers;
    private int seats;

    public int getCovers() {
        return this.covers;
    }

    public int getSeats() {
        return this.seats;
    }

    public void promptForCovers(int numCovers, LogicalTable theTable) {
        this.promptForCovers(numCovers, -1, theTable);
    }

    public void promptForCovers(int numCovers, int numSeats, LogicalTable theTable) {
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
        this.doPromptForCovers(numCovers, numSeats);
        boolean valid = this.validateUserInput(theTable);
        if (!valid) {
            this.covers = -1;
        }
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
    }

    public int promptForCoversOnly(int numCovers, LogicalTable theTable) {
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
        this.covers = Dialogs.getInteger((String)(Internationalization.getLiteralFor((String)"NUMBER_OF_COVERS") + ": "), (int)numCovers);
        boolean valid = this.validateUserInput(theTable);
        if (!valid) {
            this.covers = -1;
        }
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
        return this.covers;
    }

    public void updateAccount(TableAccount account) {
        account.setNumPatrons(this.covers);
        if (SystemProperty.getInstance().isCoversAndSeatsSeparated()) {
            account.setSeats(this.seats);
        }
    }

    private void doPromptForCovers(int numCovers, int numSeats) {
        int defaultCovers = numCovers;
        if (numCovers == 0 && SystemProperty.getInstance().getDefaultPatronsPerTable() > 0) {
            this.covers = SystemProperty.getInstance().getDefaultPatronsPerTable();
        } else {
            int n = defaultCovers = defaultCovers > 0 ? defaultCovers : Integer.MIN_VALUE;
            if (SystemProperty.getInstance().isCoversAndSeatsSeparated()) {
                this.doSeatsAndCovers(defaultCovers, numSeats);
            } else {
                this.covers = Dialogs.getInteger((String)(Internationalization.getLiteralFor((String)"NUMBER_OF_COVERS") + ": "), (int)defaultCovers);
            }
        }
    }

    private boolean validateUserInput(LogicalTable theTable) {
        if (SystemProperty.getInstance().isCoversAndSeatsSeparated()) {
            return true;
        }
        int numberOfAvailableSeats = theTable != null ? theTable.getNumberOfSeats() : Integer.MAX_VALUE;
        boolean hasValidNumber = false;
        if (this.covers > 100) {
            this.covers = 100;
        }
        if (this.covers != Integer.MIN_VALUE && this.covers > 0) {
            boolean usesSeatNumbers = numberOfAvailableSeats > 0;
            hasValidNumber = usesSeatNumbers && this.covers > numberOfAvailableSeats ? Dialogs.displayChoiceDialog((String)("<html>The recommended number of " + Internationalization.getLiteralFor((String)"COVERS").toLowerCase() + " for this table is " + numberOfAvailableSeats + ".<br><br>Are you sure you want to proceed with " + this.covers + " " + Internationalization.getLiteralFor((String)"COVERS").toLowerCase() + "?" + MAX_COVER_WARNING + "</html>"), (String)"Continue?", (boolean)false) : true;
        }
        return hasValidNumber;
    }

    private void doSeatsAndCovers(int defaultCovers, int defaultSeats) {
        if (this.dialog == null) {
            this.dialog = new DoubleKeypadDialog(Internationalization.getLiteralFor((String)"NUMBER_OF_COVERS") + ": ", Internationalization.getLiteralFor((String)"NUMBER_OF_SEATS") + ": ", defaultCovers > 0 ? defaultCovers : Integer.MIN_VALUE, defaultSeats > 0 ? defaultSeats : Integer.MIN_VALUE);
        }
        this.dialog.resetFirstPressFlag();
        boolean result = Dialogs.displayDialog((JComponent)this.dialog, (String)PLEASE_ENTER_SEATS_COVERS, (boolean)true);
        if (!result) {
            this.covers = -1;
        } else if (!this.validateSeatsAndCovers()) {
            this.doSeatsAndCovers(this.dialog.getLeftKeypadValue(), this.dialog.getRightKeypadValue());
        } else {
            this.covers = this.dialog.getLeftKeypadValue();
            this.seats = this.dialog.getRightKeypadValue();
        }
    }

    private boolean validateSeatsAndCovers() {
        if (this.dialog.getLeftKeypadValue() > this.dialog.getRightKeypadValue()) {
            Dialogs.displayOkDialog((String)INVALID_INPUT_MSG, (String)"More covers than seats!");
            return false;
        }
        return true;
    }

    public static int getValueForSeats(ItemGroup account) {
        return account instanceof TableAccount && SystemProperty.getInstance().isCoversAndSeatsSeparated() ? ((TableAccount)account).getSeats() : account.getNumPatrons();
    }

    public static String amendLiteral(String toAmend) {
        String seat = Internationalization.getLiteralFor((String)"SEAT");
        String cover = Internationalization.getLiteralFor((String)"COVER");
        String toReturn = toAmend;
        if (SystemProperty.getInstance().isCoversAndSeatsSeparated()) {
            toReturn = toReturn.replace(cover.toLowerCase(), seat.toLowerCase());
            toReturn = toReturn.replace(cover.toUpperCase(), seat.toUpperCase());
            toReturn = toReturn.replace(cover, seat);
        } else {
            toReturn = toReturn.replace(seat.toLowerCase(), cover.toLowerCase());
            toReturn = toReturn.replace(seat.toUpperCase(), cover.toUpperCase());
            toReturn = toReturn.replace(seat, cover);
        }
        return toReturn;
    }

    public static String getCorrectCoverLiteral() {
        return SystemProperty.getInstance().isCoversAndSeatsSeparated() ? Internationalization.getLiteralFor((String)"SEAT") : Internationalization.getLiteralFor((String)"COVER");
    }
}

