/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import java.util.List;
import javax.swing.BoxLayout;
import ordermate.database.hardware.GTL;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.table.AbstractTableSelectionPanel;
import waitermate.gui.screens.selectaccount.table.UnallocatedTableAccountSelection;
import waitermate.gui.tablelayout.GTLMode;
import waitermate.gui.tablelayout.RestaurantDisplayPanel;
import waitermate.gui.tablelayout.SectionEditorPanel;

public class GraphicalTableSelectionPanel
extends AbstractTableSelectionPanel {
    private RestaurantDisplayPanel tablesPanel;
    public final Signal<TableAccount, ?, ?, ?, ?> accountSelected = Signals.createSignal(TableAccount.class, (String)"selectedAccount");
    public final Signal<Account, ?, ?, ?, ?> allocateAccount = Signals.createSignal(Account.class, (String)"allocateAccount");
    private GTL gtl;

    public GraphicalTableSelectionPanel(boolean isUnallocatedTables, GTL gtl) {
        this.gtl = gtl;
        terminalChanged.connect((Object)this, "gotTerminalChanged");
        this.setLayout(new BoxLayout(this, 0));
        UnallocatedTableAccountSelection accountSelection = null;
        if (isUnallocatedTables) {
            accountSelection = new UnallocatedTableAccountSelection();
            accountSelection.accountSelected.connect((Object)this, "gotUnallocatedAccount");
            accountSelection.allocateAccount.connect((Object)this, "gotAllocateAccount");
        }
        this.tablesPanel = new RestaurantDisplayPanel(false, accountSelection, false, gtl);
        this.tablesPanel.setMode(GTLMode.Select);
        this.tablesPanel.tableGroupSelected.connect((Object)this, "gotTableGroupSelected");
        this.tablesPanel.tableSelected.connect((Object)this, "gotTable");
        this.tablesPanel.tableGroupUnlocked.connect(this.tableGroupUnlocked);
        this.add(this.tablesPanel);
        this.setMode(GTLMode.Select);
    }

    public void gotAllocateAccount(Account acc) {
        this.allocateAccount.emit((Object)acc);
    }

    public void gotUnallocatedAccount(TableAccount acc) {
        this.accountSelected.emit((Object)acc);
    }

    public void gotAccountAllocated(TableAccount acc) {
        this.gotTable(acc.getTable());
    }

    public void showUnallocatedTableSection() {
        this.tablesPanel.showUnallocatedTableSection();
    }

    @Override
    public void start() {
        this.tablesPanel.refresh();
    }

    @Override
    public void reloadTableGroupIfNecessary() {
        super.reloadTableGroupIfNecessary();
        this.tablesPanel.refreshUnallocatedSection();
    }

    @Override
    public GTL getGTL() {
        return this.gtl;
    }

    @Override
    public void setInterfaceLocked(boolean locked, String dialogText, String unlockButtonText) {
        this.tablesPanel.setInterfaceLocked(locked, dialogText, unlockButtonText);
    }

    @Override
    public void setInterfaceLocked(boolean locked) {
        this.tablesPanel.setInterfaceLocked(locked);
    }

    @Override
    public void setAllowInterfaceUnlocking(boolean allowIt) {
        this.tablesPanel.setAllowTableSectionUnlocking(allowIt);
    }

    @Override
    public boolean isInterfaceLocked() {
        return this.tablesPanel.isInterfaceLocked();
    }

    void gotTable(LogicalTable selectedTable) {
        this.tableSelected.emit((Object)selectedTable);
    }

    void gotTableGroupSelected(SectionEditorPanel sectionPanel) {
        this.tableGroupSelected.emit((Object)sectionPanel.getTableGroup());
        TableGroup currentTableGroup = sectionPanel.getTableGroup();
        sectionPanel.setInterfaceLocked(currentTableGroup.isLocked());
    }

    @Override
    public TableGroup getCurrentTableGroup() {
        return this.tablesPanel.getCurrentTableGroup();
    }

    void setMode(GTLMode mode) {
        this.tablesPanel.setMode(mode);
    }

    GTLMode getMode() {
        return this.tablesPanel.getMode();
    }

    void setGTLGridEnabled(boolean b) {
        this.tablesPanel.setGridEnabled(b);
    }

    boolean isGTLGridEnabled() {
        return this.tablesPanel.isGridEnabled();
    }

    @Override
    public void setCurrentTableGroup(TableGroup group) {
        this.tablesPanel.setCurrentTableGroup(group);
    }

    public List<TableGroup> getTableGroups() {
        return this.tablesPanel.getTableGroups();
    }

    public void gotTerminalChanged() {
        this.tablesPanel.terminalChanged();
    }
}

