/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.CustomerCard;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.gui.reservation.ReservationUtils;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.integration.reservations.ReservationNotifier;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.table.GraphicalTableSelectionPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

class MoveTabs {
    public Signal done = Signals.createSignal();
    private PopupWindow popup;
    private GraphicalTableSelectionPanel tablePanel;
    private LogicalTable sourceTable;
    private LogicalTable targetTable;
    private NavBar bar;
    private Set<BarTabAccount> accounts;
    private DataScrollPaneModel selectionModel;
    private final ReservationUtils reservationUtils = new ReservationUtils((GuiHandler)new WaitermateGuiHandler());

    MoveTabs() {
    }

    public void startMoveTabs() {
        this.targetTable = null;
        this.accounts = new HashSet<BarTabAccount>();
        this.doSelectTabs();
    }

    private void doSelectTabs() {
        this.bar = new NavBar();
        this.bar.cancel.connect((Object)this, "gotCancel");
        this.bar.addLeft((Component)this.bar.getCancelButton());
        this.bar.addRight((Component)this.bar.getOkButton());
        this.bar.getOkButton().setEnabled(false);
        this.tablePanel = new GraphicalTableSelectionPanel(false, Terminal.getLocalHost().getGtl());
        this.tablePanel.tableSelected.connect((Object)this, "gotSourceTable");
        this.bar.setText("Please select the tab to move");
        this.bar.removeRight((Component)this.bar.getOkButton());
        this.popup = new PopupWindow(this.bar);
        this.popup.setComponent((JComponent)this.tablePanel);
        WaiterMateInputAdapter.getInstance().customerCardInput.connect((Object)this, "gotCustomerCard");
        this.popup.startFillTheFrame();
    }

    public void gotSourceTable(LogicalTable table) {
        if (table == null || table.getBarTabs().isEmpty()) {
            Dialogs.displayOkDialog((String)"That Table has no Tabs upon it.", (String)"Select a table with tabs");
            return;
        }
        if (!WaitermateSaveAccount.getInstance().lockAccount((Lockable)table)) {
            return;
        }
        this.sourceTable = table;
        List possibleTabs = this.sourceTable.getBarTabs();
        if (possibleTabs.size() == 1) {
            if (!WaitermateSaveAccount.getInstance().lockAccount((Lockable)possibleTabs.get(0))) {
                return;
            }
            this.accounts.add((BarTabAccount)possibleTabs.get(0));
        } else {
            this.accounts.addAll(this.selectMultiChoice(possibleTabs));
        }
        if (!this.accounts.isEmpty()) {
            this.gotSelectTabsDone();
        } else {
            this.sourceTable.unlock();
        }
    }

    private List<BarTabAccount> selectMultiChoice(List<BarTabAccount> possibleAccounts) {
        this.selectionModel = new DataScrollPaneModel(3, 6);
        this.selectionModel.setItems(possibleAccounts, true, false, false);
        CustomScrollPane scrolly = new CustomScrollPane((CustomScrollPaneModel)this.selectionModel);
        Dialogs.displayOkDialog((JComponent)scrolly, (String)"Please select tabs to transfer");
        List selections = this.selectionModel.getSelections();
        if (selections == null || selections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BarTabAccount> barTabSelections = new ArrayList<BarTabAccount>();
        for (Displayable account : selections) {
            BarTabAccount nextAccount = (BarTabAccount)account;
            if (!nextAccount.lock(LoginManager.getInstance().getUser())) continue;
            barTabSelections.add(nextAccount);
        }
        return barTabSelections;
    }

    public void gotCustomerCard(CustomerCard card) {
        CustomerCardHelper helper = new CustomerCardHelper();
        BarTabAccount account = helper.getBarTabForCard(card);
        if (account == null) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.setSelected((Displayable)account);
        } else if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)account)) {
            this.accounts.add(account);
            this.gotSelectTabsDone();
        } else {
            Dialogs.displayOkDialog((String)"That Tab is locked by another user.", (String)"Cannot lock Tab");
        }
    }

    public void gotSelectTabsDone() {
        this.bar.cancel.disconnect((Object)this);
        this.tablePanel.tableSelected.disconnect((Object)this);
        WaiterMateInputAdapter.getInstance().customerCardInput.disconnect((Object)this);
        this.popup.gotOk();
        this.popup = new PopupWindow();
        this.popup.setComponent((JComponent)this.tablePanel);
        this.bar = this.popup.getNavBar();
        this.bar.removeRight((Component)this.bar.getOkButton());
        this.bar.cancel.connect((Object)this, "gotCancel");
        this.tablePanel.tableSelected.connect((Object)this, "gotTargetTable");
        this.bar.setText("Please select the target table.");
        JButton noTableButton = this.bar.constructButton((Icon)IconLoader.get((String)"/waitermate/images/card.png"), "No Table", "noTable");
        noTableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveTabs.this.gotTargetTable(null);
            }
        });
        OrderMateTheme.setupTransparentButton((AbstractButton)noTableButton);
        this.bar.addRight((Component)noTableButton);
        this.popup.startFillTheFrame();
    }

    public void gotCancel() {
        this.done();
    }

    public void gotTargetTable(LogicalTable table) {
        if (table != null) {
            if (table.equals((Object)this.sourceTable)) {
                Dialogs.displayOkDialog((String)"Cannot transfer to own table", (String)"Choose another table");
                return;
            }
            if (table.getAccount() != null) {
                Dialogs.displayOkDialog((String)"Cannot transfer to a table with a TableAccount upon it.", (String)"Cannot link to table");
                return;
            }
            EventContext context = LoginManager.getEventContext();
            if (!table.lock(context.getUser())) {
                Dialogs.displayOkDialog((String)"This table is locked by another user.", (String)"Cannot link to table");
                return;
            }
            if (!this.reservationUtils.isTableSelectable(table)) {
                table.unlock();
                return;
            }
        }
        this.targetTable = table;
        this.bar.ok.disconnect((Object)this);
        this.bar.cancel.disconnect((Object)this);
        this.performTransfer();
        this.popup.gotOk();
        this.done();
    }

    private void performTransfer() {
        if (!this.accounts.isEmpty()) {
            for (BarTabAccount account : this.accounts) {
                LogicalTable existingTable = account.getLogicalTable();
                account.delinkFromLogicalTable();
                ReservationNotifier.notifyForDelinkedAccount((LogicalTable)existingTable, (Account)account, (ReservationNotifier.DelinkReason)ReservationNotifier.DelinkReason.TRANSFER);
                if (this.targetTable != null) {
                    account.linkToLogicalTable(this.targetTable);
                }
                account.save();
                ReservationNotifier.notifyForLinkedAccount((LogicalTable)this.targetTable, (Account)account);
            }
        }
    }

    private void done() {
        WaiterMateInputAdapter.getInstance().customerCardInput.disconnect((Object)this);
        if (this.sourceTable != null) {
            this.sourceTable.unlock();
        }
        for (Account account : this.accounts) {
            account.unlock();
        }
        if (this.targetTable != null) {
            this.targetTable.unlock();
        }
        this.done.emit();
    }
}

