/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.Task;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.GTL;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.integration.loyalty.LoyaltyResyncTask;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.overview.WaiterMateOverview;
import waitermate.gui.screens.admin.tablesetup.TableSetup;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.transferitems.TransferItems;
import waitermate.gui.screens.reservations.WMReservationUtils;
import waitermate.gui.screens.selectaccount.AbstractAccountSelection;
import waitermate.gui.screens.selectaccount.table.AbstractTableSelectionPanel;
import waitermate.gui.screens.selectaccount.table.ButtonTableSelectionPanel;
import waitermate.gui.screens.selectaccount.table.GraphicalTableSelectionPanel;
import waitermate.gui.screens.selectaccount.table.MoveTabs;
import waitermate.gui.screens.selectaccount.table.TableAccountSelectionNav;
import waitermate.gui.screens.selectaccount.table.allocate.AllocateTableState;
import waitermate.gui.screens.selectaccount.table.allocate.LogicalTableAllocatorFactory;
import waitermate.gui.screens.selectaccount.takeaway.ScreenRefreshThread;
import waitermate.gui.tablelayout.ModifyTable;
import waitermate.gui.tablelayout.tablestate.TableStateModifier;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.ProgressDialog;

public class TableAccountSelection
extends AbstractAccountSelection
implements Refreshable {
    public final Signal<Account, ?, ?, ?, ?> accountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    public final Signal<List, Account, ?, ?, ?> accountsSelected = Signals.createSignal(List.class, (String)"accountList", Account.class, (String)"selectedAccount");
    public final Signal<LogicalTable, ?, ?, ?, ?> tableSelected = Signals.createSignal(LogicalTable.class, (String)"selectedTable");
    public final Signal<TableGroup, ?, ?, ?, ?> tableGroupChangedSignal = Signals.createSignal(TableGroup.class, (String)"tableGroup");
    public final Signal tableSelectionScreenChanged = Signals.createSignal();
    private TableSetup moveTablesScreen;
    private JPanel wrapperPanel;
    private AbstractTableSelectionPanel tableSelectionPanel;
    private ScreenRefreshThread refreshThread;
    private static final int refreshInterval = 5000;
    private AllocateTableState allocateTableState;
    private LogicalTable lastTableAccessed;
    private TableAccountSelectionNav nav;
    private boolean displayLastTableAccessedText = true;
    private final boolean showButtons;
    private MoveTabs moveTabs;
    private ModifyTable modify;
    private WaiterMateOverview overview;
    private final WMReservationUtils reservationUtils = new WMReservationUtils();

    public TableAccountSelection() {
        this(true, Terminal.getLocalHost().isUnallocatedTableAllowed());
    }

    public TableAccountSelection(boolean displayButtons, boolean showAllocateTables) {
        LogicalTable.setBoundingBoxIncludesAllTables((boolean)Terminal.getLocalHost().getGtl().isArrangeOnJoin());
        this.showButtons = displayButtons;
        this.wrapperPanel = new JPanel(new GridLayout(1, 1));
        this.tableGroupChangedSignal.connect((Object)this, "gotTableGroupChangedSignal");
        this.init(Terminal.getLocalHost().getGtl(), showAllocateTables);
        if (showAllocateTables) {
            this.setupAllocateAccount();
        }
    }

    public synchronized void init(GTL gtl, boolean isUnallocatedTablesMode) {
        boolean newNavBar;
        boolean bl = newNavBar = this.nav == null;
        if (newNavBar) {
            this.nav = new TableAccountSelectionNav(isUnallocatedTablesMode);
            this.setupNavForQuickTransfer(this.nav);
            this.nav.createNew.connect((Object)this, "gotCreateNew");
            this.nav.tableState.connect((Object)this, "gotTableState");
            this.nav.moveTables.connect((Object)this, "gotMoveTables");
            this.nav.moveTabs.connect((Object)this, "gotMoveTabs");
        }
        if (!this.showButtons) {
            this.nav.setCustomButtonsVisible(this.showButtons);
        }
        if (this.moveTablesScreen == null) {
            this.moveTablesScreen = new TableSetup();
            this.moveTablesScreen.back.connect((Object)this, "gotMoveTablesDone");
        }
        if (!gtl.equals((Object)Terminal.getLocalHost().getGtl()) && this.tableSelectionPanel != null) {
            this.tableSelectionPanel.tableGroupSelected.disconnect((Object)this);
            this.tableSelectionPanel.tableGroupUnlocked.disconnect((Object)this);
            this.tableSelectionPanel.tableSelected.disconnect((Object)this);
            if (this.tableSelectionPanel instanceof GraphicalTableSelectionPanel) {
                ((GraphicalTableSelectionPanel)this.tableSelectionPanel).accountSelected.disconnect((Object)this);
            }
            this.tableSelectionPanel = null;
        }
        if (this.tableSelectionPanel == null) {
            if (!GTL.None.equals((Object)gtl)) {
                GraphicalTableSelectionPanel gtlPanel = new GraphicalTableSelectionPanel(isUnallocatedTablesMode, gtl);
                this.tableSelectionPanel = gtlPanel;
                gtlPanel.accountSelected.connect((Object)this, "gotAccount");
            } else {
                this.tableSelectionPanel = new ButtonTableSelectionPanel(false);
            }
            this.tableSelectionPanel.tableGroupSelected.connect((Object)this, "gotTableGroupSelected");
            this.tableSelectionPanel.tableGroupUnlocked.connect((Object)this, "gotTableGroupUnlocked");
            this.tableSelectionPanel.setInterfaceLocked(this.tableSelectionPanel.getCurrentTableGroup() != null && this.tableSelectionPanel.getCurrentTableGroup().isLocked());
            this.wrapperPanel.add(this.tableSelectionPanel);
            this.tableSelectionPanel.tableSelected.connect((Object)this, "gotTable");
        }
    }

    public void setDisplayLastTableAccessedText(boolean display) {
        this.displayLastTableAccessedText = display;
    }

    public synchronized void setAllowInterfaceUnlocking(boolean allowIt) {
        this.tableSelectionPanel.setAllowInterfaceUnlocking(allowIt);
    }

    synchronized void gotTableGroupSelected() {
        TableGroup tableGroup = this.tableSelectionPanel.getCurrentTableGroup();
        this.updateGuiForLockState(tableGroup.isLocked());
        this.tableSelectionScreenChanged.emit();
    }

    synchronized void gotTableGroupUnlocked() {
        TableGroup tableGroup = this.tableSelectionPanel.getCurrentTableGroup();
        tableGroup.unlock();
        this.updateGuiForLockState(false);
        this.tableSelectionPanel.repaint();
    }

    synchronized void gotMoveTables() {
        this.reloadTableGroupIfNecessary();
        TableGroup tableGroup = this.tableSelectionPanel.getCurrentTableGroup();
        this.updateGuiForLockState(tableGroup.isLocked());
        if (!tableGroup.isLocked()) {
            this.moveTablesScreen.start(tableGroup);
        }
        this.tableSelectionPanel.repaint();
    }

    public JComponent getMainArea() {
        return this.wrapperPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public synchronized GTL getGtl() {
        return this.tableSelectionPanel.getGTL();
    }

    public void setGraphical(GTL gtl) {
        this.init(gtl, Terminal.getLocalHost().isUnallocatedTableAllowed());
    }

    public void setTableGroup(TableGroup group) {
        this.tableSelectionPanel.setCurrentTableGroup(group);
    }

    void gotMoveTablesDone() {
        this.setGraphical(Terminal.getLocalHost().getGtl());
        this.display();
    }

    private synchronized void reloadTableGroupIfNecessary() {
        this.tableSelectionPanel.reloadTableGroupIfNecessary();
    }

    public synchronized void refresh() {
        if (this.tableSelectionPanel.isVisible() && !ScreenResource.isDialogShowing()) {
            this.reloadTableGroupIfNecessary();
            this.nav.refresh();
        }
    }

    private synchronized void updateGuiForLockState(boolean sectionLocked) {
        User currentUser = LoginManager.getInstance().getUser();
        if (currentUser != null) {
            boolean hasPermission = currentUser.hasPermission(AllPermissions.MOVE_TABLE);
            if (this.tableSelectionPanel != null) {
                if (!GTL.None.equals((Object)this.tableSelectionPanel.getGTL())) {
                    this.tableSelectionPanel.setInterfaceLocked(sectionLocked);
                    this.nav.setMoveTableButtonEnabled(!sectionLocked && hasPermission);
                }
                this.tableSelectionPanel.repaint();
            }
            this.nav.repaint();
        }
    }

    synchronized void gotTable(LogicalTable logicalTable) {
        this.reloadTableGroupIfNecessary();
        TableGroup tableGroup = this.tableSelectionPanel.getCurrentTableGroup();
        this.tableSelectionPanel.setInterfaceLocked(tableGroup.isLocked());
        this.updateGuiForLockState(tableGroup.isLocked());
        if (tableGroup.isLocked()) {
            return;
        }
        if (!logicalTable.getPrimaryPhysicalTable().isCanOrderTo()) {
            return;
        }
        LogicalTable theTable = this.tableSelectionPanel.getCurrentTableGroup().reacquireTable(logicalTable);
        this.tableSelected.emit((Object)theTable);
        this.lastTableAccessed = logicalTable;
        this.updateLastTableText();
    }

    protected void gotAccountAllocated(LogicalTable table, Account acc) {
        int duration = this.reservationUtils.determineDuration(table);
        if (duration == -1) {
            return;
        }
        acc.setDuration(duration);
        table.lock(acc.getUser());
        LogicalTableAllocatorFactory.getAllocatorFor(acc, table).allocateAccountToTable(table, acc);
        table.unlock();
        acc.unlock();
        if (table != null) {
            this.tableSelectionPanel.setCurrentTableGroup(table.getTableGroup());
        }
        this.display();
        if (BarTabAccount.TYPE.equals((Object)acc.getAccountType())) {
            this.openTableForTab((BarTabAccount)acc);
        }
    }

    public void gotUnallocatedAccount(Account account) {
        this.setupAllocateAccount();
        this.allocateTableState.gotUnallocatedAccount(account);
    }

    private void setupAllocateAccount() {
        if (this.allocateTableState == null) {
            this.allocateTableState = new AllocateTableState();
            this.allocateTableState.accountAllocated.connect((Object)this, "gotAccountAllocated");
            this.allocateTableState.back.connect((Object)this, "display");
            if (this.tableSelectionPanel instanceof GraphicalTableSelectionPanel) {
                ((GraphicalTableSelectionPanel)this.tableSelectionPanel).allocateAccount.connect((Object)this, "gotUnallocatedAccount");
            }
        }
    }

    private void updateLastTableText() {
        if (this.displayLastTableAccessedText && this.lastTableAccessed != null) {
            this.nav.setText("<html>Last Table Accessed:<br> Section " + this.lastTableAccessed.getTableGroup() + "<br>Table " + this.lastTableAccessed + "<html>");
        }
    }

    @Override
    public synchronized void setUp() {
        this.tableSelectionPanel.start();
        TableGroup tableGroup = this.tableSelectionPanel.getCurrentTableGroup();
        if (tableGroup != null) {
            this.updateGuiForLockState(tableGroup.isLocked());
        }
        if (this.refreshThread == null) {
            this.refreshThread = new ScreenRefreshThread(this, 5000);
        }
        this.updateLastTableText();
        super.setUp();
        if (this.overview != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableAccountSelection.this.overview.adjustSizes();
                    TableAccountSelection.this.overview.setVisible(true);
                }
            });
        }
    }

    public void tearDown() {
        if (this.refreshThread != null) {
            this.refreshThread.stop();
            this.refreshThread = null;
        }
        if (this.overview != null) {
            this.overview.setVisible(false);
        }
    }

    public void gotCreateNew() {
        ((GraphicalTableSelectionPanel)this.tableSelectionPanel).showUnallocatedTableSection();
        TableAccount account = new TableAccount(LoginManager.getInstance().getUser(), null, 1, Terminal.getLocalHost());
        if (WaitermateSaveAccount.getInstance().getTicketData((Account)account)) {
            this.accountSelected.emit((Object)account);
        }
    }

    public void gotAccount(TableAccount acc) {
        this.accountSelected.emit((Object)acc);
    }

    @Override
    public List<AccountType> getAccountTypes() {
        return Arrays.asList(AccountType.tableType);
    }

    @Override
    public synchronized void gotQuickTransfer() {
        TransferItems.getInstance().startTransfer(this.getTabName(), this.quickTransferDone, this.quickTransferAborted, true, this.tableSelectionPanel.getCurrentTableGroup(), this.tableGroupChangedSignal);
    }

    private void gotTableGroupChangedSignal(TableGroup group) {
        this.tableSelectionPanel.setCurrentTableGroup(group);
    }

    public void gotCustomerCard(CustomerCard theCard) {
        CustomerCardHelper helper;
        BarTabAccount tab;
        if (!this.isDisplaying() || theCard == null || this.moveTabs != null || ScreenResource.isDialogShowing()) {
            return;
        }
        if (SystemProperty.getInstance().isLoyaltyEnabled()) {
            ProgressDialog.doProgressDialog((Task)new LoyaltyResyncTask((GuiHandler)new WaitermateGuiHandler(), theCard));
        }
        if ((tab = (helper = new CustomerCardHelper((GuiHandler)new WaitermateGuiHandler())).createOrGetBarTab(theCard, LoginManager.getEventContext())) != null) {
            if (tab.getLogicalTable() != null) {
                this.openTableForTab(tab);
            } else {
                this.gotUnallocatedAccount((Account)tab);
            }
        }
    }

    private void openTableForTab(BarTabAccount tab) {
        LogicalTable table = tab.getLogicalTable();
        if (table == null) {
            this.accountsSelected.emit(Collections.singletonList(tab), (Object)tab);
        } else if (table.getBarTabs() != null) {
            this.accountsSelected.emit((Object)table.getBarTabs(), (Object)tab);
        }
    }

    public void gotMoveTabs() {
        this.moveTabs = new MoveTabs();
        this.moveTabs.done.connect((Object)this, "gotMoveTabsDone");
        this.moveTabs.startMoveTabs();
    }

    public void gotMoveTabsDone() {
        this.moveTabs.done.disconnect((Object)this);
        this.moveTabs = null;
        this.refresh();
    }

    public void gotTableState(LogicalTableState newState) {
        if (this.modify == null) {
            this.modify = new ModifyTable(new TableStateModifier(newState, LoginManager.getEventContext()));
            this.modify.done.connect((Object)this, "gotStateModificationDone");
        }
        this.modify.doSelection();
    }

    public void gotStateModificationDone() {
        this.modify.done.disconnect((Object)this);
        this.modify = null;
        this.tableSelectionPanel.start();
    }

    public void setOverviewPanel(WaiterMateOverview newOverview) {
        this.overview = newOverview;
        if (this.overview != null) {
            this.overview.install(this.getMainArea());
        }
    }
}

