/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.TableAccount;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.table.UnallocatedTableRenderer;

public class UnallocatedTableAccountSelection
extends JPanel
implements Refreshable {
    private final RendererScrollPaneModel<TableAccount> accountsModel;
    public final Signal<TableAccount, ?, ?, ?, ?> accountSelected = Signals.createSignal(TableAccount.class, (String)"account");
    public final Signal<Account, ?, ?, ?, ?> allocateAccount = Signals.createSignal(Account.class, (String)"account");
    private CustomScrollPane pane;

    public UnallocatedTableAccountSelection() {
        super(new BorderLayout());
        UnallocatedTableRenderer renderer = new UnallocatedTableRenderer();
        this.accountsModel = new RendererScrollPaneModel((Renderer)renderer, 3, 5);
        renderer.selected.connect((Object)this, "gotAccount");
        renderer.allocateAccount.connect((Object)this, "gotAllocateAccount");
        this.pane = new CustomScrollPane(this.accountsModel);
        this.add((Component)this.pane, "Center");
    }

    public void refresh() {
        this.accountsModel.setObjects(this.getUnallocatedTableAccounts());
    }

    protected void gotAccount(Displayable account) {
        this.accountSelected.emit((Object)((TableAccount)account));
    }

    protected void gotAllocateAccount(TableAccount acc) {
        this.allocateAccount.emit((Object)acc);
    }

    private List<TableAccount> getUnallocatedTableAccounts() {
        ObjectQuery query = Query.select(TableAccount.class).isNull(TableAccount.Properties.TABLE).orderBy(Account.Properties.CREATION_DATE_TIME).equals(TableAccount.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN);
        return PersistenceManager.getObjectList(TableAccount.class, (String)query.toString(), null);
    }
}

