/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.border.LineBorder;
import ordermate.database.Payable;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.users.User;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.selectaccount.table.UnallocatedTableRendererButtonPanel;

class UnallocatedTableRenderer
implements Renderer<UnallocatedTableRendererButtonPanel, TableAccount> {
    final LineBorder loggedUsersAccountBorder = new LineBorder(Color.BLUE, 3);
    private final DisplayableRenderer wrappedRenderer = new DisplayableRenderer();
    public final Signal allocateAccount = Signals.createSignal(TableAccount.class, (String)"unallocatedAccount");
    public final Signal selected;

    UnallocatedTableRenderer() {
        this.selected = this.wrappedRenderer.selected;
    }

    public UnallocatedTableRendererButtonPanel createComponent() {
        CustomButton button = (CustomButton)this.wrappedRenderer.createComponent();
        JButton allocateButton = new JButton("Allocate", IconLoader.get((String)"/waitermate/images/fatarrow.png"));
        allocateButton.setHorizontalTextPosition(0);
        allocateButton.setVerticalTextPosition(3);
        UnallocatedTableRendererButtonPanel panel = new UnallocatedTableRendererButtonPanel((CustomButton<TableAccount>)button, allocateButton, this.allocateAccount);
        return panel;
    }

    public void setupComponent(UnallocatedTableRendererButtonPanel component, TableAccount tableAccount, int index) {
        SalesItem item;
        Iterator iterator;
        Reservation res;
        List reservations;
        CustomButton<TableAccount> button = component.getCustomButton();
        this.wrappedRenderer.setupComponent(component.getCustomButton(), (Object)tableAccount, index);
        if (!tableAccount.isLocked() && tableAccount.getPaidState().equals(Payable.PAID)) {
            button.setBackground(Displayable.PAID_COLOR);
        }
        StringBuilder label = new StringBuilder("<html><SPAN style='font-size:large;'><b>#").append(tableAccount.getOrderNumber()).append(" - ").append(DateTimeUtils.formatTimeForDisplay((Date)tableAccount.getCreationTime())).append("</B></SPAN><BR>");
        if (ReservationIntegrationUtils.isCloudReservationsConfigured() && (reservations = ReservationsHelper.getReservationsForTableAccount((TableAccount)tableAccount)) != null && !reservations.isEmpty()) {
            label.append("<b>Res: ");
            res = (Reservation)reservations.get(0);
            if (res.getCustomer() != null) {
                label.append(res.getCustomerName());
            } else {
                label.append(res.getExternalId());
            }
            label.append("<br></b>");
        }
        User orderedBy = null;
        res = tableAccount.getItemHelper().getSalesItems().iterator();
        if (res.hasNext() && (iterator = (item = (SalesItem)res.next()).getSalesItemQuantities().iterator()).hasNext()) {
            SalesItemQuantity qty = (SalesItemQuantity)iterator.next();
            orderedBy = qty.getUser();
        }
        component.setBorder(null);
        if (orderedBy != null) {
            label.append("Ordered by ").append(orderedBy.getFirstName()).append(" - ");
            if (orderedBy.equals((Object)LoginManager.getInstance().getUser())) {
                component.setBorder(this.loggedUsersAccountBorder);
            }
        }
        label.append("<B>Total: ").append(tableAccount.getSavedTotal()).append("</B><BR>");
        Iterator it = tableAccount.getTicketData().iterator();
        while (it.hasNext()) {
            label.append((String)it.next());
            if (!it.hasNext()) continue;
            label.append(", ");
        }
        button.setText(label.toString());
    }
}

