/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table.allocate;

import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.integration.ReservationIntegrationUtils;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.gui.screens.selectaccount.table.allocate.LogicalTableAllocator;

class TableAccountAllocator
implements LogicalTableAllocator<TableAccount> {
    TableAccountAllocator() {
    }

    @Override
    public Account allocateAccountToTable(LogicalTable table, TableAccount unallocatedTableAccount) {
        Account transferedAccount = this.transferTable(table, unallocatedTableAccount);
        if (transferedAccount == null) {
            return null;
        }
        int patrons = 0;
        if (transferedAccount instanceof TableAccount) {
            if (DeterminePatrons.Gui.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
                CoversHelper ch = new CoversHelper();
                ch.promptForCovers(this.getStartingPatrons(table, unallocatedTableAccount), unallocatedTableAccount.getSeats(), table);
                ch.updateAccount((TableAccount)transferedAccount);
            } else if (DeterminePatrons.TableDefault.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
                patrons = table.getNumberOfSeats();
                transferedAccount.setNumPatrons(patrons);
            }
        }
        if (!transferedAccount.getItems().isEmpty()) {
            WaitermateSaveAccount.getInstance().closeAccount(transferedAccount, false, false, LoginManager.getEventContext());
        }
        WaitermateSaveAccount.getInstance().saveAccount(transferedAccount, LoginManager.getEventContext());
        ReservationIntegrationUtils.reservationAccountCreated((Account)transferedAccount);
        this.printAccount(transferedAccount);
        return transferedAccount;
    }

    protected Account transferTable(LogicalTable table, TableAccount tableAccount) {
        tableAccount.setTable(table);
        table.setAccount(tableAccount);
        return tableAccount;
    }

    protected int getStartingPatrons(LogicalTable table, TableAccount tableAccount) {
        return 0;
    }

    protected void printAccount(Account account) {
        WaitermateSaveAccount.getInstance().printClosingReceipts(account);
        WaitermateSaveAccount.getInstance().printPrep(account);
    }
}

