/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.takeaway;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.Displayable;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import waitermate.LoginManager;
import waitermate.gui.screens.selectaccount.AbstractAccountSelection;
import waitermate.gui.screens.selectaccount.takeaway.ScreenRefreshThread;
import waitermate.guikit.NavBar;

public abstract class AbstractTakeAwaySelection
extends AbstractAccountSelection
implements Refreshable {
    private CustomScrollPane accountsPane;
    private RendererScrollPaneModel<Account> accounts = new RendererScrollPaneModel(this.getRenderer(), 3, 6);
    private NavBar nav;
    private ScreenRefreshThread checkThread;
    boolean setup;

    protected abstract Account createNewAccount(User var1, Terminal var2);

    public abstract AccountType getAccountType();

    public AbstractTakeAwaySelection() {
        this.accountsPane = new CustomScrollPane(this.accounts);
        this.accountsPane.setEmptyMessage("There are no " + this.getTabName() + " orders");
        this.setup = false;
    }

    protected Renderer getRenderer() {
        DisplayableRenderer renderer = new DisplayableRenderer();
        renderer.selected.connect((Object)this, "gotAccount");
        return renderer;
    }

    protected void setNav(NavBar newNav) {
        this.nav = newNav;
    }

    @Override
    public synchronized void setUp() {
        this.accounts.setObjects(this.getAccounts());
        if (this.checkThread == null) {
            this.checkThread = new ScreenRefreshThread(this, this.getRefreshIntervalMilliSecs());
        }
    }

    protected int getRefreshIntervalMilliSecs() {
        return 15000;
    }

    public synchronized void gotAccount(Displayable selected) {
        this.accountSelected.emit((Object)((Account)selected));
    }

    public synchronized void gotCreateNew() {
        Account newAccount = this.createNewAccount(LoginManager.getInstance().getUser(), Terminal.getLocalHost());
        if (newAccount != null) {
            this.accountSelected.emit((Object)newAccount);
        }
    }

    public JComponent getMainArea() {
        return this.accountsPane;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public synchronized void tearDown() {
        if (this.checkThread != null) {
            this.checkThread.stop();
            this.checkThread = null;
        }
    }

    public synchronized void refresh() {
        this.accounts.setObjects(this.getAccounts());
    }

    protected List<Account> getAccounts() {
        return Account.getOpenAccounts((AccountType)this.getAccountType());
    }

    @Override
    public List<AccountType> getAccountTypes() {
        return Arrays.asList(this.getAccountType());
    }
}

