/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.takeaway.bartabs;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.integration.reservations.ReservationNotifier;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.gui.screens.reservations.WMReservationUtils;
import waitermate.gui.screens.selectaccount.table.GraphicalTableSelectionPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class AssignBarTabToTable
extends AbstractScreen {
    private final GraphicalTableSelectionPanel selectionPanel;
    private final NavBar nav;
    private BarTabAccount sourceBarTabAccount;
    private final WMReservationUtils reservationUtils = new WMReservationUtils();

    public AssignBarTabToTable() {
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.selectionPanel = new GraphicalTableSelectionPanel(false, Terminal.getLocalHost().getGtl());
        this.selectionPanel.tableSelected.connect((Object)this, "gotTable");
    }

    protected void gotTable(LogicalTable table) {
        if (table.getAccount() != null) {
            Dialogs.displayOkDialog((String)"Table Account", (String)"This table already has a non-tab account upon it.");
        } else if (!LoginManager.getInstance().getUser().equals((Object)table.getUser()) && !table.lock(LoginManager.getInstance().getUser())) {
            Dialogs.displayOkDialog((String)"Account Locked", (String)("This table is locked by " + table.getUser()));
        } else {
            int duration = 0;
            if (table.getBarTabs().size() == 0 && (duration = this.reservationUtils.determineDuration(table)) == -1) {
                table.unlock();
                return;
            }
            this.sourceBarTabAccount.setDuration(duration);
            LogicalTable existingTable = this.sourceBarTabAccount.getLogicalTable();
            if (existingTable != null && !table.equals((Object)existingTable)) {
                this.sourceBarTabAccount.delinkFromLogicalTable();
                ReservationNotifier.notifyForDelinkedAccount((LogicalTable)existingTable, (Account)this.sourceBarTabAccount, (ReservationNotifier.DelinkReason)ReservationNotifier.DelinkReason.CLOSE);
            }
            this.sourceBarTabAccount.linkToLogicalTable(table);
            this.sourceBarTabAccount.save();
            table.unlock();
            ReservationNotifier.notifyForLinkedAccount((LogicalTable)table, (Account)this.sourceBarTabAccount);
            this.selectionPanel.tableSelected.disconnect((Object)this);
            this.getBackSignal().emit();
        }
    }

    public JComponent getMainArea() {
        return this.selectionPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void doMoveBarTabToTable(Account account) {
        block0: {
            this.sourceBarTabAccount = (BarTabAccount)account;
            this.nav.setText("Select target table");
            this.display();
            Iterator<TableGroup> iterator = this.selectionPanel.getTableGroups().iterator();
            if (!iterator.hasNext()) break block0;
            TableGroup group = iterator.next();
            this.selectionPanel.setCurrentTableGroup(group);
        }
    }

    public Signal getBackSignal() {
        return this.nav.back;
    }
}

