/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.takeaway.bartabs;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.database.EventContext;
import ordermate.database.gui.configmanager.GuiConfigManager;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.sales.AbstractTakeawayAccount;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.ItemGroup;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.Renderer;
import ordermate.integration.eftpos.manager.EftposManager;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.loyalty.LoyaltyResyncTask;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.displayitems.BarTabRenderer;
import waitermate.gui.screens.ordering.accountitems.WaitermatePreauth;
import waitermate.gui.screens.selectaccount.AccountNavBar;
import waitermate.gui.screens.selectaccount.takeaway.AbstractTakeAwaySelection;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.BarTabMatcherSearcher;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.BarTabSearchPanel;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.MergeBarTabs;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ObjectPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class BarTabSelection
extends AbstractTakeAwaySelection
implements ActionListener {
    private final String TabName = "Bar Tabs";
    private boolean showOldTabs = true;
    private JButton createCard;
    private JButton mergeTabs;
    private JButton searchTabs;
    private MergeBarTabs tabs;
    private boolean listening = true;
    private AccountSearcher searcher;
    private BarTabMatcherSearcher matcherSearcher;
    private BarTabSearchPanel searchPanel;
    private PopupWindow window;

    public BarTabSelection(boolean showTabsCreatedOnOtherTradingDays) {
        this.getMainArea().setName(GuiConfigManager.CompStrings.SELECT_BAR_TAB.toString());
        this.searcher = new AccountSearcher(1000, BarTabAccount.Properties.TAB_NAME);
        this.searcher.setAccountTypes(Collections.singletonList(AccountType.barTabType));
        this.searcher.setAccountOpen(true);
        AccountNavBar nav = new AccountNavBar();
        this.setupNavForQuickTransfer(nav);
        this.showOldTabs = showTabsCreatedOnOtherTradingDays;
        this.createCard = nav.constructButton(IconLoader.get((String)"/waitermate/images/addCard.png"), "New Bar Tab", "New Bar Tab");
        this.createCard.addActionListener(this);
        this.mergeTabs = nav.constructButton(IconLoader.get((String)"/waitermate/images/merge_tabs.png"), "Merge Tabs", "mergeTabs");
        this.mergeTabs.addActionListener(this);
        this.searchTabs = nav.constructButton(IconLoader.get((String)"/waitermate/images/allAccounts.png"), "Search...", "searchTabs");
        this.searchTabs.addActionListener(this);
        nav.setCreateNewVisible(false);
        nav.addRight(this.createCard);
        nav.addRight((Component)new StandardSecurityDecorator((JComponent)this.mergeTabs, AllPermissions.CREATE_BARTAB));
        nav.addRight(this.searchTabs);
        this.setNav(nav);
    }

    @Override
    protected Renderer getRenderer() {
        BarTabRenderer renderer = new BarTabRenderer();
        renderer.selected.connect((Object)this, "gotAccount");
        return renderer;
    }

    @Override
    protected int getRefreshIntervalMilliSecs() {
        return 2000;
    }

    protected AbstractTakeawayAccount createNewAccount(User user, Terminal terminal) {
        String name = Dialogs.getString((String)"Bar Tab Name: ");
        if ("\u0000".equals(name)) {
            return null;
        }
        BarTabAccount existingBarTab = (BarTabAccount)AccountQueries.getBarTabWithName((String)name);
        if (existingBarTab == null) {
            return new BarTabAccount(user, terminal, name);
        }
        String title = Internationalization.getLiteralFor((String)"CREATE_BARTAB");
        String message = Internationalization.getLiteralFor((String)"BARTAB_ALREADY_EXISTS").replace("{}", name);
        boolean openExistingBartab = Dialogs.displayChoiceDialog((String)message, (String)title, (boolean)false);
        if (openExistingBartab) {
            return existingBarTab;
        }
        return null;
    }

    @Override
    public AccountType getAccountType() {
        return BarTabAccount.TYPE;
    }

    public String getTabName() {
        return "Bar Tabs";
    }

    @Override
    public List<Account> getAccounts() {
        if (this.showOldTabs) {
            this.searcher.setTradingDay(null);
        } else {
            this.searcher.setTradingDay(TradingDay.getCurrentTradingDay());
        }
        return PersistenceManager.getObjectList((ObjectQuerySearcher)this.searcher);
    }

    private void gotMergeTabs() {
        this.listening = false;
        this.tabs = new MergeBarTabs();
        this.tabs.done.connect((Object)this, "gotMergeDone");
        this.tabs.start();
    }

    public void gotMergeDone() {
        this.listening = true;
        this.tabs.done.disconnect((Object)this);
        this.tabs = null;
        this.display();
    }

    private void searchTabs() {
        if (this.matcherSearcher == null) {
            this.matcherSearcher = new BarTabMatcherSearcher();
            this.searchPanel = new BarTabSearchPanel(this.matcherSearcher);
            this.searchPanel.objectSelected.connect((Object)this, "gotAccountSelected");
            this.window = new PopupWindow(true);
            this.window.getNavBar().getCancelButton().setText("Cancel");
            this.window.setComponent((JComponent)this.searchPanel);
        }
        ArrayList<BarTabAccount> barTabs = new ArrayList<BarTabAccount>(this.getAccounts().size());
        for (Account account : this.getAccounts()) {
            barTabs.add((BarTabAccount)account);
        }
        this.matcherSearcher.setSearchList(barTabs);
        this.window.startFillTheFrame();
    }

    public void gotAccountSelected(Account value) {
        this.window.gotOk();
        this.gotAccount((Displayable)value);
    }

    public void gotCustomerCard(CustomerCard card) {
        if (this.listening && this.isDisplaying()) {
            if (card != null && SystemProperty.getInstance().isLiquorfileEnabled()) {
                ProgressDialog.doProgressDialog((Task)new LoyaltyResyncTask((GuiHandler)new WaitermateGuiHandler(), card));
            }
            CustomerCardHelper helper = new CustomerCardHelper((GuiHandler)new WaitermateGuiHandler());
            final BarTabAccount account = helper.createOrGetBarTab(card, LoginManager.getEventContext());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BarTabSelection.this.gotAccount((Displayable)account);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.createCard) {
            User user = LoginManager.getInstance().getUser();
            if (user != null) {
                boolean canCreate = user.hasPermission(AllPermissions.CREATE_BARTAB);
                if (Terminal.getLocalHost().isBartabPreauth()) {
                    boolean canPreauth = user.hasPermission(AllPermissions.PREAUTH_BARTAB);
                    if (canCreate && !canPreauth) {
                        this.gotCreateNew();
                    } else if (!canCreate && canPreauth) {
                        this.createWithPreauth();
                    } else if (canCreate && canPreauth) {
                        EventContext context = LoginManager.getEventContext();
                        VirtualEftpos vEft = EftposManager.getInstance().getEftposForCashDrawer(context.getTerminal().getAssignedCashDrawer(context.getUser()), context.getTerminal());
                        String CREDIT = "Credit Limited";
                        String PREAUTH = "Eftpos Preauthorised";
                        ObjectPopupWindow dialog = new ObjectPopupWindow.ObjectPopupWindowBuilder("Create with or without Preauth?", 1, 5, null).setAllowCancel(true).addSelectionButton((Object)CREDIT).addSelectionButton((Object)PREAUTH, vEft != null && vEft.isOnline()).build();
                        String response = (String)dialog.start();
                        if (PREAUTH.equals(response)) {
                            this.createWithPreauth();
                        } else if (CREDIT.equals(response)) {
                            this.gotCreateNew();
                        }
                    }
                } else if (canCreate) {
                    this.gotCreateNew();
                }
            }
        } else if (source == this.mergeTabs) {
            this.gotMergeTabs();
        } else if (source == this.searchTabs) {
            this.searchTabs();
        }
    }

    private void createWithPreauth() {
        String name = Dialogs.getString((String)"Bar Tab Name: ");
        if (name == "\u0000") {
            return;
        }
        BarTabAccount newAccount = new BarTabAccount(LoginManager.getInstance().getUser(), Terminal.getLocalHost(), name);
        Price amount = WaitermatePreauth.getAmount();
        if (amount == null) {
            return;
        }
        newAccount.lock(LoginManager.getInstance().getUser());
        newAccount.save();
        newAccount.unlock();
        WaitermatePreauth preauth = new WaitermatePreauth((ItemGroup)newAccount);
        preauth.preauthFinished.connect((Object)this, "preauthFinished");
        preauth.doAllocation(amount);
    }

    public void preauthFinished(PreauthResult result) {
        this.accountSelected.emit((Object)result.getRequest().getItemGroup().getAccount());
    }
}

