/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.takeaway.bartabs;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.misc.CustomerCard;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.MergeMultiplePanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class MergeBarTabs {
    private BarTabAccount targetAccount;
    private List<BarTabAccount> sourceAccounts = new ArrayList<BarTabAccount>();
    Signal done = Signals.createSignal();
    private PopupWindow popup;
    private MergeMultiplePanel mergeMultiple;
    private NavBar nav = new NavBar();

    MergeBarTabs() {
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.addLeft((Component)this.nav.getCancelButton());
        this.nav.ok.connect((Object)this, "gotOk");
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.nav.setText("Please Select the Target BarTab");
        this.popup = new PopupWindow(this.nav);
        this.mergeMultiple = new MergeMultiplePanel();
        this.mergeMultiple.selected.connect((Object)this, "gotAccount");
        this.mergeMultiple.deselected.connect((Object)this, "gotAccountRemoved");
        this.popup.setComponent((JComponent)this.mergeMultiple);
    }

    public void start() {
        this.mergeMultiple.setSelectableAccounts(Account.getOpenAccounts((AccountType)AccountType.barTabType));
        WaiterMateInputAdapter.getInstance().customerCardInput.connect((Object)this, "gotCustomerCard");
        this.targetAccount = null;
        this.sourceAccounts.clear();
        this.mergeMultiple.setTarget((Account)this.targetAccount);
        this.mergeMultiple.setSources(this.sourceAccounts);
        this.updateNav();
        this.showSelectAccount();
    }

    private void showSelectAccount() {
        this.popup.startFillTheFrame();
    }

    public void gotAccount(Displayable selection) {
        BarTabAccount account = (BarTabAccount)selection;
        this.nav.getOkButton().setEnabled(false);
        if (this.targetAccount == null) {
            if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)account)) {
                this.targetAccount = account;
                this.mergeMultiple.setTarget((Account)this.targetAccount);
            }
        } else if (!this.sourceAccounts.contains(account) && !this.targetAccount.equals((Object)account) && WaitermateSaveAccount.getInstance().lockAccount((Lockable)account)) {
            this.sourceAccounts.add(account);
            this.mergeMultiple.setSources(this.sourceAccounts);
        }
        this.updateNav();
    }

    public void gotAccountRemoved(Displayable removed) {
        if (removed != null && this.sourceAccounts.contains(removed)) {
            ((Account)removed).unlock();
            this.sourceAccounts.remove(removed);
            this.mergeMultiple.setSources(this.sourceAccounts);
        }
        this.updateNav();
    }

    private void updateNav() {
        if (this.targetAccount != null) {
            this.nav.setText("Select Source Accounts...");
        }
        this.nav.getOkButton().setEnabled(this.targetAccount != null && !this.sourceAccounts.isEmpty());
    }

    public void gotOk() {
        if (this.targetAccount != null && !this.sourceAccounts.isEmpty()) {
            if (this.presentSummary() && this.checkAccountLimit()) {
                this.doMerge();
            } else {
                this.done();
            }
        }
    }

    private boolean checkAccountLimit() {
        Price value = Price.ZERO_DOLLAR;
        for (BarTabAccount account : this.sourceAccounts) {
            value = value.add(account.getTotal());
        }
        if (this.targetAccount.exceedsCreditLimit(value)) {
            return CreditLimitPanel.doCreditLimitDialog((CreditLimited)this.targetAccount, value, this.targetAccount.getLabel(), true);
        }
        return true;
    }

    private boolean presentSummary() {
        StringBuilder SB = new StringBuilder("<html>This will merge ");
        int length = this.sourceAccounts.size();
        Price value = Price.ZERO_DOLLAR;
        for (BarTabAccount account : this.sourceAccounts) {
            value = value.add(account.getTotal());
        }
        SB.append(length).append(length == 1 ? " tab " : " tabs ").append("of a value of ").append(value.toString(true)).append("<br>to the tab ").append(this.targetAccount.getLabel()).append("<br><br>Are you sure you wish to proceed?</html>");
        return Dialogs.displayChoiceDialog((String)"Confirm Merge Tabs", (String)SB.toString(), (boolean)false);
    }

    private void doMerge() {
        EventContext context = LoginManager.getEventContext();
        for (BarTabAccount sourceAccount : this.sourceAccounts) {
            sourceAccount.transferItemsTo((Account)this.targetAccount, sourceAccount.getItems(), context);
            WaitermateSaveAccount.getInstance().saveAccount((Account)this.targetAccount, context);
            this.transferPreauth(sourceAccount);
            sourceAccount.close(context);
            sourceAccount.save();
            sourceAccount.unlock();
        }
        this.done();
    }

    private void transferPreauth(BarTabAccount sourceAccount) {
        PreauthTransaction txn = (PreauthTransaction)PersistenceManager.getObject(PreauthTransaction.class, (String)PreauthTransaction.getExisting((Account)sourceAccount).toString());
        if (txn != null) {
            txn.setAccount((Account)this.targetAccount);
            txn.save();
        }
    }

    public void gotCancel() {
        this.done();
    }

    public void gotCustomerCard(CustomerCard card) {
        CustomerCardHelper helper = new CustomerCardHelper();
        BarTabAccount account = helper.getBarTabForCard(card);
        if (account != null) {
            this.gotAccount((Displayable)account);
        }
    }

    private void done() {
        WaiterMateInputAdapter.getInstance().customerCardInput.disconnect((Object)this);
        if (this.targetAccount != null && this.targetAccount.isLocked(LoginManager.getInstance().getUser())) {
            this.targetAccount.unlock();
        }
        for (BarTabAccount account : this.sourceAccounts) {
            if (!account.isLocked(LoginManager.getInstance().getUser())) continue;
            account.unlock();
        }
        this.targetAccount = null;
        this.sourceAccounts.clear();
        this.mergeMultiple.setTarget((Account)this.targetAccount);
        this.mergeMultiple.setSources(this.sourceAccounts);
        this.done.emit();
    }
}

