/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.takeaway.bartabs;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.Account;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import ordermate.signals.Signal;

class MergeMultiplePanel
extends JPanel {
    public Signal<Displayable, ?, ?, ?, ?> selected;
    public Signal<Displayable, ?, ?, ?, ?> deselected;
    private CustomScrollPane accountsScroll;
    private RendererScrollPaneModel<Account> accountsModel;
    private CustomScrollPane selectedScroll;
    private RendererScrollPaneModel<Account> selectedModel;
    private Account targetAccount;
    private List<Account> sourceAccounts = new ArrayList<Account>();
    private JPanel selectedHolder;
    private JLabel targetLabel;

    MergeMultiplePanel() {
        super(new BorderLayout());
        this.setupComponents();
    }

    void setTarget(Account value) {
        this.targetAccount = value;
        if (this.targetAccount != null) {
            this.targetLabel.setText(this.targetAccount.getLabel());
            this.targetLabel.setVisible(true);
        } else {
            this.targetLabel.setVisible(false);
        }
        this.accountsScroll.setModel(this.accountsModel);
    }

    void setSources(List<? extends Account> values) {
        this.sourceAccounts.clear();
        this.sourceAccounts.addAll(values);
        this.selectedModel.setObjects(this.sourceAccounts);
        List allAccounts = this.accountsModel.getObjects();
        for (Account account : this.selectedModel.getObjects()) {
            allAccounts.set(allAccounts.indexOf(account), account);
        }
        this.accountsModel.setObjects(allAccounts);
        this.selectedScroll.setModel(this.selectedModel);
        this.accountsScroll.setModel(this.accountsModel);
        this.validate();
        this.repaint();
    }

    private void setupComponents() {
        DisplayableRenderer renderer = new DisplayableRenderer();
        this.selected = renderer.selected;
        this.accountsModel = new RendererScrollPaneModel((Renderer)renderer, 3, 6);
        this.accountsScroll = new CustomScrollPane(this.accountsModel);
        this.accountsScroll.setEmptyMessage("There are no BarTabs");
        this.add((Component)this.accountsScroll, "Center");
        this.selectedHolder = new JPanel(new BorderLayout());
        renderer = new DisplayableRenderer();
        this.deselected = renderer.selected;
        this.selectedModel = new RendererScrollPaneModel((Renderer)renderer, 4, 1);
        this.selectedScroll = new CustomScrollPane(this.selectedModel);
        this.selectedScroll.setDecorationLocation(DecoratorLocation.East);
        this.targetLabel = new JLabel(IconLoader.get((String)"/waitermate/images/leftarrow.png"));
        this.targetLabel.setHorizontalTextPosition(2);
        this.selectedHolder.add((Component)this.targetLabel, "West");
        this.targetLabel.setVisible(false);
        this.selectedHolder.add((Component)this.selectedScroll, "Center");
        this.add((Component)this.selectedHolder, "South");
    }

    public void setSelectableAccounts(List<Account> openAccounts) {
        this.accountsModel.setObjects(openAccounts);
    }
}

