/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.search;

import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.searchers.DefaultMatcherSearcher;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.keyboard.Keyboard;
import ordermate.gui.keyboard.KeyboardForSamsung;
import ordermate.gui.scroll.CustomButtonRenderer;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

public abstract class WMSearchPanel<T>
extends JPanel {
    protected static int NUM_RESULTS_TO_DISPLAY = 4;
    public Signal<T, ?, ?, ?, ?> objectSelected;
    public Signal<?, ?, ?, ?, ?> back = Signals.createSignal();
    private JLabel textLabel;
    private JLabel numResultsLabel;
    private JPanel resultPanel;
    private JPanel criteriaPanel;
    protected NavBar navBar;
    private RendererScrollPaneModel<T> resultsModel;
    protected Keyboard keyboard;
    protected DefaultMatcherSearcher searcher;

    public WMSearchPanel(DefaultMatcherSearcher<T> theSearcher, boolean addNav) {
        super(new BorderLayout());
        Class type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.objectSelected = Signals.createSignal((Class)type, (String)"selectedItem");
        this.searcher = theSearcher;
        this.searcher.addMatcherEditorListener(new MatcherEditor.Listener(){

            public void changedMatcher(MatcherEditor.Event arg0) {
                WMSearchPanel.this.updateResults();
            }
        });
        this.setupComponents(addNav);
    }

    private void setupComponents(boolean addNav) {
        this.setupCriteriaPanel();
        this.setupResultsPanel();
        this.setupKeyboardPanel();
        if (addNav) {
            this.setupNavBar();
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        this.setPreferredSize(new Dimension(1200, 600));
        this.setMaximumSize(new Dimension(1200, 800));
        topPanel.add((Component)this.resultPanel, "Center");
        topPanel.add((Component)this.criteriaPanel, "West");
        this.add((Component)topPanel, "North");
        this.add((Component)this.keyboard, "Center");
        if (addNav) {
            this.add((Component)this.navBar, "South");
        }
    }

    private void setupCriteriaPanel() {
        JPanel holder = new JPanel();
        this.criteriaPanel = new JPanel(new BorderLayout());
        holder.setLayout(new FlowLayout(0));
        JLabel itemNameLabel = new JLabel(this.getPrompt());
        itemNameLabel.setFont(OrderMateTheme.getLargeFont());
        holder.add(itemNameLabel);
        this.textLabel = new JLabel("");
        holder.add(this.textLabel);
        this.textLabel.setName("inputText");
        this.textLabel.setHorizontalAlignment(2);
        this.textLabel.setPreferredSize(new Dimension(200, 50));
        this.textLabel.setFont(OrderMateTheme.getLargeFont());
        this.criteriaPanel.add((Component)holder, "South");
        JLabel iconLabel = new JLabel(IconLoader.get((String)"/waitermate/images/bigSearch.png"));
        iconLabel.setText(Internationalization.getLiteralFor((String)"FIND_AN_ITEM"));
        iconLabel.setHorizontalTextPosition(0);
        iconLabel.setVerticalTextPosition(3);
        this.criteriaPanel.add((Component)iconLabel, "Center");
    }

    protected abstract String getPrompt();

    private void setupResultsPanel() {
        this.resultPanel = new JPanel(new BorderLayout());
        CustomButtonRenderer renderer = this.createRenderer();
        renderer.selected.connect((Object)this, "gotSelection");
        this.resultsModel = new RendererScrollPaneModel((Renderer)renderer, 1, NUM_RESULTS_TO_DISPLAY);
        CustomScrollPane scrolly = new CustomScrollPane(this.resultsModel);
        scrolly.setDecorationLocation(DecoratorLocation.East);
        this.resultPanel.add((Component)scrolly, "Center");
        this.numResultsLabel = new JLabel();
        this.resultPanel.add((Component)this.numResultsLabel, "South");
        this.numResultsLabel.setName("numResults");
        this.resultPanel.setPreferredSize(new Dimension(400, 200));
    }

    protected abstract CustomButtonRenderer createRenderer();

    public void gotSelection(Object item) {
        this.objectSelected.emit(item);
    }

    private void setupKeyboardPanel() {
        this.keyboard = new KeyboardForSamsung();
        this.keyboard.updated.connect((Object)this, "gotKeystroke");
    }

    protected void setupNavBar() {
        this.navBar = new NavBar();
        this.navBar.addLeft((Component)this.navBar.getBackButton());
        this.navBar.addRight((Component)this.navBar.getClearButton());
        this.navBar.back.connect((Object)this, "gotBack");
        this.navBar.clear.connect((Object)this, "gotClear");
    }

    public void gotKeystroke(String value) {
        this.keyboard.setValue(value);
        this.textLabel.setText(value);
        this.searcher.setSearchString(value);
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    private void updateResults() {
        EventList listOfItems = !this.searcher.isRestricted() ? new ArrayList() : this.searcher.getResultingList();
        this.resultsModel.setObjects((List)listOfItems);
        if (this.searcher.getResultCount() == 0) {
            this.numResultsLabel.setForeground(Color.RED);
            this.numResultsLabel.setText(Internationalization.getLiteralFor((String)"NO_RESULTS_TRY_WIDER_SEARCH"));
        } else {
            this.numResultsLabel.setForeground(null);
            this.numResultsLabel.setText(Internationalization.getLiteralFor((String)"RESULTS") + Internationalization.getLiteralFor((String)"COLON") + " " + this.searcher.getResultCount());
        }
    }

    public void startSearch(List<T> selectables, boolean reset) {
        this.searcher.setSearchList(selectables);
        if (reset) {
            this.gotClear();
        }
    }

    public void gotClear() {
        this.keyboard.setValue("");
        this.gotKeystroke("");
    }

    public void gotBack() {
        this.back.emit();
    }
}

