/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.hardware.Terminal;
import ordermate.database.tables.LogicalTable;
import ordermate.gui.JXTransformer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.table.GraphicalTableSelectionPanel;
import waitermate.gui.tablelayout.TableModifier;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class ModifyTable {
    public final Signal done = Signals.createSignal();
    private final TableModifier modifier;
    private GraphicalTableSelectionPanel tablePanel;
    private NavBar nav;

    public ModifyTable(TableModifier tableModifier) {
        this.modifier = tableModifier;
        this.tablePanel = new GraphicalTableSelectionPanel(false, Terminal.getLocalHost().getGtl());
        this.tablePanel.tableSelected.connect((Object)this, "gotTableSelected");
        this.nav = new NavBar();
        this.nav.back.connect(this.done);
        this.nav.ok.connect(this.done);
        this.nav.remove((Component)this.nav.getOkButton());
        this.nav.addLeft((Component)this.nav.getBackButton());
    }

    public void doSelection() {
        PopupWindow window = new PopupWindow(this.nav);
        JPanel panel = new JPanel(new BorderLayout(), false);
        panel.setOpaque(true);
        JXTransformer transformer = this.getTablePnlTransformer();
        if (transformer != null) {
            panel.add((Component)transformer);
        } else {
            panel.add(this.tablePanel);
        }
        window.setComponent((JComponent)panel);
        window.startFillTheFrame();
    }

    private JXTransformer getTablePnlTransformer() {
        JXTransformer transformer = new JXTransformer((JComponent)this.tablePanel);
        Dimension maxDialogDimension = ScreenResource.getMaxDialogDimension();
        double scaleX = this.getTablePnlScaleX(maxDialogDimension);
        double scaleY = this.getTablePnlScaleY(maxDialogDimension);
        if (scaleX >= 0.99 && scaleY >= 0.99) {
            return null;
        }
        transformer.scale(scaleX, scaleY);
        this.addRenderingHints(transformer);
        return transformer;
    }

    private double getTablePnlScaleY(Dimension maxDialogDimension) {
        double scaleY = 1.0;
        int maxTablePnlHeight = maxDialogDimension.height - 30 - 74 - 4;
        if (this.tablePanel.getHeight() > maxTablePnlHeight) {
            scaleY = 1.0 - (double)Math.abs(this.tablePanel.getHeight() - maxTablePnlHeight) * 1.0 / (double)this.tablePanel.getHeight();
        }
        return scaleY;
    }

    private double getTablePnlScaleX(Dimension maxDialogDimension) {
        double scaleX = 1.0;
        int maxTablePnlWidth = maxDialogDimension.width - 60 - 4;
        if (this.tablePanel.getWidth() > maxTablePnlWidth) {
            scaleX = 1.0 - (double)Math.abs(this.tablePanel.getWidth() - maxTablePnlWidth) * 1.0 / (double)this.tablePanel.getWidth();
        }
        return scaleX;
    }

    private void addRenderingHints(JXTransformer transformer) {
        HashMap<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        transformer.setRenderingHints(renderingHints);
    }

    public void gotTableSelected(LogicalTable table) {
        if (this.modifier.performActionOnTable(table)) {
            String success = this.modifier.getSuccess();
            if (success != null) {
                Dialogs.displayOkDialog((String)success, (String)this.modifier.getTitle());
            }
            this.nav.ok.emit();
        } else {
            String failure = this.modifier.getFailure();
            if (failure != null) {
                Dialogs.displayOkDialog((String)failure, (String)this.modifier.getTitle());
            }
        }
    }
}

