/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.ColourWheel;
import au.com.ordermate.util.image.IconLoader;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;
import ordermate.database.hardware.GTL;
import ordermate.database.hardware.Terminal;
import ordermate.database.queries.tables.PhysicalTableQueries;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationHeader;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.WaiterMate;

public abstract class SectionDisplayPanel
extends JPanel {
    private static final Color PRIMARY_TABLE_FONT_COLOR = Color.BLACK;
    private static final Font PRIMARY_TABLE_FONT = OrderMateTheme.getMediumFont();
    private static final Color TEXT_BACKGROUND_COLOR = Color.WHITE;
    private static final Color CHILD_TABLE_FONT_COLOR = Color.GRAY;
    private static final Font CHILD_TABLE_FONT = OrderMateTheme.getSmallFont();
    private static final Font STATE_FONT = OrderMateTheme.getSmallerFont().deriveFont(0, 11.0f);
    private static Font RESERVATION_FONT = OrderMateTheme.getSmallerFont().deriveFont(0, 9.0f);
    private TableGroup tableGroup;
    private Map<PhysicalTable, ReservationHeader> reservations = new ConcurrentHashMap<PhysicalTable, ReservationHeader>();
    private final DateFormat timeFormat = new SimpleDateFormat("H:mm");
    protected static final int SNAP_GRID_SIZE = 24;
    protected static final int SNAP_AMOUNT = 15;
    private boolean displayGrid = false;
    protected GTL gtl;
    private AlphaComposite colourComp = AlphaComposite.getInstance(3, 0.4f);
    private AlphaComposite halfComposite = AlphaComposite.getInstance(3, 0.5f);
    private ColourWheel colourWheel;
    private Color linkColour;
    protected Stroke linkOuterStroke = new BasicStroke(5.0f);
    protected Stroke linkStroke = new BasicStroke(3.0f);
    protected Stroke basicStroke = new BasicStroke(1.0f);
    private boolean paintOuterLine = true;

    public SectionDisplayPanel(TableGroup group, GTL gtl) {
        this.setLayout(null);
        this.setOpaque(false);
        this.gtl = gtl;
        this.setTableGroup(group);
    }

    public boolean isGridEnabled() {
        return this.displayGrid;
    }

    public void setGridEnabled(boolean b) {
        this.displayGrid = b;
        this.repaint();
    }

    protected LogicalTable getIntersectingTable(int x, int y, int width, int height) {
        Rectangle checkBounds = new Rectangle(x, y, width, height);
        for (LogicalTable logicalTable : this.tableGroup.getTables()) {
            for (PhysicalTable table : logicalTable.getPhysicalTables()) {
                Rectangle tableBounds = new Rectangle(table.getX(), table.getY(), table.getTableImageWidth(), table.getTableImageHeight());
                if (!tableBounds.intersects(checkBounds)) continue;
                return logicalTable;
            }
        }
        return null;
    }

    protected LogicalTable getIntersectingTable(LogicalTable tableToCheck) {
        for (LogicalTable logicalTable : this.tableGroup.getTables()) {
            if (logicalTable.equals((Object)tableToCheck)) continue;
            for (PhysicalTable table : logicalTable.getPhysicalTables()) {
                Rectangle existingTableBounds = table.getRect();
                for (PhysicalTable physicalTableToCheck : tableToCheck.getPhysicalTables()) {
                    Rectangle boundsToCheck = physicalTableToCheck.getRect();
                    if (!existingTableBounds.intersects(boundsToCheck)) continue;
                    return logicalTable;
                }
            }
        }
        return null;
    }

    public void refreshTableGroup() {
        TableGroup cachedGroup = (TableGroup)CacheManager.getInstance().retrieveObject(this.tableGroup.getID(), TableGroup.class);
        if (cachedGroup != null) {
            this.tableGroup = cachedGroup;
        }
        this.tableGroup = (TableGroup)PersistenceManager.preload((PersistentObject)this.tableGroup);
    }

    public void refreshReservations() {
        this.reservations.clear();
        Calendar cal = Calendar.getInstance();
        cal.add(10, -1);
        List todaysReservations = PersistenceManager.getObjectList(Reservation.class, (String)Query.select(Reservation.class).equals(Reservation.Properties.DATE, new Date(), SQLDateType.DATE).active(Reservation.class).not().equals(Reservation.Properties.RESERVATION_STATE, (Object)"ARRIVED").greaterThan(Reservation.Properties.TIME, cal.getTime(), SQLDateType.TIME).equals(Reservation.Properties.SECTION, (Object)this.tableGroup).orderBy(Reservation.Properties.TIME).toString());
        for (Reservation nextRes : todaysReservations) {
            String tablesString = nextRes.getTables();
            for (PhysicalTable nextTable : PhysicalTableQueries.getPhysicalTables((String)tablesString, (TableGroup)this.tableGroup)) {
                if (nextTable == null || this.reservations.containsKey(nextTable) || nextTable.getLogicalTable() == null || !nextTable.getLogicalTable().canOrderTo()) continue;
                this.reservations.put(nextTable, new ReservationHeader.ReservationHeaderBuilder(nextRes.getTime() != null ? this.timeFormat.format(nextRes.getTime()) : "", nextRes.getCustomerName()).build());
            }
        }
    }

    protected int getBackgroundWidth() {
        return this.tableGroup.getBackgroundImageWidth();
    }

    protected int getBackgroundHeight() {
        return this.tableGroup.getBackgroundImageHeight();
    }

    public boolean tableGroupContainsRect(int x, int y, int width, int height) {
        return x >= 0 && x + width < this.getBackgroundWidth() && y >= 0 && y + height < this.getBackgroundHeight();
    }

    protected int forceInTableGroupBoundsX(int x, int width) {
        if (x < 0) {
            return 0;
        }
        if (x + width >= this.getBackgroundWidth() - 1) {
            return this.getBackgroundWidth() - width - 1;
        }
        return x;
    }

    protected int forceInTableGroupBoundsY(int y, int height) {
        if (y < 0) {
            return 0;
        }
        if (y + height >= this.getBackgroundHeight() - 1) {
            return this.getBackgroundHeight() - height - 1;
        }
        return y;
    }

    protected int forceInBoundsX(int x, int width) {
        if (x < 0) {
            return 0;
        }
        if (x + width >= this.getWidth() - 1) {
            return this.getWidth() - width - 1;
        }
        return x;
    }

    protected int forceInBoundsY(int y, int height) {
        if (y < 0) {
            return 0;
        }
        if (y + height >= this.getHeight() - 1) {
            return this.getHeight() - height - 1;
        }
        return y;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public TableGroup getTableGroup() {
        return this.tableGroup;
    }

    public void setTableGroup(TableGroup group) {
        this.tableGroup = group;
        Dimension size = new Dimension(this.getBackgroundWidth(), this.getBackgroundHeight());
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
    }

    public PhysicalTable getTableAt(int x, int y) {
        for (LogicalTable logicalTable : this.tableGroup.getTables()) {
            for (PhysicalTable table : logicalTable.getPhysicalTables()) {
                int tableX = table.getX();
                int tableY = table.getY();
                if (x < tableX || x >= tableX + table.getTableImageWidth() || y < tableY || y >= tableY + table.getTableImageHeight()) continue;
                return table;
            }
        }
        return null;
    }

    protected abstract boolean isInterfaceLocked();

    protected Image getTableImage(PhysicalTable table) {
        return table.getTableImage().getImage();
    }

    protected Image getBackgroundImage() {
        return this.tableGroup.getBackgroundImageIcon().getImage();
    }

    private void paintLogicalTable(LogicalTable logicalTable, Graphics2D g) {
        LogicalTableState state;
        int numTabs;
        Color color = logicalTable.getBackgroundColor();
        PhysicalTable primaryTable = logicalTable.getPrimaryPhysicalTable();
        for (PhysicalTable table : logicalTable.getPhysicalTables()) {
            this.paintPhysicalTable(table, table.equals((Object)primaryTable), color, g);
        }
        if (logicalTable.hasAccount() && (numTabs = logicalTable.getBarTabs().size()) > 0) {
            Point point = primaryTable.getPosition();
            int height = g.getFontMetrics().getAscent();
            g.drawString(Integer.toString(numTabs), point.x, point.y + height);
        }
        if ((state = logicalTable.getTableState()) != null) {
            g.setColor(PRIMARY_TABLE_FONT_COLOR);
            g.setFont(STATE_FONT);
            Rectangle bounds = logicalTable.getBoundingRect();
            String text = logicalTable.getStateTimeAsString();
            Rectangle2D textBounds = g.getFontMetrics().getStringBounds(text, g);
            Image image = state.getImage();
            int xLoc = bounds.x + (int)(((double)bounds.width - textBounds.getWidth()) / 2.0);
            int yLoc = bounds.y + bounds.height + (int)textBounds.getHeight() + 2;
            if (image != null) {
                g.drawImage(image, xLoc -= image.getWidth(null) / 2, yLoc - image.getHeight(null), null);
                g.drawString(text, xLoc + 2 + image.getWidth(null), yLoc - 2);
            } else {
                g.drawString(text, xLoc, yLoc - 2);
            }
        }
    }

    private void paintLink(PhysicalTable fromTable, PhysicalTable toTable, Graphics2D g2) {
        int fromX = fromTable.getX() + fromTable.getTableImageWidth() / 2;
        int fromY = fromTable.getY() + fromTable.getTableImageHeight() / 2;
        int toX = toTable.getX() + toTable.getTableImageWidth() / 2;
        int toY = toTable.getY() + toTable.getTableImageHeight() / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintOuterLine = true;
        if (this.paintOuterLine) {
            g2.setStroke(this.linkOuterStroke);
            g2.setColor(Color.DARK_GRAY);
            g2.drawLine(fromX, fromY, toX, toY);
            g2.drawRoundRect(fromTable.getX() - 2, fromTable.getY() - 2, fromTable.getTableImageWidth() + 3, fromTable.getTableImageHeight() + 3, 6, 6);
            g2.drawRoundRect(toTable.getX() - 2, toTable.getY() - 2, toTable.getTableImageWidth() + 3, toTable.getTableImageHeight() + 3, 6, 6);
        }
        g2.setColor(this.linkColour);
        g2.setStroke(this.linkStroke);
        g2.drawLine(fromX, fromY, toX, toY);
        g2.drawRoundRect(fromTable.getX() - 1, fromTable.getY() - 1, fromTable.getTableImageWidth() + 1, fromTable.getTableImageHeight() + 1, 4, 4);
        g2.drawRoundRect(toTable.getX() - 1, toTable.getY() - 1, toTable.getTableImageWidth() + 1, toTable.getTableImageHeight() + 1, 4, 4);
        g2.setStroke(this.basicStroke);
    }

    private void paintReservations(LogicalTable logTable, Graphics2D g) {
        for (PhysicalTable table : logTable.getPhysicalTables()) {
            ReservationHeader reservationHeader = this.reservations.get(table);
            if (reservationHeader == null || StringUtils.isEmpty((String)reservationHeader.getTime())) continue;
            int tableWidth = table.getTableImageWidth();
            g.setFont(RESERVATION_FONT);
            Image image = IconLoader.get((String)"/waitermate/images/reserved.png").getImage();
            int halfwit = (tableWidth - image.getWidth(null)) / 2;
            int xLoc = table.getX() + halfwit;
            int yLoc = table.getY() - image.getHeight(null) / 2 - 2;
            g.drawImage(image, xLoc, yLoc, null);
            FontMetrics metrics = g.getFontMetrics();
            yLoc = yLoc + image.getHeight(null) + metrics.getAscent() - 1;
            xLoc = table.getX() + (tableWidth - metrics.charsWidth(reservationHeader.getTime().toCharArray(), 0, reservationHeader.getTime().length())) / 2;
            g.drawString(reservationHeader.getTime(), xLoc, yLoc);
            g.setFont(PRIMARY_TABLE_FONT);
        }
    }

    private void paintPhysicalTable(PhysicalTable table, boolean isPrimary, Color color, Graphics2D g) {
        int tableWidth = table.getTableImageWidth();
        int tableHeight = table.getTableImageHeight();
        g.drawImage(this.getTableImage(table), table.getX(), table.getY(), null);
        Composite prevComp = g.getComposite();
        if (!this.isInterfaceLocked() && color != null) {
            g.setComposite(this.colourComp);
            g.setColor(color);
            g.fillRect(table.getX(), table.getY(), tableWidth, tableHeight);
            g.setComposite(prevComp);
        }
        if (table.isCanOrderTo()) {
            String tableName = table.getName();
            int strWidth = g.getFontMetrics().stringWidth(tableName);
            int strHeight = g.getFontMetrics().getAscent();
            int strX = table.getX() + tableWidth / 2 - strWidth / 2;
            int strY = table.getY() + tableHeight / 2 + strHeight / 2;
            if (isPrimary) {
                g.setComposite(this.halfComposite);
                g.setColor(TEXT_BACKGROUND_COLOR);
                g.fillRect(strX - 5, strY - strHeight - 5, strWidth + 10, strHeight + 10);
                g.setComposite(prevComp);
                g.setFont(PRIMARY_TABLE_FONT);
                g.setColor(PRIMARY_TABLE_FONT_COLOR);
            } else {
                g.setFont(CHILD_TABLE_FONT);
                g.setColor(CHILD_TABLE_FONT_COLOR);
            }
            if (this.isInterfaceLocked()) {
                g.setColor(Color.gray);
            }
            g.drawString(tableName, strX, strY);
        }
    }

    private void paintGrid(Graphics2D g) {
        g.setColor(Color.LIGHT_GRAY);
        int lineWidth = Math.min(this.getWidth(), this.getBackgroundWidth() - 1);
        int lineHeight = Math.min(this.getHeight(), this.getBackgroundHeight() - 1);
        int numLinesX = lineWidth / 24;
        int numLinesY = lineHeight / 24;
        for (int y = 1; y <= numLinesY; ++y) {
            g.drawLine(0, y * 24, lineWidth, y * 24);
        }
        for (int x = 1; x <= numLinesX; ++x) {
            g.drawLine(x * 24, 0, x * 24, lineHeight);
        }
        g.drawLine(0, 0, lineWidth, 0);
        g.drawLine(lineWidth, 0, lineWidth, lineHeight);
        g.drawLine(lineWidth, lineHeight, 0, lineHeight);
        g.drawLine(0, lineHeight, 0, 0);
    }

    protected void paintFadeRect(Graphics2D g) {
        Composite prevComp = g.getComposite();
        AlphaComposite newComp = AlphaComposite.getInstance(3, 0.4f);
        g.setComposite(newComp);
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setComposite(prevComp);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintComponent(g, true);
    }

    protected void paintComponent(Graphics g, boolean allowDrawFadeRect) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        if (this.tableGroup != null) {
            try {
                if (this.getBackgroundImage() != null) {
                    Composite original = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
                    g2.drawImage(this.getBackgroundImage(), 0, 0, this);
                    g2.setComposite(original);
                }
                if (this.displayGrid) {
                    this.paintGrid(g2);
                }
                if (GTL.Linked.equals((Object)this.gtl)) {
                    if (this.colourWheel == null) {
                        this.colourWheel = new ColourWheel(50, Terminal.getLocalHost().getPalette());
                    }
                    List tables = this.tableGroup.getTables();
                    for (int i = 0; i < tables.size(); ++i) {
                        LogicalTable logicalTable = (LogicalTable)tables.get(i);
                        try {
                            PhysicalTable primaryTable;
                            PhysicalTable lastTable = primaryTable = logicalTable.getPrimaryPhysicalTable();
                            for (PhysicalTable table : logicalTable.getPhysicalTables()) {
                                if (logicalTable.getNumberOfTables() <= 1) continue;
                                this.linkColour = this.colourWheel.getColour(i);
                                this.paintLink(lastTable, table, g2);
                                lastTable = table;
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            WaiterMate.LOG.warn("Could not paint link : " + logicalTable + " attempting to continue", (Throwable)ex);
                        }
                    }
                }
                for (LogicalTable table : this.tableGroup.getTables()) {
                    try {
                        this.paintLogicalTable(table, g2);
                        this.paintReservations(table, g2);
                    }
                    catch (Exception ex) {
                        WaiterMate.LOG.warn("Could not paint table : " + table + " attempting to continue", (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                WaiterMate.LOG.warn("Could not paint section : " + this.tableGroup + " attempting to continue", (Throwable)ex);
            }
        }
        if (allowDrawFadeRect && this.isInterfaceLocked()) {
            this.paintFadeRect(g2);
        }
    }

    public void terminalChanged() {
        this.gtl = Terminal.getLocalHost().getGtl();
        this.colourWheel = null;
    }
}

