/*
 * Decompiled with CFR 0.152.
 */
package waitermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.guicore.task.AbstractTask;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.Terminal;
import ordermate.database.stock.StockUtilities;
import ordermate.gui.LaFManager;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaiterMateFrame;
import waitermate.gui.WaiterMateScreenResourceMenu;
import waitermate.gui.screens.admin.Admin;
import waitermate.gui.screens.admin.clockonclockoff.ClockOnClockOffScreen;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.gui.screens.login.Login;
import waitermate.gui.screens.ordering.Ordering;
import waitermate.gui.screens.ordering.WaiterMateStockUtilsGui;
import waitermate.gui.screens.payment.Payments;
import waitermate.gui.screens.reservations.Reservations;
import waitermate.gui.screens.selectaccount.SelectAccount;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.ScreenResourceMenu;

public class ConstructGuiTask
extends AbstractTask {
    private Login loginState;
    private WaiterMateFrame waiterMateGui;
    private SelectAccount selectAccountState;
    private Admin adminState;
    private Ordering orderingState;
    private Reservations reservationState;

    public final int getTotalSubTasks() {
        return 10;
    }

    public final String getName() {
        return "Constructing Screens";
    }

    public Login getLoginState() {
        return this.loginState;
    }

    protected final void performTask() throws Exception {
        new LaFManager().configureLaF(Terminal.getLocalHost());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractScreen.updateComponentTreeUIs();
            }
        });
        OrderMateThemeI.Helper.setTheme((OrderMateThemeI)new OrderMateTheme());
        if (Config.getBooleanValue((String)"debug")) {
            NameDecorator.setShowToolTip((boolean)true);
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConstructGuiTask.this.waiterMateGui = new WaiterMateFrame();
                ScreenResource.setMainPanelLayout((LayoutManager)new GraphPaperLayout(WaiterMateFrame.LAYOUT_DIMENSIONS));
                ScreenResource.setTargetFrame((JFrame)ConstructGuiTask.this.waiterMateGui, null, null);
                ScreenResource.setMenu((ScreenResourceMenu)new WaiterMateScreenResourceMenu());
                WaiterMate.LOG.info("Constructing waitermate frame");
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConstructGuiTask.this.loginState = new Login();
                WaiterMate.LOG.info("Constructed login screen");
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConstructGuiTask.this.adminState = new Admin();
                WaiterMate.LOG.info("Constructed admin screen");
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConstructGuiTask.this.orderingState = Ordering.getInstance();
                WaiterMate.LOG.info("Constructed ordering screens");
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConstructGuiTask.this.reservationState = new Reservations();
                WaiterMate.LOG.info("Constructed reservations screens");
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConstructGuiTask.this.selectAccountState = new SelectAccount();
                WaiterMate.LOG.info("Constructed select account screen");
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SelectCustomer.setupPanels();
                WaiterMate.LOG.info("Constructed Customer Search");
            }
        });
        this.loginState.validLogin.connect((Object)this.selectAccountState, "startSelectAccount");
        this.selectAccountState.back.connect((Object)LoginManager.getInstance(), "logout");
        this.selectAccountState.back.connect((Object)this.loginState, "display");
        this.selectAccountState.admin.connect((Object)this.adminState, "startAdmin");
        this.selectAccountState.reservations.connect((Object)this.reservationState, "start");
        this.selectAccountState.accountSelected.connect((Object)this.orderingState, "startAccountOrdering");
        this.selectAccountState.accountsSelected.connect((Object)this.orderingState, "startMultiAccountOrdering");
        if (!WaiterMateInputAdapter.getInstance().customerCardInput.isConnected((Object)this.orderingState)) {
            WaiterMateInputAdapter.getInstance().customerCardInput.connect((Object)this.orderingState, "gotCustomerCard");
        }
        this.selectAccountState.gotNewOnlineOrders.connect((Object)this.loginState, "gotNewOnlineOrders");
        this.adminState.back.connect((Object)this.selectAccountState, "startSelectAccount");
        this.adminState.logout.connect((Object)LoginManager.getInstance(), "logout");
        this.adminState.logout.connect((Object)this.loginState, "display");
        this.orderingState.done.connect((Object)this.selectAccountState, "startSelectAccount");
        this.orderingState.logout.connect((Object)this.loginState, "display");
        if (!this.orderingState.logout.isConnected((Object)LoginManager.getInstance())) {
            this.orderingState.logout.connect((Object)LoginManager.getInstance(), "logout");
        }
        this.reservationState.reservationsStopped.connect((Object)this.selectAccountState, "startSelectAccount");
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StockUtilities.initGui((StockUtilities.StockUtilitiesGui)new WaiterMateStockUtilsGui());
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Payments.getInstance();
                WaiterMate.LOG.info("Constructed payment screen");
            }
        });
        this.emitProgress();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ClockOnClockOffScreen.getInstance();
            }
        });
    }

    public static void reconstructGui() throws Exception {
        ScreenResource.disposeTarget();
        ConstructGuiTask task = new ConstructGuiTask();
        task.runLocal();
        ScreenResource.getTarget().setVisible(true);
        task.getLoginState().display();
    }
}

