/*
 * Decompiled with CFR 0.152.
 */
package waitermate.startup;

import au.com.ordermate.util.TimerTaskFactory;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.AsynchronousEventLogWriter;
import ordermate.database.misc.EventLogWriterI;
import ordermate.database.misc.TerminalEventLog;
import ordermate.serverconnection.ServerConnectionManager;
import ordermate.startup.AbstractSetupTerminalTask;
import waitermate.LoginManager;
import waitermate.WaiterMateUpdater;
import waitermate.failover.WaitermateFailover;

public class SetupWaiterMateTerminalTask
extends AbstractSetupTerminalTask {
    public SetupWaiterMateTerminalTask() {
        super("WaiterMate");
        TerminalEventLog.initInstance((EventLogWriterI)new AsynchronousEventLogWriter());
    }

    protected void performTask() throws Exception {
        super.performTask();
        Terminal me = Terminal.getLocalHost();
        Terminal server = Terminal.getServerMateTerminal();
        if (me.getShift() == null || server.getShift() != null && server.getShift().getTradingDay().getID() > me.getShift().getTradingDay().getID()) {
            OrderMate.LOG.warn("Changing shift from " + me.getShift() + " to " + server.getShift());
            me.changeShift(server.getShift());
            me.save();
        }
        LoginManager.initializeInstance(new TimerTaskFactory(){

            public TimerTask createTimerTask() {
                return new TimerTask(){

                    @Override
                    public void run() {
                        if (LoginManager.getInstance().getUser() == null) {
                            LoginManager.getInstance().setAllowLogin(false);
                            WaiterMateUpdater.getInstance().getUpdateTask().run();
                            LoginManager.getInstance().setAllowLogin(true);
                        }
                    }
                };
            }
        });
    }

    protected void setupServerMate() throws Exception {
        if (ServerConnectionManager.getInstance().isSecondaryServer()) {
            WaitermateFailover.startFailover(ServerConnectionManager.getInstance().getAddress());
        }
    }
}

