/*
 * Decompiled with CFR 0.152.
 */
package waitermate.startup.heartbeat.tasks;

import au.com.ordermate.guicore.task.AbstractTask;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.stock.StockRequsitionQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.signals.Signal;
import waitermate.LoginManager;

public class StockRequisitionCheckTask
extends AbstractTask {
    private final Signal<Boolean, ?, ?, ?, ?> stockRequisitionSignal;
    private static final int COUNT_START = 100;
    private int counter = 100;
    private Map<Long, StockRequisitionOrder> stockReqMap = new WeakHashMap<Long, StockRequisitionOrder>();
    private static final Semaphore semaphore = new Semaphore(1);

    public StockRequisitionCheckTask(Signal<Boolean, ?, ?, ?, ?> toEmit) {
        if (toEmit == null) {
            throw new IllegalArgumentException("Signal cannot be null");
        }
        this.setRunOnce(false);
        this.stockRequisitionSignal = toEmit;
    }

    public String getName() {
        return "StockRequisitionCheckTask";
    }

    protected void performTask() throws Exception {
        if (semaphore.tryAcquire()) {
            try {
                List pendingRequests = StockRequsitionQueries.getPendingRequests((StockArea)Terminal.getLocalHost().getStockArea());
                this.stockRequisitionSignal.emit((Object)(pendingRequests != null && !pendingRequests.isEmpty() ? 1 : 0));
                this.doAutoPrint(pendingRequests);
            }
            finally {
                semaphore.release();
            }
        } else {
            OrderMate.LOG.info("Stock Requisition already running, will not start another one");
        }
    }

    private void doAutoPrint(List<StockRequisitionOrder> pendingRequests) throws Exception {
        if (SystemProperty.getInstance().isAutoPrintStockReq() && pendingRequests != null) {
            for (StockRequisitionOrder order : pendingRequests) {
                if (this.stockReqMap.containsKey(order.getID()) || order.isPrinted()) continue;
                this.stockReqMap.put(order.getID(), order);
                DocketProcessor.printStockRequisitionDocket((StockRequisitionOrder)order, (List)Terminal.getLocalHost().getAvailableReceiptPrinters(), (EventContext)LoginManager.getEventContext());
            }
            --this.counter;
            if (this.counter <= 0) {
                this.counter = 100;
                this.stockReqMap.clear();
            }
        }
    }

    protected int getTotalSubTasks() {
        return 1;
    }
}

