/*
 * Decompiled with CFR 0.152.
 */
package waitermate.upsell;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.Sequenced;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.upsell.UpsellSuggestion;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.upsell.Upsell;
import waitermate.upsell.UpsellWorker;

public class UpsellManager {
    private static UpsellManager instance;
    public final Signal<Upsell, ConfigResource, ?, ?, ?> upsellSuggested;
    private List<UpsellSuggestion> possibleSuggestions;
    private Set<UpsellSuggestion> alreadySuggested;
    private EventList<Upsell> currentUpsells = new BasicEventList();
    private EventList<Upsell> sortedUpsells;
    private Account currentAccount;
    private UpsellWorker myIgor;
    private TriggerActivationContext currentContext = null;

    public static void init() {
        instance = new UpsellManager();
    }

    public static UpsellManager getInstance() {
        return instance;
    }

    private UpsellManager() {
        this.alreadySuggested = new HashSet<UpsellSuggestion>();
        this.sortedUpsells = new SortedList(this.currentUpsells, (Comparator)Sequenced.SequenceComparator.getInst());
        this.upsellSuggested = Signals.createSignal(Upsell.class, (String)"upsell", ConfigResource.class, (String)"resource");
        this.upsellSuggested.connect((Object)this, "gotUpsellSuggested");
        this.readInSuggestions();
        this.myIgor = new UpsellWorker(this.upsellSuggested, this.sortedUpsells);
        this.currentAccount = null;
    }

    void readInSuggestions() {
        this.currentUpsells.getReadWriteLock().writeLock().lock();
        this.currentUpsells.clear();
        this.currentUpsells.getReadWriteLock().writeLock().unlock();
        this.possibleSuggestions = PersistenceManager.getObjectList(UpsellSuggestion.class, (String)Query.select(UpsellSuggestion.class).active(UpsellSuggestion.class).orderBy(UpsellSuggestion.Properties.SEQUENCE, false).toString());
    }

    public void gotAccountChanged(Account hasChanged) {
        if (hasChanged == null) {
            this.myIgor.lostAccount();
            this.accountDifferent();
            return;
        }
        if (this.currentAccount == null || !this.currentAccount.equals((Object)hasChanged)) {
            this.accountDifferent();
            this.currentContext = new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)hasChanged);
        }
        this.currentAccount = hasChanged;
        this.examineUpsells();
        this.myIgor.accountChanged(hasChanged);
    }

    private void accountDifferent() {
        this.sortedUpsells.getReadWriteLock().writeLock().lock();
        this.sortedUpsells.clear();
        this.sortedUpsells.getReadWriteLock().writeLock().unlock();
        if (this.currentAccount != null) {
            this.currentAccount = null;
            this.currentContext = null;
        }
        this.alreadySuggested.clear();
    }

    private void examineUpsells() {
        Map<InventoryItem, SalesItem> orderedItems = this.determineOrderedItems();
        this.updateUpsells(orderedItems);
    }

    private Map<InventoryItem, SalesItem> determineOrderedItems() {
        HashMap<InventoryItem, SalesItem> items = new HashMap<InventoryItem, SalesItem>();
        InventoryItem invItem = null;
        for (SalesLineItem lineItem : this.currentAccount.getItems()) {
            for (SalesItem item : lineItem.getSalesItems()) {
                invItem = item.getFirstInventoryItem();
                if (invItem == null) {
                    for (SalesComponent comp : item.getComponentList()) {
                        items.put(comp.getInventoryItem(), item);
                    }
                    continue;
                }
                items.put(invItem, item);
            }
        }
        return items;
    }

    private void updateUpsells(Map<InventoryItem, SalesItem> itemSalesMap) {
        ArrayList<Upsell> newUpsells = new ArrayList<Upsell>();
        Upsell upsell = null;
        for (UpsellSuggestion suggestion : this.possibleSuggestions) {
            upsell = null;
            if (suggestion.isActive(this.currentContext)) {
                if (suggestion.getInventoryItems().isEmpty()) {
                    upsell = new Upsell(null, suggestion);
                } else {
                    for (InventoryItem item : suggestion.getInventoryItems()) {
                        if (!itemSalesMap.containsKey(item)) continue;
                        upsell = new Upsell(itemSalesMap.get(item), suggestion);
                        break;
                    }
                }
            }
            if (upsell == null) continue;
            newUpsells.add(upsell);
        }
        this.currentUpsells.getReadWriteLock().writeLock().lock();
        this.currentUpsells.clear();
        this.addPotentialUpsells(newUpsells);
        this.currentUpsells.getReadWriteLock().writeLock().unlock();
    }

    private void addPotentialUpsells(List<Upsell> upsells) {
        for (Upsell upsell : upsells) {
            if (upsell.getSuggestion().isUpgrade() && upsell.getSalesItem() != null && upsell.getSalesItem().getParentCombo() != null || this.alreadySuggested.contains(upsell.getSuggestion())) continue;
            this.currentUpsells.add((Object)upsell);
        }
    }

    public void gotUpsellSuggested(Upsell upsell) {
        UpsellSuggestion suggestion;
        if (upsell != null && (suggestion = upsell.getSuggestion()) != null && !suggestion.isRepeated()) {
            this.alreadySuggested.add(suggestion);
        }
    }

    EventList<Upsell> getSortedUpsells() {
        return this.currentUpsells;
    }
}

