/*
 * Decompiled with CFR 0.152.
 */
package waitermate.upsell;

import ca.odell.glazedlists.EventList;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.sales.Account;
import ordermate.signals.Signal;
import waitermate.upsell.Upsell;

class UpsellWorker {
    private static final long DEFAULT_TIME = 10000L;
    private long defWaitTime = 10000L;
    private Signal<Upsell, ConfigResource, ?, ?, ?> upsellSignal;
    private EventList<Upsell> upsellList;
    private Timer timer;
    private TimerTask task;
    private Upsell lastUpsell;
    private Account currentAccount;

    UpsellWorker(Signal<Upsell, ConfigResource, ?, ?, ?> yourUpsellSignal, EventList<Upsell> yourUpsellList) {
        this.upsellSignal = yourUpsellSignal;
        this.upsellList = yourUpsellList;
        this.timer = new Timer("Upsell Worker");
    }

    void setDefWaitTime(long value) {
        this.defWaitTime = value > 0L ? value : 10000L;
    }

    void examineUpsells() {
        Upsell nextUpsell = null;
        this.upsellList.getReadWriteLock().writeLock().lock();
        if (!this.upsellList.isEmpty()) {
            nextUpsell = (Upsell)this.upsellList.get(0);
            this.upsellList.remove((Object)nextUpsell);
        } else {
            nextUpsell = null;
        }
        this.upsellList.getReadWriteLock().writeLock().unlock();
        this.lastUpsell = nextUpsell;
        long time = this.defWaitTime;
        if (this.lastUpsell != null) {
            ConfigResource resource = this.lastUpsell.getResource();
            if (resource != null && resource.getMilliSeconds() != null && resource.getMilliSeconds() > 0L) {
                time = resource.getMilliSeconds();
            }
            this.upsellSignal.emit((Object)this.lastUpsell, (Object)resource);
        } else {
            this.upsellSignal.emit(null, null);
            this.currentAccount = null;
        }
        if (this.currentAccount != null) {
            this.task = new DoUpsellTask();
            this.timer.schedule(this.task, time);
        }
    }

    void lostAccount() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.lastUpsell = null;
        this.upsellSignal.emit(null, null);
        this.currentAccount = null;
    }

    void accountChanged(Account account) {
        if (account == null || !account.equals((Object)this.currentAccount)) {
            if (this.task != null) {
                this.task.cancel();
            }
            if (account != null) {
                this.currentAccount = account;
                this.examineUpsells();
            }
        }
    }

    class DoUpsellTask
    extends TimerTask {
        DoUpsellTask() {
        }

        @Override
        public void run() {
            UpsellWorker.this.examineUpsells();
        }
    }
}

