/*
 * Decompiled with CFR 0.152.
 */
package waitermate.webpayment;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.awt.Image;
import java.util.Arrays;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import waitermate.guikit.dialogs.Dialogs;

public class AbsorbWebPaymentCustomerDetailsWorker {
    public void absorb(Payable payable, WebPaymentCustomer webCustomer, EventContext context) {
        if (payable instanceof Account) {
            Account acc = (Account)payable;
            Customer customer = acc.getCustomer();
            String extCustomerID = webCustomer.getExtCustId();
            if (customer == null && extCustomerID != null) {
                customer = (Customer)PersistenceManager.getObject(Customer.class, (String)Query.select(Customer.class).equals(Customer.Properties.EXT_WEB_ID, (Object)extCustomerID).toString());
            }
            if (customer == null) {
                customer = this.createNewCustomer(webCustomer);
            }
            if (customer != null) {
                this.updateCustomer(customer, webCustomer.getImage(), extCustomerID);
                this.updateAccountCustomer(acc, customer, context);
            }
        }
    }

    private Customer createNewCustomer(WebPaymentCustomer webCustomer) {
        Customer newCustomer = new Customer();
        String fullName = webCustomer.getLabel();
        String[] split = fullName.split(" ");
        if (split.length != 2) {
            return null;
        }
        String first = split[0];
        String initial = split[1];
        newCustomer.setFirstName(first);
        newCustomer.setLastName(initial);
        newCustomer.setExtWebId(webCustomer.getExtCustId());
        newCustomer.setCategory(webCustomer.getLocation().getIntegration().getDefaultCustomerCategory());
        newCustomer.save();
        return newCustomer;
    }

    private void updateCustomer(Customer customer, ConfigSmallImage configImage, String extCustomerId) {
        if (customer.getExtWebId() == null || customer.getExtWebId().equals(extCustomerId)) {
            ConfigSmallImage image = customer.getImage();
            if (configImage != null) {
                if (image == null) {
                    image = new ConfigSmallImage(configImage);
                    image.save();
                } else if (configImage.getImage() != null) {
                    image.setImage((Image)configImage.getImage());
                    image.save();
                }
            }
            if (customer.getImage() == null || !Arrays.equals(customer.getImage().getImageData(), image.getImageData())) {
                customer.setImage(image);
            }
            if (customer.getExtWebId() == null) {
                customer.setExtWebId(extCustomerId);
            }
            customer.save();
        }
    }

    private void updateAccountCustomer(Account account, Customer customer, EventContext context) {
        Price oldTotal = account.getTotal();
        account.setCustomer(customer, context);
        if (!account.getTotal().equals((Object)oldTotal)) {
            Dialogs.displayOkDialog((String)("Changing the customer on this account has caused a price change from " + oldTotal + " to " + account.getTotal()), (String)"Price Change");
        }
    }
}

