/*
 * Decompiled with CFR 0.152.
 */
package waitermate.webpayment;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.integration.webpayment.WebPaymentCustomerComparator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.integration.paypal.remote.PayPalServiceRemoteClient;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.webpayment.WebCustomerRenderer;

public class WebPaymentSelection {
    private PopupWindow window;
    private CustomScrollPane scrolly;
    private RendererScrollPaneModel<WebPaymentCustomer> pickYourFaceModel;
    public Signal<WebPaymentCustomer, ?, ?, ?, ?> gotCustomer = Signals.createSignal(WebPaymentCustomer.class, (String)"customer");
    public Signal<?, ?, ?, ?, ?> gotDone = Signals.createSignal();
    private WebPaymentCustomerComparator comparator = new WebPaymentCustomerComparator();
    private EventList<WebPaymentCustomer> baseList = new BasicEventList();
    private SortedList<WebPaymentCustomer> list = new SortedList(this.baseList);

    public WebPaymentSelection() {
        this.setupComponents();
    }

    private void setupComponents() {
        WebCustomerRenderer renderer = new WebCustomerRenderer();
        renderer.gotCustomer.connect((Object)this, "gotCustomer");
        this.gotDone.connect((Object)this, "gotDone");
        this.pickYourFaceModel = new RendererScrollPaneModel((Renderer)renderer, 5, 4);
        this.pickYourFaceModel.setObjects(this.list);
        this.scrolly = new CustomScrollPane(this.pickYourFaceModel);
        this.scrolly.setEmptyMessage("<html><h2>There are no customers checked in.</h2></html>");
        this.window = new PopupWindow();
        this.window.setPreferredSize(new Dimension(567, 672));
        this.window.setComponent((JComponent)this.scrolly);
        this.window.getNavBar().getCancelButton().setText("Cancel");
        this.addClear();
        this.addSearchFilters(this.window.getNavBar());
        this.addRefresh();
        this.window.setOkButtonEnable(false);
        this.window.setOkButtonVisible(false);
    }

    private void addRefresh() {
        JButton refresh = new JButton(new AbstractAction("Refresh", IconLoader.get((String)"/waitermate/guikit/images/clear.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    WebPaymentSelection.this.refreshCustomerList();
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Could not refresh customer list.", (Throwable)new Exception());
                }
            }
        });
        OrderMateTheme.setupNavBarButton((AbstractButton)refresh);
        this.window.getNavBar().addLeft((Component)refresh);
    }

    private void addClear() {
        JButton clear = new JButton(new AbstractAction("Clear Sorting", IconLoader.get((String)"/waitermate/guikit/images/clear.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPaymentSelection.this.comparator.clear();
                WebPaymentSelection.this.pickYourFaceModel.setObjects((List)new SortedList(WebPaymentSelection.this.baseList, (Comparator)WebPaymentSelection.this.comparator));
                WebPaymentSelection.this.pickYourFaceModel.refresh();
            }
        });
        OrderMateTheme.setupNavBarButton((AbstractButton)clear);
        this.window.getNavBar().addRight((Component)clear);
    }

    public void start() {
        try {
            this.refreshCustomerList();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not refresh customer list.", (Throwable)new Exception());
        }
        this.window.start();
    }

    public void gotDone() {
        this.window.getNavBar().ok.emit();
    }

    private void refreshCustomerList() throws RemoteException, NotBoundException {
        PayPalServiceRemoteClient.getInstance().refresh();
        List extIds = PayPalServiceRemoteClient.getInstance().getCachedWebPaymentCustomerIds();
        if (extIds == null || extIds.isEmpty()) {
            this.list.clear();
            this.pickYourFaceModel.setObjects(this.list);
        } else {
            this.baseList = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(WebPaymentCustomer.class, (String)Query.select(WebPaymentCustomer.class).whereIn("config_integration_web_customer.ID", extIds).equals(WebPaymentCustomer.Properties.CHECKED_IN, (Object)Boolean.TRUE).toString(), null));
            this.list = new SortedList(this.baseList, (Comparator)this.comparator);
            this.pickYourFaceModel.setObjects(this.list);
        }
        this.pickYourFaceModel.refresh();
        this.scrolly.invalidate();
        this.scrolly.repaint();
        this.window.invalidate();
        this.window.repaint();
    }

    private void addSearchFilters(NavBar bar) {
        JButton sortByName = new JButton(new AbstractAction("By Name", IconLoader.get((String)"/waitermate/images/atoz_none.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPaymentSelection.this.comparator.toggleByName();
                WebPaymentSelection.this.list.setComparator((Comparator)WebPaymentSelection.this.comparator);
                try {
                    WebPaymentSelection.this.pickYourFaceModel.setObjects((List)WebPaymentSelection.this.list);
                    WebPaymentSelection.this.pickYourFaceModel.refresh();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JButton triggered = (JButton)e.getSource();
                if (WebPaymentSelection.this.comparator.getByName().getState() == null) {
                    triggered.setIcon(IconLoader.get((String)"/waitermate/images/atoz_none.png"));
                } else if (WebPaymentSelection.this.comparator.getByName().getState().booleanValue()) {
                    triggered.setIcon(IconLoader.get((String)"/waitermate/images/atoz.png"));
                } else if (!WebPaymentSelection.this.comparator.getByName().getState().booleanValue()) {
                    triggered.setIcon(IconLoader.get((String)"/waitermate/images/atoz_asc.png"));
                }
            }
        });
        JButton sortByDate = new JButton(new AbstractAction("By Date", IconLoader.get((String)"/waitermate/images/atoz_none.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPaymentSelection.this.comparator.toggleByDate();
                WebPaymentSelection.this.list.setComparator((Comparator)WebPaymentSelection.this.comparator);
                try {
                    WebPaymentSelection.this.pickYourFaceModel.setObjects((List)WebPaymentSelection.this.list);
                    WebPaymentSelection.this.pickYourFaceModel.refresh();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JButton triggered = (JButton)e.getSource();
                if (WebPaymentSelection.this.comparator.getByDate().getState() == null) {
                    triggered.setIcon(IconLoader.get((String)"/waitermate/images/atoz_none.png"));
                } else if (WebPaymentSelection.this.comparator.getByDate().getState().booleanValue()) {
                    triggered.setIcon(IconLoader.get((String)"/waitermate/images/atoz.png"));
                } else if (!WebPaymentSelection.this.comparator.getByDate().getState().booleanValue()) {
                    triggered.setIcon(IconLoader.get((String)"/waitermate/images/atoz_asc.png"));
                }
            }
        });
        OrderMateTheme.setupNavBarButton((AbstractButton)sortByName);
        OrderMateTheme.setupNavBarButton((AbstractButton)sortByDate);
        bar.addRight((Component)sortByName);
        bar.addRight((Component)sortByDate);
    }

    void gotCustomer(WebPaymentCustomer customer) {
        this.gotCustomer.emit((Object)customer);
    }
}

