/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.processing._impl;

import com.digitalpersona.onetouch.DPFPSample;
import com.digitalpersona.onetouch.processing.DPFPSampleConversion;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DPFPSampleConversionImpl
implements DPFPSampleConversion {
    public Image createImage(DPFPSample dPFPSample) {
        byte[] byArray = dPFPSample.serialize();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FD_IMAGE fD_IMAGE = new FD_IMAGE(byteBuffer);
        byte[] byArray2 = new byte[fD_IMAGE.iWidth * fD_IMAGE.iHeight];
        System.arraycopy(byArray, fD_IMAGE.uOffsetToImage, byArray2, 0, byArray2.length);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, fD_IMAGE.iWidth * fD_IMAGE.iHeight);
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nArray = new int[]{8};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
        SampleModel sampleModel = ((ColorModel)componentColorModel).createCompatibleSampleModel(fD_IMAGE.iWidth, fD_IMAGE.iHeight);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.PI, (double)fD_IMAGE.iWidth / 2.0, (double)fD_IMAGE.iHeight / 2.0);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        return affineTransformOp.filter(new BufferedImage(componentColorModel, writableRaster, false, null), null);
    }

    public byte[] convertToAnsi1381(DPFPSample dPFPSample) {
        byte[] byArray = dPFPSample.serialize();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FD_IMAGE fD_IMAGE = new FD_IMAGE(byteBuffer);
        int n = 0;
        int n2 = fD_IMAGE.iWidth * fD_IMAGE.iHeight;
        int n3 = n2 + 14;
        int n4 = n3 + 36;
        byte[] byArray2 = new byte[n4];
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        byteBuffer2.order(ByteOrder.BIG_ENDIAN);
        ANSIRecordHeader aNSIRecordHeader = new ANSIRecordHeader();
        aNSIRecordHeader.nRecordLength.high = 0;
        aNSIRecordHeader.nRecordLength.low = n4;
        aNSIRecordHeader.nCBEFFProductID = 0x33FE00 | n;
        aNSIRecordHeader.nDeviceID = (short)fD_IMAGE.DeviceId;
        aNSIRecordHeader.nImageAcquisitionLevel = 0;
        aNSIRecordHeader.nImageCount = 1;
        aNSIRecordHeader.nScaleUnits = 1;
        aNSIRecordHeader.nScanResolutionX = (short)fD_IMAGE.iXdpi;
        aNSIRecordHeader.nScanResolutionY = (short)fD_IMAGE.iYdpi;
        aNSIRecordHeader.nImageResolutionX = (short)fD_IMAGE.iXdpi;
        aNSIRecordHeader.nImageResolutionY = (short)fD_IMAGE.iYdpi;
        aNSIRecordHeader.nPixelDepth = (byte)fD_IMAGE.uBPP;
        aNSIRecordHeader.nImageCompression = 0;
        aNSIRecordHeader.nReserved = 0;
        ANSIImageHeader aNSIImageHeader = new ANSIImageHeader();
        aNSIImageHeader.nDataLength = n3;
        aNSIImageHeader.nFingerPosition = 1;
        aNSIImageHeader.nViewsCount = 1;
        aNSIImageHeader.nViewsNumber = 1;
        aNSIImageHeader.nImageQuality = (byte)-2;
        aNSIImageHeader.nImpressionType = 0;
        aNSIImageHeader.nHorizontalLineLength = (short)fD_IMAGE.iWidth;
        aNSIImageHeader.nVerticalLineLength = (short)fD_IMAGE.iHeight;
        aNSIImageHeader.nReserved = 0;
        aNSIRecordHeader.writeToBuffer(byteBuffer);
        aNSIImageHeader.writeToBuffer(byteBuffer);
        byteBuffer.put(byArray, fD_IMAGE.uOffsetToImage, n2);
        return byArray2;
    }

    private static class ANSIRecordHeader {
        public byte[] szFormatIdFIR = new byte[]{70, 73, 82, 0};
        public byte[] szVersionNumber = new byte[]{48, 49, 48, 0};
        public int48 nRecordLength = new int48();
        public int nCBEFFProductID;
        public short nDeviceID;
        public short nImageAcquisitionLevel;
        public byte nImageCount;
        public byte nScaleUnits;
        public short nScanResolutionX;
        public short nScanResolutionY;
        public short nImageResolutionX;
        public short nImageResolutionY;
        public byte nPixelDepth;
        public byte nImageCompression;
        public short nReserved;

        private ANSIRecordHeader() {
        }

        public void writeToBuffer(ByteBuffer byteBuffer) {
            byteBuffer.put(this.szFormatIdFIR);
            byteBuffer.put(this.szVersionNumber);
            this.nRecordLength.writeToBuffer(byteBuffer);
            byteBuffer.putInt(this.nCBEFFProductID);
            byteBuffer.putShort(this.nDeviceID);
            byteBuffer.putShort(this.nImageAcquisitionLevel);
            byteBuffer.put(this.nImageCount);
            byteBuffer.put(this.nScaleUnits);
            byteBuffer.putShort(this.nScanResolutionX);
            byteBuffer.putShort(this.nScanResolutionY);
            byteBuffer.putShort(this.nImageResolutionX);
            byteBuffer.putShort(this.nImageResolutionY);
            byteBuffer.put(this.nPixelDepth);
            byteBuffer.put(this.nImageCompression);
            byteBuffer.putShort(this.nReserved);
        }
    }

    private static class int48 {
        short high;
        int low;

        private int48() {
        }

        public void writeToBuffer(ByteBuffer byteBuffer) {
            byteBuffer.putShort(this.high);
            byteBuffer.putInt(this.low);
        }
    }

    private static class ANSIImageHeader {
        public int nDataLength;
        public byte nFingerPosition;
        public byte nViewsCount;
        public byte nViewsNumber;
        public byte nImageQuality;
        public byte nImpressionType;
        public short nHorizontalLineLength;
        public short nVerticalLineLength;
        public byte nReserved;

        private ANSIImageHeader() {
        }

        public void writeToBuffer(ByteBuffer byteBuffer) {
            byteBuffer.putInt(this.nDataLength);
            byteBuffer.put(this.nFingerPosition);
            byteBuffer.put(this.nViewsCount);
            byteBuffer.put(this.nViewsNumber);
            byteBuffer.put(this.nImageQuality);
            byteBuffer.put(this.nImpressionType);
            byteBuffer.putShort(this.nHorizontalLineLength);
            byteBuffer.putShort(this.nVerticalLineLength);
            byteBuffer.put(this.nReserved);
        }
    }

    private static class FD_IMAGE {
        public int uSize;
        public int uReserved1;
        public int uDataType;
        public int uReserved2;
        public long DeviceId;
        public long DeviceType;
        public int iDataAcqProgress;
        public int uReserved3;
        public int uOffsetToImage;
        public int uMajor;
        public int uMinor;
        public int uBuild;
        public int uDataType1;
        public int uImageType;
        public int iWidth;
        public int iHeight;
        public int iXdpi;
        public int iYdpi;
        public int uBPP;
        public int uPadding;
        public int uSignificantBpp;
        public int uPolarity;
        public int uRGBcolorRepresentation;
        public int uPlanes;
        public int uExtensionSize;
        public int uReserved4;

        private FD_IMAGE(ByteBuffer byteBuffer) {
            this.uSize = byteBuffer.getInt();
            this.uReserved1 = byteBuffer.getInt();
            this.uDataType = byteBuffer.getInt();
            this.uReserved2 = byteBuffer.getInt();
            this.DeviceId = byteBuffer.getLong();
            this.DeviceType = byteBuffer.getLong();
            this.iDataAcqProgress = byteBuffer.getInt();
            this.uReserved3 = byteBuffer.getInt();
            this.uOffsetToImage = byteBuffer.getInt();
            this.uMajor = byteBuffer.getInt();
            this.uMinor = byteBuffer.getInt();
            this.uBuild = byteBuffer.getInt();
            this.uDataType1 = byteBuffer.getInt();
            this.uImageType = byteBuffer.getInt();
            this.iWidth = byteBuffer.getInt();
            this.iHeight = byteBuffer.getInt();
            this.iXdpi = byteBuffer.getInt();
            this.iYdpi = byteBuffer.getInt();
            this.uBPP = byteBuffer.getInt();
            this.uPadding = byteBuffer.getInt();
            this.uSignificantBpp = byteBuffer.getInt();
            this.uPolarity = byteBuffer.getInt();
            this.uRGBcolorRepresentation = byteBuffer.getInt();
            this.uPlanes = byteBuffer.getInt();
            this.uExtensionSize = byteBuffer.getInt();
            this.uReserved4 = byteBuffer.getInt();
        }
    }
}

