/*
 * Decompiled with CFR 0.152.
 */
package officemate;

import au.com.ordermate.OMLogUtil;
import au.com.ordermate.OrderMateApplication;
import au.com.ordermate.OrderMateLog;
import au.com.ordermate.application.ApplicationComplex;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.progress.VersionSplashWindow;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.DefaultTask;
import au.com.ordermate.guicore.task.ProgressLogger;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceClientSetupTask;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.FontManagerUtil;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.security.Security;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.SynchronousQueue;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import officemate.adminkit.AdminConnectionPanel;
import officemate.adminkit.AdminObjectManager;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.screens.DefaultApplicationSecurity;
import officemate.screens.OfficeMateComplex;
import officemate.startup.LoadOfficemateDefaultsTask;
import officemate.startup.OfficeMatePreloadTask;
import officemate.startup.SetupDatabaseTask;
import officemate.startup.SetupObjectManagerTask;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.dbconnection.AbstractDatabaseConnection;
import ordermate.serverconnection.PropertiesServerCheckTask;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.CouponRemoteStartupTask;
import ordermate.startup.DeadlockLog;
import ordermate.startup.EDTDebugThreadCheckTask;
import ordermate.startup.LaFSetupTask;
import ordermate.startup.ManagerStartupTask;
import ordermate.startup.MemoryLog;
import ordermate.startup.OrderMateSetupException;
import ordermate.startup.PermissionsStartupTask;
import ordermate.startup.PriceInternationalizationTask;
import ordermate.startup.ServerConnectionSetupTask;
import ordermate.startup.SetupLoyaltyTask;
import ordermate.startup.StaticPortRangeRMIStartupTask;
import ordermate.startup.UniqueTask;
import ordermate.startup.VoucherRMIStartupTask;
import ordermate.startup.runtime.OfficemateJavaRuntimeCheckTask;
import org.apache.logging.log4j.core.Logger;

public class OfficeMate
implements OrderMateApplication {
    public static final String PRODUCT_NAME = "OfficeMate";
    public static Logger LOG;
    public static final String CONFIG_FILE = "OfficeMateConfig.ini";
    private static final int DEFAULT_MAX_INSTANCES = 10;
    private static OfficeMate instance;
    private ObjectManager manager;
    private static boolean isStartingUp;
    private static DBConnectionInterface control;

    public OfficeMate() throws InterruptedException {
        OrderMate.LOG = LOG = OMLogUtil.createRootLogger((String)PRODUCT_NAME);
        OrderMateLog.LOG = LOG;
        LOG.info("Starting OfficeMate Version: " + OrderMate.VERSION);
        RefreshAction.setDefaultIcon((Icon)IconLoader.get((String)"/ordermate/images/refresh_icon22.png"));
        try {
            Config.readConfigData((String)CONFIG_FILE);
        }
        catch (Exception ex) {
            LOG.warn("Could not read config file... trying to continue", (Throwable)ex);
        }
    }

    private void launch() throws InterruptedException {
        control = AbstractDatabaseConnection.getDBConnectionInterface();
        this.manager = new AdminObjectManager();
        final CompositeTask startup = new CompositeTask("Starting OfficeMate");
        ConfigurationTask config = new ConfigurationTask(CONFIG_FILE);
        startup.addTask((Task)config);
        startup.addTask((Task)new EDTDebugThreadCheckTask());
        startup.addTask((Task)OfficeMateAdminGuiUtils.createConfigTask());
        startup.addTask((Task)new ServerConnectionSetupTask(AdminConnectionPanel.class, null));
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>(Collections.singleton(11102));
        startup.addTask((Task)new StaticPortRangeRMIStartupTask(11102, 50, null, ports, 10));
        startup.addTask((Task)new UniqueTask(PRODUCT_NAME, System.getProperty("user.name"), ports));
        startup.addTask((Task)new ManagerStartupTask(PRODUCT_NAME));
        startup.addTask((Task)new PersistenceClientSetupTask(0));
        startup.addTask((Task)new LaFSetupTask(true));
        startup.addTask((Task)new SetupDatabaseTask(control));
        startup.addTask((Task)new PermissionsStartupTask());
        startup.addTask((Task)new SetupObjectManagerTask(this.manager));
        startup.addTask((Task)new PropertiesServerCheckTask());
        startup.addTask((Task)new ConstructGuiStateTask());
        startup.addTask((Task)new DeadlockLog("Dead lock check task"));
        startup.addTask((Task)new MemoryLog("OfficeMate Memory log check task"));
        startup.addTask((Task)new OfficemateJavaRuntimeCheckTask(PRODUCT_NAME));
        OfficeMateGuiHandler gui = new OfficeMateGuiHandler();
        startup.addTask((Task)new SetupLoyaltyTask((GuiHandler)gui));
        startup.addTask((Task)new CouponRemoteStartupTask((GuiHandler)gui));
        startup.addTask((Task)new VoucherRMIStartupTask((GuiHandler)gui));
        startup.addTask((Task)new OfficeMatePreloadTask());
        startup.addTask((Task)new LoadOfficemateDefaultsTask());
        startup.addTask((Task)new PriceInternationalizationTask());
        final SynchronousQueue splashWindowRef = new SynchronousQueue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VersionSplashWindow theSplashFrame = new VersionSplashWindow(startup.getTotalSubTasks(), OrderMate.VERSION, OfficeMate.PRODUCT_NAME);
                try {
                    splashWindowRef.put(theSplashFrame);
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Exception putting splash back into main thread");
                    return;
                }
                startup.progress.connect((Object)theSplashFrame, "setProgress");
                startup.taskStarted.connect((Object)new ProgressLogger(), "logProgress");
                startup.taskStarted.connect((Object)theSplashFrame, "setMessage");
                startup.statusMessage.connect((Object)theSplashFrame, "setMessage");
                theSplashFrame.startSplashScreen();
            }
        });
        final VersionSplashWindow theSplashFrame = (VersionSplashWindow)splashWindowRef.take();
        while (!startup.hasRun()) {
            try {
                try {
                    startup.runLocal();
                }
                catch (InvocationTargetException ie) {
                    if (ie.getCause() != null && ie.getCause() instanceof Exception) {
                        OrderMate.LOG.info("Unwrapping invocation target exception and throwing", (Throwable)ie);
                        throw ie;
                    }
                    throw ie;
                }
            }
            catch (OrderMateSetupException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                final String prompt = e.getHTMLMessage();
                if (e.isFatal()) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Dialogs.showErrorDialog("Startup Error", prompt);
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    OfficeMate.exit(-1);
                    continue;
                }
                if (!Dialogs.showWarningDialog("Startup Error", prompt)) {
                    OfficeMate.exit(-1);
                    continue;
                }
                startup.removeTask(e.getFailedTask());
            }
            catch (Exception e) {
                LOG.error("Error occurred during startup, exiting OfficeMate", (Throwable)e);
                String message = "<html>An error occurred during startup:<h2>" + e.getMessage() + "</h2>";
                Dialogs.showErrorDialog("Startup Error", message);
                OfficeMate.exit(-1);
            }
        }
        this.initializeShutDownEvents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    theSplashFrame.dispose();
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Error disposing splash screen", (Throwable)ex);
                }
            }
        });
        LOG.info("Startup complete");
        isStartingUp = false;
    }

    private void initializeShutDownEvents() {
        GuiApp.getAppComplex().getApplicationFrame().getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                try {
                    ((DefaultApplicationSecurity)GuiApp.getAppComplex().getApplicationSecurity()).doClose();
                    LOG.info("Officemate closing.");
                }
                catch (Exception ex) {
                    LOG.warn("Unable to unsubscribe remote cache on exit.", (Throwable)ex);
                }
            }
        });
    }

    public static JFrame getApplicationFrame() {
        return GuiApp.getAppComplex().getApplicationFrame().getFrame();
    }

    public EventContext getEventContext() {
        return new EventContext(Terminal.getServerMateTerminal(), GuiApp.getAppComplex().getApplicationSecurity().getUser());
    }

    public static synchronized OfficeMate getInstance() {
        return instance;
    }

    private static synchronized void setInstance(OfficeMate officemate) {
        instance = officemate;
    }

    public static boolean isStartingUp() {
        return isStartingUp;
    }

    public static void main(String[] args) {
        Security.setProperty("networkaddress.cache.ttl", "60");
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        new Thread((ThreadGroup)new ExceptionGroup(), new Runnable(){

            @Override
            public void run() {
                try {
                    OfficeMate officemate = new OfficeMate();
                    OfficeMate.setInstance(officemate);
                    GuiApp.setMainApp((OrderMateApplication)officemate);
                    officemate.launch();
                }
                catch (InterruptedException ex) {
                    OrderMate.LOG.warn("Interupted exception caught initialized officemate", (Throwable)ex);
                    return;
                }
            }
        }).start();
    }

    public static void exit(int exitCode) {
        if (GuiApp.isAppComplexSetup()) {
            ((DefaultApplicationSecurity)GuiApp.getAppComplex().getApplicationSecurity()).exit(exitCode);
        }
        System.exit(exitCode);
    }

    public void setFailoverMode(boolean isRedundant) {
    }

    static {
        isStartingUp = true;
    }

    public class ConstructGuiStateTask
    extends DefaultTask {
        public ConstructGuiStateTask() {
            super("Build application state");
        }

        protected void performTask() throws OrderMateSetupException {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OfficeMateComplex complex = new OfficeMateComplex();
                        GuiApp.setAppComplex((ApplicationComplex)complex);
                        complex.init(control, OfficeMate.this.manager);
                        FontManagerUtil.setupFonts((int)10);
                    }
                });
            }
            catch (Exception ex) {
                throw new OrderMateSetupException((Task)this, "Could not construct graphical state, cannot continue.", new String[]{SystemProperty.getInstance().getSupportMessage1()}, (Throwable)ex, true);
            }
        }
    }

    public static class ExceptionGroup
    extends ThreadGroup {
        public ExceptionGroup() {
            super("Uncaught main");
            final ExceptionGroup exceptionHandler = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setUncaughtExceptionHandler(exceptionHandler);
                }
            });
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.error("Uncaught exception in : " + t.getName(), e);
            new Timer("EDT Restart").schedule(new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("EDT Restart event");
                            if (GuiApp.isAppComplexSetup() && OfficeMate.getApplicationFrame() != null) {
                                OfficeMate.getApplicationFrame().invalidate();
                            }
                        }
                    });
                }
            }, 5000L);
        }
    }
}

