/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.util.Assert;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import officemate.adminkit.AbstractObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.fieldpanels.FieldPanel;
import ordermate.gui.FieldPanelBuilder;

public class DefaultObjectEditorPanel
extends AbstractObjectEditorPanel {
    private FieldPanel[] fieldPanels;
    private JLabel[] fieldLabels;
    private JScrollPane scroller;
    private String[] fieldsToEdit;
    private boolean init = false;

    public DefaultObjectEditorPanel() {
    }

    public DefaultObjectEditorPanel(String[] newFieldsToEdit) {
        this.fieldsToEdit = newFieldsToEdit;
    }

    @Override
    public void initComponents() {
        ObjectTemplate objTemplate = this.getTemplate();
        int numFields = objTemplate.getNumFields();
        this.fieldPanels = new FieldPanel[numFields];
        this.fieldLabels = new JLabel[numFields];
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        Iterator<String> fields = objTemplate.getFields().iterator();
        int i = 0;
        while (fields.hasNext()) {
            Assert.isTrue((i < numFields ? 1 : 0) != 0, (String)("There are more template fields than expected: " + i + " (expected " + numFields + ")"));
            String fieldName = fields.next();
            if (!objTemplate.isFieldReadOnly(fieldName)) {
                boolean fieldListed = false;
                if (this.fieldsToEdit == null || this.fieldsToEdit.length == 0) {
                    fieldListed = true;
                } else {
                    for (int j = 0; j < this.fieldsToEdit.length; ++j) {
                        if (!this.fieldsToEdit[j].equals(fieldName)) continue;
                        fieldListed = true;
                        break;
                    }
                }
                String separatorTitle = objTemplate.getSeparator(fieldName);
                if (separatorTitle != null) {
                    builder.addSeparator(separatorTitle);
                }
                if (fieldListed) {
                    this.fieldLabels[i] = new JLabel(fieldName);
                    String instructionsText = objTemplate.getInstructions(fieldName);
                    this.fieldLabels[i].setToolTipText(instructionsText);
                    this.fieldPanels[i] = this.getFieldPanel(fieldName);
                    this.fieldLabels[i].setLabelFor(this.fieldPanels[i].getPrimaryComponent());
                    builder.addRow(this.fieldLabels[i], (Component)this.fieldPanels[i]);
                }
            }
            ++i;
        }
        this.scroller = new JScrollPane(builder.getPanel(), 20, 31);
        this.scroller.getVerticalScrollBar().setUnitIncrement(16);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.scroller, "East");
        this.revalidate();
        this.repaint();
        this.init = true;
    }

    @Override
    public void gotFocusGained(FieldPanel panel) {
        this.doCheckInit();
        super.gotFocusGained(panel);
        int index = this.getPanelIndex(panel);
        JScrollBar vertScrollBar = this.scroller.getVerticalScrollBar();
        if (vertScrollBar != null) {
            int totalOffset = 0;
            for (int i = 0; i < index; ++i) {
                if (this.fieldPanels[i] == null) continue;
                totalOffset += this.fieldPanels[i].getHeight();
            }
            int minVisibleY = vertScrollBar.getValue();
            int maxVisibleY = minVisibleY + this.scroller.getHeight();
            int minFieldY = totalOffset;
            int maxFieldY = minFieldY + panel.getHeight();
            int LEEWAY = 20;
            if (minFieldY < minVisibleY + 20 || minFieldY > maxVisibleY - 20 || maxFieldY < minVisibleY + 20 || minFieldY > maxVisibleY - 20) {
                vertScrollBar.setValue(totalOffset - 20);
            }
        }
        this.repaint();
    }

    private int getPanelIndex(FieldPanel p) {
        Assert.isTrue((this.fieldPanels.length > 0 ? 1 : 0) != 0, (String)"No field panels in array");
        for (int i = 0; i < this.fieldPanels.length; ++i) {
            if (p != this.fieldPanels[i]) continue;
            return i;
        }
        return -1;
    }

    public JLabel getFieldLabel(String fieldName) {
        Assert.isTrue((this.fieldLabels.length > 0 ? 1 : 0) != 0, (String)"Labels have not been initialized");
        for (int i = 0; i < this.fieldLabels.length; ++i) {
            if (this.fieldLabels[i] == null || !this.fieldLabels[i].getText().equals(fieldName)) continue;
            return this.fieldLabels[i];
        }
        return null;
    }

    public FieldPanel[] getFieldPanels() {
        Assert.isTrue((this.fieldPanels != null ? 1 : 0) != 0, (String)"attempting to return uninitialized fieldPanels");
        return this.fieldPanels;
    }

    private void doCheckInit() {
        Assert.isTrue((boolean)this.init, (String)"Must call initializeComponents() before using the panel");
    }

    public FieldPanel getFieldPanelForLabel(String panelLabel) {
        for (int i = 0; i < this.fieldLabels.length; ++i) {
            if (this.fieldLabels[i] == null || !this.fieldLabels[i].getText().equals(panelLabel)) continue;
            return this.fieldPanels[i];
        }
        return null;
    }
}

