/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.Assert;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import ordermate.gui.AutoCompletion;

public class DefaultObjectSelectorPanel
extends ObjectSelectorPanel {
    private static final String NONE = "<none>";
    private boolean init = false;
    private ObjectFilter filter = null;
    private ObjectTemplate objTemplate;
    private JComboBox combo;
    private DefaultComboBoxModel model;
    private boolean allowNull;
    private boolean changing = false;

    @Override
    public void init(ObjectTemplate objTempl, boolean allowsNull) {
        Assert.isTrue((!this.init ? 1 : 0) != 0, (String)"ObjectSelectorPanel has already been initialised, cannot run init()");
        this.allowNull = allowsNull;
        this.init = true;
        this.objTemplate = objTempl;
        this.updateView();
    }

    @Override
    public void updateView() {
        if (this.combo == null) {
            this.model = new DefaultComboBoxModel();
            this.combo = new JComboBox(this.model);
            AutoCompletion.enable((JComboBox)this.combo);
            ComponentUtils.setupComboBox((JComboBox)this.combo);
            this.combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DefaultObjectSelectorPanel.this.changing && e.getStateChange() == 1) {
                        Object selObject = DefaultObjectSelectorPanel.this.getSelectedObject();
                        if (!DefaultObjectSelectorPanel.this.objTemplate.objectBelongs(selObject)) {
                            selObject = null;
                        }
                        DefaultObjectSelectorPanel.this.objectSelected.emit(selObject, (Object)DefaultObjectSelectorPanel.this);
                    }
                }
            });
            this.add(this.combo);
        }
        this.changing = true;
        this.model.removeAllElements();
        List objects = this.objTemplate.getManager().getObjectList(this.objTemplate.getObjectJavaClass());
        if (this.allowNull) {
            this.model.addElement(NONE);
        }
        for (int i = 0; i < objects.size(); ++i) {
            Object element = objects.get(i);
            if (this.filter != null && !this.filter.accept(element)) continue;
            this.model.addElement(element);
        }
        this.combo.setModel(this.model);
        this.changing = false;
    }

    public JComboBox getComboBox() {
        return this.combo;
    }

    @Override
    public Object getSelectedObject() {
        Object selection = this.combo.getSelectedItem();
        return NONE.equals(selection) ? null : selection;
    }

    @Override
    public Class getExpectedJavaClass() {
        return this.objTemplate.getObjectJavaClass();
    }

    @Override
    public boolean setSelectedObject(Object toSelect) {
        if (toSelect == null) {
            if (this.allowNull) {
                this.combo.setSelectedItem(NONE);
            } else if (this.combo.getItemCount() > 0) {
                this.combo.setSelectedIndex(0);
            }
            return true;
        }
        Object currObject = this.combo.getSelectedItem();
        this.combo.setSelectedItem(toSelect);
        Object newCurrObject = this.combo.getSelectedItem();
        if (!newCurrObject.equals(currObject)) {
            this.objectSelected.emit(toSelect, (Object)this);
        }
        return true;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.combo.setEnabled(b);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.combo.setToolTipText(text);
    }

    public ObjectFilter getObjectFilter() {
        return this.filter;
    }

    public void setObjectFilter(ObjectFilter f) {
        this.filter = f;
        this.updateView();
    }

    @Override
    public JComponent getPrimaryComponent() {
        return (JComponent)this.combo.getEditor().getEditorComponent();
    }
}

