/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.image.IconLoader;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeCellRenderer;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.tree.DefaultObjectTree;
import officemate.adminkit.tree.DefaultObjectTreeModel;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.users.PermissionGroup;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class MenuGroupTreePanel
extends JPanel {
    public final Signal<Object, ?, ?, ?, ?> objectSelected = Signals.createSignal(Object.class, (String)"selectedObj");
    protected DefaultObjectTree tree;
    protected ObjectTemplate menuGroupTemplate;
    private ObjectManager manager;
    private boolean modifiableOnly = false;

    public MenuGroupTreePanel(ObjectManager theManager, InventoryProfile profile) {
        super(new GridLayout(1, 1));
        this.manager = theManager;
        this.menuGroupTemplate = this.manager.getTemplate(InventoryGroup.class);
        this.tree = new DefaultObjectTree(new ArrayList(), this.menuGroupTemplate, (ObjectFilter)null);
        this.tree.setName("menuGroup");
        OfficeMateAdminGuiUtils.getInstance().standardTreeSetup(this.tree);
        this.tree.setSelectionRow(0);
        this.tree.objectSelected.connect((Object)this, "gotObjectSelected");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(IconLoader.get((String)"/ordermate/images/group_blue.png"));
        renderer.setOpenIcon(IconLoader.get((String)"/ordermate/images/blue_folder.png"));
        renderer.setClosedIcon(IconLoader.get((String)"/ordermate/images/blue_folder.png"));
        this.tree.setCellRenderer(renderer);
        this.add(new JScrollPane(this.tree, 20, 30));
    }

    public void setModifiableOnly(boolean value) {
        this.modifiableOnly = value;
    }

    public void setMenuProfile(InventoryProfile profile) {
        if (this.modifiableOnly) {
            PermissionGroup clearance = GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionGroup();
            this.tree.setModel(new DefaultObjectTreeModel(profile.getModifiableProfileGroupsWithoutDuplicates(clearance), this.menuGroupTemplate));
        } else {
            this.tree.setModel(new DefaultObjectTreeModel(InventoryProfile.getProfileGroups((InventoryProfile)profile), this.menuGroupTemplate));
        }
        this.revalidate();
        this.repaint();
    }

    public ObjectManager getManager() {
        return this.manager;
    }

    public void gotObjectSelected(Object o) {
        this.objectSelected.emit(o);
    }

    public DefaultObjectTree getTree() {
        return this.tree;
    }

    public Object getSelectedObject() {
        return this.tree.getSelectedObject();
    }

    public ObjectFilter getObjectFilter() {
        return this.tree.getObjectFilter();
    }

    public void setObjectFilter(ObjectFilter filter) {
        this.tree.setObjectFilter(filter);
    }
}

