/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import officemate.adminkit.ObjectTemplate;
import ordermate.database.misc.ObjectChange;

public class ObjectChangeRecorder {
    private List<String> compareFields;
    private ObjectTemplate template;
    private Hashtable snapshot;

    public ObjectChangeRecorder(ObjectTemplate objTemplate, String[] fields) {
        this.compareFields = fields == null ? objTemplate.getWritableFields() : Arrays.asList(fields);
        this.template = objTemplate;
    }

    public ObjectChangeRecorder(ObjectTemplate objTemplate) {
        this(objTemplate, null);
    }

    public void snapshot(Object obj) {
        if (!this.template.objectBelongs(obj)) {
            String objClass = obj == null ? "" : "(" + obj.getClass().getName() + ")";
            throw new IllegalArgumentException("Cannot take snapshot: unexpected type for object \"" + obj + "\" " + objClass + " expected " + this.template.getObjectJavaClass().getName());
        }
        this.snapshot = new Hashtable();
        for (int i = 0; i < this.compareFields.size(); ++i) {
            String field = this.compareFields.get(i);
            Object value = this.template.getObjectProperty(obj, field);
            this.snapshot.put(field, this.getStringValueOf(value));
        }
    }

    private String getStringValueOf(Object obj) {
        return String.valueOf(obj);
    }

    public List<ObjectChange> getChanges(Object obj) {
        ArrayList<ObjectChange> changes = new ArrayList<ObjectChange>();
        if (this.snapshot != null) {
            for (int i = 0; i < this.compareFields.size(); ++i) {
                String field = this.compareFields.get(i);
                String currentValue = this.getStringValueOf(this.template.getObjectProperty(obj, field));
                String snapshotValue = (String)this.snapshot.get(field);
                if (snapshotValue.equals(currentValue)) continue;
                changes.add(new ObjectChange(field, (Object)snapshotValue, (Object)currentValue));
            }
        }
        return changes;
    }
}

