/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.reflect.PropertyUtils;
import au.com.ordermate.util.Price;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.DefaultObjectSelectorPanel;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.SingleObjectSelectorPanel;
import officemate.adminkit.filters.AcceptAllFilter;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.types.BoolFieldType;
import officemate.adminkit.types.DateFieldType;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.IntFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.adminkit.types.TimeFieldType;
import ordermate.OrderMate;

public class ObjectTemplate {
    private List<Exception> exceptionLog = new ArrayList<Exception>();
    private ObjectManager manager;
    private String name;
    private Hashtable<String, FieldType> fieldMap;
    private List<String> fieldsInOrder;
    private Set<String> readOnlyFields;
    private Properties propMap;
    private Properties instructionMap;
    private Map<String, String> separators;
    private Class editPanelClass;
    private Class selectPanelClass;
    private Class javaClass;
    private String childProperty = null;
    private String textProp = null;

    public ObjectTemplate(String templateName, Class busClass) {
        this.name = templateName;
        this.javaClass = busClass;
        this.fieldsInOrder = new Vector<String>();
        this.fieldMap = new Hashtable();
        this.propMap = new Properties();
        this.instructionMap = new Properties();
        this.readOnlyFields = new LinkedHashSet<String>();
        this.separators = new HashMap<String, String>();
    }

    public ObjectManager getManager() {
        return this.manager;
    }

    public void setManager(ObjectManager m) {
        this.manager = m;
    }

    public Object createNewObject() {
        ReflectiveOperationException thrownError = null;
        Object newObject = null;
        try {
            newObject = this.javaClass.newInstance();
        }
        catch (InstantiationException ie) {
            thrownError = ie;
        }
        catch (IllegalAccessException ie) {
            thrownError = ie;
        }
        if (thrownError != null) {
            this.exceptionLog.add(thrownError);
            OrderMateLog.LOG.error("Creation of business object failed", (Throwable)thrownError);
            return null;
        }
        return newObject;
    }

    public boolean objectBelongs(Object obj) {
        if (obj != null) {
            return this.getObjectJavaClass().isAssignableFrom(obj.getClass());
        }
        return false;
    }

    public String getChildProperty() {
        return this.childProperty;
    }

    public String getName() {
        return this.name;
    }

    public void setChildProperty(String childProp) {
        this.childProperty = childProp;
    }

    public List getObjectChildren(Object obj) {
        return this.getObjectChildren(obj, new AcceptAllFilter());
    }

    public List getObjectChildren(Object obj, ObjectFilter filter) {
        List children = new ArrayList();
        if (this.childProperty != null) {
            try {
                List childList = (List)PropertyUtils.getProperty((Object)obj, (String)this.childProperty);
                if (filter == null) {
                    children = childList;
                } else {
                    children = new ArrayList();
                    for (Object child : childList) {
                        if (!filter.accept(child)) continue;
                        children.add(child);
                    }
                }
            }
            catch (Exception e) {
                this.exceptionLog.add(e);
                OrderMateLog.LOG.error("Error while getting object children", (Throwable)e);
            }
        }
        return Collections.unmodifiableList(children);
    }

    public boolean objectHasChildren(Object obj) {
        return this.getObjectChildren(obj).size() > 0;
    }

    public String getObjectText(Object obj) {
        if (this.textProp != null) {
            try {
                return (String)PropertyUtils.getProperty((Object)obj, (String)this.textProp);
            }
            catch (Exception e) {
                this.exceptionLog.add(e);
                OrderMateLog.LOG.error("Error getting object text", (Throwable)e);
                return null;
            }
        }
        return obj.toString();
    }

    public void setObjectTextProp(PropertiedObject.Property property) {
        this.setObjectTextProp(property.getName());
    }

    public void setObjectTextProp(String property) {
        this.textProp = property;
    }

    public String getObjectTextProp() {
        return this.textProp;
    }

    public boolean isTree() {
        return this.childProperty != null;
    }

    public Class getObjectJavaClass() {
        return this.javaClass;
    }

    public boolean hasField(String fieldName) {
        return this.fieldMap.containsKey(fieldName);
    }

    public Class getEditPanelClass() {
        return this.editPanelClass;
    }

    public Class getSelectPanelClass() {
        return this.selectPanelClass;
    }

    public void setEditPanelClass(Class cls) {
        this.editPanelClass = cls;
    }

    public void setSelectPanelClass(Class cls) {
        this.selectPanelClass = cls;
    }

    public void setSelectPanelClass(String clsName) {
        try {
            this.selectPanelClass = Class.forName(clsName);
        }
        catch (ClassNotFoundException e) {
            this.exceptionLog.add(e);
            OrderMate.LOG.warn(this.getName() + " select panel class \"" + clsName + "\" not available, using default ", (Throwable)e);
        }
    }

    public ObjectEditorPanel getNewEditPanel(Object editObject) {
        ObjectEditorPanel retval = null;
        if (this.editPanelClass == null) {
            retval = new DefaultObjectEditorPanel();
        } else {
            try {
                retval = (ObjectEditorPanel)this.editPanelClass.newInstance();
            }
            catch (Exception thrownError) {
                this.exceptionLog.add(thrownError);
                OrderMateLog.LOG.error("Can't instantiate editor panel!", (Throwable)thrownError);
                return null;
            }
        }
        if (retval != null) {
            retval.init(this.manager, this, editObject);
        }
        return retval;
    }

    public ObjectSelectorPanel getNewSelectPanel(boolean allowsNull, boolean singleObject) {
        ObjectSelectorPanel retval = null;
        if (this.selectPanelClass == null) {
            retval = singleObject ? new SingleObjectSelectorPanel() : new DefaultObjectSelectorPanel();
        } else {
            ReflectiveOperationException thrownError = null;
            try {
                retval = (ObjectSelectorPanel)this.selectPanelClass.newInstance();
            }
            catch (InstantiationException e) {
                thrownError = e;
            }
            catch (IllegalAccessException e) {
                thrownError = e;
            }
            if (thrownError != null) {
                this.exceptionLog.add(thrownError);
                OrderMateLog.LOG.error("Can't instantiate DefaultObjectSelector panel!", (Throwable)thrownError);
                return null;
            }
        }
        if (retval != null) {
            retval.init(this, allowsNull);
        }
        return retval;
    }

    public void addEntry(PropertiedObject.Property property, String instructions) {
        FieldType type = this.getFieldType(property.getType());
        this.addEntry(property, type, instructions);
    }

    public void addEntry(String entryName, PropertiedObject.Property property, String instructions) {
        FieldType type = this.getFieldType(property.getType());
        this.addEntry(entryName, type, property.getName(), instructions);
    }

    public FieldType getFieldType(Class clazz) {
        FieldType type;
        if (clazz.equals(String.class)) {
            type = new StringFieldType();
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            type = new IntFieldType();
        } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            type = new DoubleFieldType();
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            type = new BoolFieldType();
        } else if (clazz.equals(Price.class)) {
            type = new PriceFieldType();
        } else if (clazz.equals(Date.class)) {
            type = new DateFieldType();
        } else if (clazz.equals(Time.class)) {
            type = new TimeFieldType();
        } else {
            throw new IllegalArgumentException("Cannot determine FieldType for class " + clazz);
        }
        return type;
    }

    public void addEntry(PropertiedObject.Property property, FieldType type, String instructions) {
        this.addEntry(property.getUserVisibleLabel(), type, property.getName(), instructions);
    }

    public void addEntry(String entryName, FieldType type, String beanName) {
        this.fieldMap.put(entryName, type);
        this.propMap.put(entryName, beanName);
        if (!this.fieldsInOrder.contains(entryName)) {
            this.fieldsInOrder.add(entryName);
        }
    }

    public void addEntry(String entryName, FieldType type, String beanName, String instructions) {
        this.addEntry(entryName, type, beanName, instructions, false);
    }

    public void addReadOnlyEntry(String entryName, FieldType type, String beanName, String instructions) {
        this.addEntry(entryName, type, beanName, instructions, true);
    }

    private void addEntry(String entryName, FieldType type, String beanName, String instructions, boolean readOnly) {
        if (readOnly) {
            this.readOnlyFields.add(entryName);
        }
        this.fieldMap.put(entryName, type);
        this.propMap.put(entryName, beanName);
        this.setInstructions(entryName, instructions);
        if (!this.fieldsInOrder.contains(entryName)) {
            this.fieldsInOrder.add(entryName);
        }
    }

    public boolean isFieldReadOnly(String fieldName) {
        return this.readOnlyFields.contains(fieldName);
    }

    public FieldType getFieldType(String fieldName) {
        return this.fieldMap.get(fieldName);
    }

    public void setInstructions(String field, String instrucString) {
        this.instructionMap.put(field, instrucString);
    }

    public String getInstructions(String field) {
        return this.instructionMap.getProperty(field);
    }

    public int getNumFields() {
        return this.fieldMap.size();
    }

    public List<String> getFields() {
        return this.fieldsInOrder;
    }

    public List<String> getReadOnlyFields() {
        return new ArrayList<String>(this.readOnlyFields);
    }

    public List<String> getWritableFields() {
        ArrayList<String> writableFields = new ArrayList<String>(this.fieldsInOrder.size());
        for (int i = 0; i < this.fieldsInOrder.size(); ++i) {
            String field = this.fieldsInOrder.get(i);
            if (this.readOnlyFields.contains(field)) continue;
            writableFields.add(field);
        }
        return writableFields;
    }

    public void setObjectProperty(Object obj, String field, Object value) {
        if (!this.objectBelongs(obj)) {
            throw new IllegalArgumentException("Object does not belong to template " + this.getName() + ": " + obj);
        }
        String beanField = this.propMap.getProperty(field);
        try {
            org.apache.commons.beanutils.PropertyUtils.setProperty((Object)obj, (String)beanField, (Object)value);
        }
        catch (NoSuchMethodException ex) {
            String fieldName = field.trim();
            if (fieldName.contains(" ")) {
                fieldName = fieldName.replace(" ", "");
            }
            try {
                OrderMateLog.LOG.info("Bean utils could not find property, using reflection :" + obj + " " + fieldName);
                Method readMethod = obj.getClass().getMethod("get" + fieldName, new Class[0]);
                Method writeMethod = obj.getClass().getMethod("set" + fieldName, readMethod.getReturnType());
                writeMethod.invoke(obj, value);
            }
            catch (Exception e) {
                this.exceptionLog.add(ex);
                OrderMateLog.LOG.error("Error setting property " + field + " to value " + value, (Throwable)e);
            }
        }
        catch (Exception e) {
            this.exceptionLog.add(e);
            OrderMateLog.LOG.error("Error setting property " + field + " to value " + value, (Throwable)e);
        }
    }

    public Object getObjectProperty(Object obj, String field) {
        if (!this.objectBelongs(obj)) {
            throw new IllegalArgumentException("Object does not belong to template " + this.getName() + ": " + obj);
        }
        String beanField = this.propMap.getProperty(field);
        try {
            Object retval = PropertyUtils.getProperty((Object)obj, (String)beanField);
            return retval;
        }
        catch (Exception e) {
            this.exceptionLog.add(e);
            OrderMateLog.LOG.error("error getting object property " + field + " for " + this.getName(), (Throwable)e);
            return null;
        }
    }

    public void resetExceptionLog() {
        this.exceptionLog.clear();
    }

    public List getExceptionLog() {
        return this.exceptionLog;
    }

    public String toString() {
        return this.getName();
    }

    public void setSeparator(String field, String separatorTitle) {
        if (!this.fieldMap.containsKey(field)) {
            OrderMateLog.LOG.error("You are adding a separator to the field [" + field + "] that doesn't exist.");
        } else {
            this.separators.put(field, separatorTitle);
        }
    }

    public void setSeparator(PropertiedObject.Property field, String separatorTitle) {
        this.setSeparator(field.getUserVisibleLabel(), separatorTitle);
    }

    public String getSeparator(String fieldName) {
        return this.separators.get(fieldName);
    }

    public List getObjectList() {
        return this.getManager().getObjectList(this.getObjectJavaClass());
    }
}

