/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.util.Assert;
import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;

public class SingleObjectSelectorPanel
extends ObjectSelectorPanel {
    private boolean init = false;
    private ObjectTemplate objTemplate;
    private JTextField textField;
    private Object theObject;

    @Override
    public void init(ObjectTemplate objTempl, boolean allowsNull) {
        Assert.isTrue((!this.init ? 1 : 0) != 0, (String)"ObjectSelectorPanel has already been initialised, cannot run init()");
        this.init = true;
        this.objTemplate = objTempl;
        this.updateView();
    }

    @Override
    public void updateView() {
        if (this.textField != null) {
            this.remove(this.textField);
        }
        this.textField = new JTextField();
        this.textField.setEditable(false);
        this.textField.setBackground(Color.WHITE);
        this.textField.setColumns(15);
        List objects = this.objTemplate.getManager().getObjectList(this.objTemplate.getObjectJavaClass());
        if (objects.isEmpty()) {
            this.textField.setText("");
        } else if (objects.size() == 1) {
            this.textField.setText(this.theObject.toString());
        } else {
            throw new IllegalStateException("Use DefaultObjectSelectorPanel for a list of objects");
        }
        this.add(this.textField);
    }

    @Override
    public Object getSelectedObject() {
        return this.theObject;
    }

    @Override
    public Class getExpectedJavaClass() {
        return this.objTemplate.getObjectJavaClass();
    }

    @Override
    public boolean setSelectedObject(Object toSelect) {
        this.theObject = toSelect;
        if (this.theObject == null) {
            this.textField.setText("");
            return true;
        }
        this.textField.setText(this.theObject.toString());
        return true;
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.textField;
    }
}

