/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.guicore.task.GUIStateIUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import officemate.adminkit.GUIStateTemplate;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.VisibleGUIStateFilter;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.GUIState;
import officemate.adminkit.state.RestrictedGUIState;
import officemate.adminkit.tree.DefaultObjectTree;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class StateTree
extends DefaultObjectTree {
    public final Signal stateSelected = Signals.createSignal(GUIStateI.class, (String)"selectedState");
    public final Signal stateDenied = Signals.createSignal(GUIStateI.class, (String)"deniedState");
    public static final Color ENABLED_COLOR_SELECTED = Color.white;
    public static final Color ENABLED_COLOR = Color.black;
    public static final Color DISABLED_COLOR = Color.gray;
    private DefaultTreeStatus baseStatus = DefaultTreeStatus.CollapseToRoots;
    private boolean collapsePressed = false;

    public StateTree(List rootStates) {
        super(rootStates, (ObjectTemplate)GUIStateTemplate.instance, new VisibleGUIStateFilter());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.objectSelected.connect((Object)this, "gotObjectSelected");
        this.setCellRenderer(new CellRenderer());
        this.setExpandsSelectedPaths(false);
        this.setupListeners();
    }

    private void setupListeners() {
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                StateTree.this.gotObjectSelected(StateTree.this.getSelectedObject());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                StateTree.this.collapsePressed = true;
            }
        });
        for (TreeSelectionListener listener : this.getTreeSelectionListeners()) {
            this.removeTreeSelectionListener(listener);
        }
        this.addTreeSelectionListener(new StateInnerTreeListener());
    }

    public void initToDefaultState() {
        int i;
        int count = this.getRowCount();
        for (i = count - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
        if (DefaultTreeStatus.CollapseToChildren.equals((Object)this.baseStatus)) {
            count = this.getRowCount();
            for (i = count - 1; i > 0; --i) {
                this.expandRow(i);
            }
        } else {
            this.expandRow(0);
        }
    }

    void gotObjectSelected(Object obj) {
        if (obj instanceof GUIStateI) {
            if (!((GUIStateI)obj).isSelectionAllowed()) {
                this.stateDenied.emit(obj);
            } else {
                this.stateSelected.emit(obj);
            }
        }
    }

    @Override
    public boolean setSelectedObject(Object obj) {
        DefaultTreeModel model = this.getModel();
        Object[] path = this.search((TreeNode)model.getRoot(), obj);
        if (path != null) {
            TreePath treePath = new TreePath(path);
            if (this.hasNoChildren(obj) || this.getExpandsSelectedPaths()) {
                this.scrollPathToVisible(treePath);
            }
            this.setSelectionPath(treePath);
        }
        return path != null;
    }

    private boolean hasNoChildren(Object obj) {
        if (obj instanceof GUIStateI) {
            return ((GUIStateI)obj).getNumSubStates() <= 0;
        }
        return false;
    }

    public void setDefaultState(DefaultTreeStatus status) {
        if (status != null) {
            this.baseStatus = status;
        }
    }

    private static class CellRenderer
    extends DefaultTreeCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasUserFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasUserFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObj = node.getUserObject();
            if (userObj instanceof GUIStateI) {
                GUIStateI state = (GUIStateI)userObj;
                this.setToolTipText(state.getDescription());
                if (!state.isSelectionAllowed()) {
                    RestrictedGUIState restrictedState = (RestrictedGUIState)state;
                    String access = restrictedState.getAccessLevel();
                    if (access.equals("DISABLED")) {
                        this.setEnabled(false);
                        this.setForeground(DISABLED_COLOR);
                        this.setBackground(Color.white);
                    }
                } else {
                    this.setForeground(isSelected ? ENABLED_COLOR_SELECTED : ENABLED_COLOR);
                }
                if (state instanceof BasicOfficeMateState) {
                    BasicOfficeMateState adminState = (BasicOfficeMateState)state;
                    this.setIcon(adminState.getSmallIcon());
                }
            }
            return this;
        }
    }

    private class StateInnerTreeListener
    implements TreeSelectionListener {
        GUIStateI prev = null;

        private StateInnerTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath newPath = e.getNewLeadSelectionPath();
            if (newPath != null && !StateTree.this.collapsePressed) {
                Object obj = newPath.getLastPathComponent();
                if (obj instanceof DefaultMutableTreeNode) {
                    obj = ((DefaultMutableTreeNode)obj).getUserObject();
                }
                if (obj instanceof GUIStateI) {
                    GUIStateI commonParent;
                    if (GUIStateIUtils.checkIsChildOf((GUIStateI)((GUIStateI)obj), (GUIStateI)this.prev)) {
                        return;
                    }
                    if (this.prev != null && this.prev.getParentState() != null && !GUIStateIUtils.parentHasChild((GUIStateI)this.prev.getParentState(), (GUIStateI)((GUIStateI)obj)) && (commonParent = GUIStateIUtils.getCommonParent((GUIStateI)this.prev.getParentState(), (GUIStateI)((GUIStateI)obj))) != null) {
                        this.resetUpUntil((GUIState)this.prev.getParentState(), commonParent);
                    }
                }
                this.prev = (GUIStateI)obj;
                StateTree.this.objectSelected.emit(obj);
            }
            StateTree.this.collapsePressed = false;
        }

        private void resetUpUntil(GUIState guiState, GUIStateI commonParent) {
            GUIState nextState = guiState;
            while (!nextState.equals(commonParent)) {
                nextState.resetActiveSubStates();
                nextState = (GUIState)nextState.getParentState();
            }
        }
    }

    public static enum DefaultTreeStatus {
        CollapseToChildren,
        CollapseToRoots;

    }
}

