/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.columnformats;

import au.com.ordermate.util.Price;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.cellrenderers.CurrencyColumnRenderer;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesOption;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;

public class SalesItemColumnFormat
extends ColumnTableFormat {
    private static final int ICON_TEXT_GAP = 10;
    private static final String COLUMN_HEADER_LABEL = "Label";
    private static final String COLUMN_HEADER_QUANTITY = "Quantity";
    private static final String COLUMN_HEADER_EACH = "Each";
    private static final String COLUMN_HEADER_TOTAL = "Total";
    private static final String CURRENCY_COLUMN_FORMAT = "##,##,###.00";

    private Object getQuantity(Object baseObject) {
        if (baseObject instanceof SalesLineItem) {
            return ((SalesLineItem)baseObject).getQuantity();
        }
        return "";
    }

    private Object getLabel(Object baseObject) {
        if (baseObject instanceof SalesLineItem) {
            return ((SalesLineItem)baseObject).getLabel();
        }
        if (baseObject instanceof SalesOption) {
            SalesOption salesOption = (SalesOption)baseObject;
            return "       " + salesOption.getOption().getLabel();
        }
        if (baseObject instanceof SalesAdd) {
            SalesAdd salesAdd = (SalesAdd)baseObject;
            return "+    " + salesAdd.getLabel();
        }
        if (baseObject instanceof AbstractSalesRemove) {
            AbstractSalesRemove abstractSalesRemove = (AbstractSalesRemove)baseObject;
            return " -    " + abstractSalesRemove.getLabel();
        }
        return "";
    }

    private Object getEach(Object baseObject) {
        if (baseObject instanceof SalesLineItem) {
            return ((SalesLineItem)baseObject).getPricePerItem();
        }
        return "";
    }

    private Object getTotal(Object baseObject) {
        if (baseObject instanceof SalesLineItem) {
            return ((SalesLineItem)baseObject).getPrice();
        }
        return "";
    }

    public SalesItemColumnFormat() {
        AbstractColumnFormat quanityColumn = new AbstractColumnFormat(COLUMN_HEADER_QUANTITY, Integer.class){

            public Object resolveColumnValue(Object baseObject) {
                return SalesItemColumnFormat.this.getQuantity(baseObject);
            }
        };
        this.addColumn((ColumnFormat)quanityColumn);
        AbstractColumnFormat labelColum = new AbstractColumnFormat(COLUMN_HEADER_LABEL, String.class){

            public Object resolveColumnValue(Object baseObject) {
                return SalesItemColumnFormat.this.getLabel(baseObject);
            }
        };
        labelColum.setCustomRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (comp instanceof JLabel) {
                    JLabel component = (JLabel)comp;
                    if (value instanceof SalesAdd) {
                        SalesAdd salesAdd = (SalesAdd)value;
                        component.setIconTextGap(10);
                        component.setText(salesAdd.getLabel());
                    } else if (value instanceof AbstractSalesRemove) {
                        AbstractSalesRemove abstractSalesRemove = (AbstractSalesRemove)value;
                        component.setIconTextGap(10);
                        component.setText(abstractSalesRemove.getLabel());
                    } else {
                        component.setText(value.toString());
                    }
                }
                return comp;
            }
        });
        this.addColumn((ColumnFormat)labelColum);
        AbstractColumnFormat eachColum = new AbstractColumnFormat(COLUMN_HEADER_EACH, Price.class){

            public Object resolveColumnValue(Object baseObject) {
                return SalesItemColumnFormat.this.getEach(baseObject);
            }
        };
        eachColum.setFormatter((Format)new DecimalFormat(CURRENCY_COLUMN_FORMAT));
        eachColum.setCustomRenderer((TableCellRenderer)new CurrencyColumnRenderer());
        this.addColumn((ColumnFormat)eachColum);
        AbstractColumnFormat totalColumn = new AbstractColumnFormat(COLUMN_HEADER_TOTAL, Price.class){

            public Object resolveColumnValue(Object baseObject) {
                return SalesItemColumnFormat.this.getTotal(baseObject);
            }
        };
        totalColumn.setFormatter((Format)new DecimalFormat(CURRENCY_COLUMN_FORMAT));
        totalColumn.setCustomRenderer((TableCellRenderer)new CurrencyColumnRenderer());
        this.addColumn((ColumnFormat)totalColumn);
    }
}

