/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.dialogs;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AdminDialog
extends JDialog
implements ActionListener {
    private NavBar navBar;
    private Component mainComponent = new JPanel();
    private boolean okResponse;

    public AdminDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.navBar = new NavBar();
        this.navBar.getOk().setToolTipText("Ok");
        this.navBar.getCancel().setToolTipText("Cancel");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.navBar, "South");
        contentPane.add(this.mainComponent, "North");
        this.navBar.getOk().addActionListener(this);
        this.navBar.getCancel().addActionListener(this);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public void setOkVisible(boolean visible) {
        this.navBar.getOk().setVisible(visible);
    }

    public void setOkToolTipText(String tip) {
        this.navBar.getOk().setToolTipText(tip);
    }

    public void setCancelVisible(boolean visible) {
        this.navBar.getCancel().setVisible(visible);
    }

    public void setMainComponent(Component main) {
        if (this.mainComponent != null) {
            this.getContentPane().remove(this.mainComponent);
        }
        this.mainComponent = main;
        this.getContentPane().add(this.mainComponent, "Center");
    }

    public void setNavBar(Component navBarComp) {
        this.getContentPane().remove(this.navBar);
        this.getContentPane().add(navBarComp, "South");
        this.validate();
        this.repaint();
    }

    public boolean start() {
        this.okResponse = false;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        return this.okResponse;
    }

    protected void gotOk() {
        this.okResponse = true;
        this.dispose();
    }

    protected void gotCancel() {
        this.okResponse = false;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.navBar.getCancel()) {
            this.gotCancel();
        } else if (e.getSource() == this.navBar.getOk()) {
            this.gotOk();
        }
    }

    private static class NavBar
    extends JPanel {
        private JButton okButton = new JButton(IconLoader.get((String)"/ordermate/images/button_ok.png"));
        private JButton cancelButton = new JButton(IconLoader.get((String)"/ordermate/images/button_cancel.png"));

        public NavBar() {
            this.setLayout(new FlowLayout(2, 0, 0));
            this.add(this.okButton);
            this.add(this.cancelButton);
        }

        public JButton getOk() {
            return this.okButton;
        }

        public JButton getCancel() {
            return this.cancelButton;
        }
    }
}

