/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.FieldPanelInterface;
import officemate.adminkit.types.FieldType;
import ordermate.gui.BorderUtils;

public class EditFieldDialog
extends JDialog {
    private static JFrame parentFrame = null;
    private boolean okPressed = false;
    private JButton okButton;
    private JButton cancelButton;
    private Object storedValue = null;
    private FieldPanelInterface fieldPanel;
    private FieldType fieldType;
    private final ImageIcon OK_ICON = new ImageIcon(ObjectEditorDialog.class.getResource("/ordermate/images/button_ok.png"));
    private final ImageIcon CANCEL_ICON = new ImageIcon(ObjectEditorDialog.class.getResource("/ordermate/images/button_cancel.png"));

    public EditFieldDialog(FieldPanel theFieldPanel) {
        this(theFieldPanel, null);
    }

    public EditFieldDialog(FieldPanel theFieldPanel, Object value) {
        this(theFieldPanel, value, (FieldType)theFieldPanel.getFieldType());
    }

    public EditFieldDialog(FieldPanelInterface theFieldPanel, Object value, FieldType type) {
        super((Frame)parentFrame, true);
        this.fieldPanel = theFieldPanel;
        this.storedValue = value;
        String titleWord = value == null ? "Add " : "Edit ";
        this.setTitle(titleWord + "...");
        this.fieldType = type;
        if (this.storedValue == null) {
            this.storedValue = this.fieldType.getDefaultInitValue();
        }
        this.okButton = new JButton(this.OK_ICON);
        this.okButton.setToolTipText("OK");
        this.cancelButton = new JButton(this.CANCEL_ICON);
        this.cancelButton.setToolTipText("Cancel");
        JComponent contentPane = (JComponent)this.getContentPane();
        BorderUtils.addEmptyBorder((JComponent)contentPane);
        contentPane.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JPanel buttonPanel2 = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel2.setLayout(new GridLayout(1, 2));
        buttonPanel2.add(this.okButton);
        buttonPanel2.add(this.cancelButton);
        buttonPanel.add((Component)buttonPanel2, "East");
        contentPane.add((Component)buttonPanel, "South");
        contentPane.add((Component)this.fieldPanel.getGuiComponent(), "Center");
        this.fieldPanel.getOkSignal().connect((Object)this, "onOK");
        this.fieldPanel.getCancelSignal().connect((Object)this, "onCancel");
        InnerListener li = new InnerListener();
        this.okButton.addActionListener(li);
        this.cancelButton.addActionListener(li);
        this.okButton.addKeyListener(li);
        this.cancelButton.addKeyListener(li);
        this.fieldPanel.getGuiComponent().addKeyListener(li);
        this.setResizable(true);
        if (parentFrame != null) {
            this.setLocationRelativeTo(parentFrame);
        }
        this.pack();
    }

    public static void setParentFrame(JFrame frame) {
        parentFrame = frame;
    }

    public static JFrame getParentFrame() {
        return parentFrame;
    }

    public boolean wasOKed() {
        return this.okPressed;
    }

    public Object getValue() {
        return this.storedValue;
    }

    private void onOK() {
        Object val = this.fieldPanel.getValue();
        if (this.fieldType.isValidValue(val)) {
            this.storedValue = this.fieldPanel.getValue();
            this.okPressed = true;
            this.dispose();
        } else {
            Dialogs.showErrorDialog("Invalid value", "This value has not been set up correctly! \nEither correct it or cancel.");
        }
    }

    private void onCancel() {
        this.storedValue = null;
        this.dispose();
    }

    private class InnerListener
    implements ActionListener,
    KeyListener {
        private InnerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == EditFieldDialog.this.okButton) {
                EditFieldDialog.this.onOK();
            } else if (source == EditFieldDialog.this.cancelButton) {
                EditFieldDialog.this.onCancel();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            Object source = e.getSource();
            if (source == EditFieldDialog.this.okButton || source == EditFieldDialog.this.fieldPanel) {
                EditFieldDialog.this.onOK();
            } else if (source == EditFieldDialog.this.cancelButton) {
                EditFieldDialog.this.onCancel();
            }
        }
    }
}

