/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.dialogs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class LinkLabel
extends JTextField
implements MouseListener,
FocusListener,
ActionListener {
    private final URI target;
    private final Signal linkClicked = Signals.createSignal();
    private Color standardColor = new Color(47, 73, 192);
    private Color hoverColor = new Color(57, 177, 255);
    private Color activeColor = new Color(128, 0, 118);
    private final Color transparent = new Color(0, 0, 0, 0);
    private Border activeBorder;
    private Border hoverBorder;
    private Border standardBorder;
    private boolean underlineVisible;

    public LinkLabel(URI target, String text) {
        super(text);
        this.target = target;
    }

    public void setActiveColor(Color active) {
        this.activeColor = active;
    }

    public void setHoverColor(Color hover) {
        this.hoverColor = hover;
    }

    public void setStandardColor(Color standard) {
        this.standardColor = standard;
    }

    public void setUnderlineVisible(boolean underlineVisible) {
        this.underlineVisible = underlineVisible;
    }

    public void initializeSettings() {
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addActionListener(this);
        this.setToolTipText(this.target.toString());
        if (this.underlineVisible) {
            this.activeBorder = new MatteBorder(0, 0, 1, 0, this.activeColor);
            this.hoverBorder = new MatteBorder(0, 0, 1, 0, this.hoverColor);
            this.standardBorder = new MatteBorder(0, 0, 1, 0, this.transparent);
        } else {
            this.activeBorder = new MatteBorder(0, 0, 0, 0, this.activeColor);
            this.hoverBorder = new MatteBorder(0, 0, 0, 0, this.hoverColor);
            this.standardBorder = new MatteBorder(0, 0, 0, 0, this.transparent);
        }
        this.setEditable(false);
        this.useStandardSettings();
        this.setCursor(new Cursor(12));
    }

    private void browse() {
        this.useActiveSettings();
        try {
            Desktop.getDesktop().browse(this.target);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Unable to browse target URI " + this.target);
        }
        this.useStandardSettings();
        this.linkClicked.emit();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.browse();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.browse();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.useHoverSettings();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.useStandardSettings();
    }

    @Override
    public void focusLost(FocusEvent fe) {
        this.useStandardSettings();
    }

    @Override
    public void focusGained(FocusEvent fe) {
        this.useHoverSettings();
    }

    private void useStandardSettings() {
        this.setForeground(this.standardColor);
        this.setBorder(this.standardBorder);
    }

    private void useHoverSettings() {
        this.setForeground(this.hoverColor);
        this.setBorder(this.hoverBorder);
    }

    private void useActiveSettings() {
        this.setForeground(this.activeColor);
        this.setBorder(this.activeBorder);
    }

    public Signal getLinkClicked() {
        return this.linkClicked;
    }
}

