/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.dialogs;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import officemate.adminkit.AbstractObjectEditorPanel;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import ordermate.gui.BorderUtils;

public class ObjectEditorDialog
extends JDialog {
    public static final int MIN_WIDTH = 300;
    public static final int MAX_WIDTH = Config.isDebuging() ? 750 : Toolkit.getDefaultToolkit().getScreenSize().width - 100;
    public static final int MIN_HEIGHT = 200;
    public static final int MAX_HEIGHT = Config.isDebuging() ? 630 : Toolkit.getDefaultToolkit().getScreenSize().height - 100;
    public static final int RESULT_OK = 0;
    public static final int RESULT_CANCEL = 1;
    public static final int RESULT_CLOSE = 2;
    private final ImageIcon OK_ICON = IconLoader.get((String)"/ordermate/images/button_ok.png");
    private final ImageIcon ADD_ICON = IconLoader.get((String)"/ordermate/images/button_add.png");
    private final ImageIcon CANCEL_ICON = IconLoader.get((String)"/ordermate/images/button_cancel.png");
    private final ImageIcon CLOSE_ICON = IconLoader.get((String)"/ordermate/images/button_ok.png");
    private int result;
    private ObjectEditorPanel editorView;
    private JButton okButton;
    private JButton cancelButton;
    private JButton closeButton;
    private Color okFocusColor = AbstractObjectEditorPanel.HIGHLIGHT_COLOR;
    private Color cancelFocusColor = AbstractObjectEditorPanel.HIGHLIGHT_COLOR;
    private Color normalButtonColor;

    public ObjectEditorDialog(JFrame parentFrame, ObjectEditorPanel editorPanel, boolean useAdd, Dimension defaultSize) {
        super((Frame)parentFrame, true);
        JPanel buttonPanel;
        this.editorView = editorPanel;
        Object object = this.editorView.getEditedObject();
        boolean isNew = this.editorView.isNewObject();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ObjectEditorDialog.this.editorView.getDialogMode() == 0) {
                    if (ObjectEditorDialog.this.editorView.requestCancelAllowed()) {
                        ObjectEditorDialog.this.editorView.cancelObject();
                        ObjectEditorDialog.this.setVisible(false);
                        ObjectEditorDialog.this.dispose();
                    }
                } else if (ObjectEditorDialog.this.editorView.getDialogMode() == 1 && ObjectEditorDialog.this.editorView.requestCloseAllowed()) {
                    ObjectEditorDialog.this.setVisible(false);
                    ObjectEditorDialog.this.dispose();
                }
            }
        });
        if (useAdd) {
            this.okButton = new JButton(this.ADD_ICON);
            this.okButton.setToolTipText("Add");
        } else {
            this.okButton = new JButton(this.OK_ICON);
            this.okButton.setToolTipText("OK");
        }
        this.okButton.setName("OK");
        this.cancelButton = new JButton(this.CANCEL_ICON);
        this.cancelButton.setName("Cancel");
        this.closeButton = new JButton(this.CLOSE_ICON);
        this.closeButton.setName("Close");
        this.cancelButton.setToolTipText("Cancel");
        this.closeButton.setToolTipText("Close");
        ObjectTemplate template = editorPanel.getTemplate();
        String objText = isNew ? "" : " : " + template.getObjectText(object);
        String preText = isNew ? "Create " : "Edit ";
        this.setTitle(preText + template.getName() + objText);
        JPanel southPanel = new JPanel(new BorderLayout());
        InnerActionListener action = new InnerActionListener();
        InnerFocusListener focus = new InnerFocusListener();
        InnerKeyListener key = new InnerKeyListener();
        switch (editorPanel.getDialogMode()) {
            case 0: {
                buttonPanel = new JPanel(new GridLayout(1, 2));
                buttonPanel.add(this.okButton);
                buttonPanel.add(this.cancelButton);
                this.okButton.addActionListener(action);
                this.cancelButton.addActionListener(action);
                this.okButton.addKeyListener(key);
                this.cancelButton.addKeyListener(key);
                this.okButton.addFocusListener(focus);
                this.cancelButton.addFocusListener(focus);
                editorPanel.okKeyPressed.connect((Object)this, "doSaveAndExitChecked");
                editorPanel.cancelKeyPressed.connect((Object)this, "doCancelAndExitChecked");
                this.result = 1;
                break;
            }
            case 1: {
                buttonPanel = new JPanel(new GridLayout(1, 1));
                buttonPanel.add(this.closeButton);
                this.closeButton.addActionListener(action);
                this.closeButton.addKeyListener(key);
                this.closeButton.addFocusListener(focus);
                editorPanel.okKeyPressed.connect((Object)this, "doCloseAndExitChecked");
                editorPanel.cancelKeyPressed.connect((Object)this, "doCloseAndExitChecked");
                this.result = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObjectEditorDialog mode: " + editorPanel.getDialogMode());
            }
        }
        this.normalButtonColor = this.okButton.getBackground();
        southPanel.add((Component)buttonPanel, "East");
        JPanel pane = new JPanel(new BorderLayout());
        pane.setLayout(new BorderLayout());
        pane.add((Component)southPanel, "South");
        pane.add((Component)this.editorView, "Center");
        BorderUtils.addEmptyBorder((JComponent)pane);
        this.setContentPane(pane);
        this.pack();
        int frameWidth = this.getPreferredSize().width;
        int frameHeight = this.getPreferredSize().height;
        if (defaultSize == null) {
            if (frameWidth > MAX_WIDTH) {
                frameWidth = MAX_WIDTH;
            } else if (frameWidth < 300) {
                frameWidth = 300;
            }
            if (frameHeight > MAX_HEIGHT) {
                frameHeight = MAX_HEIGHT;
            } else if (frameHeight < 200) {
                frameHeight = 200;
            }
            this.setPreferredSize(new Dimension(frameWidth, frameHeight));
        } else {
            if (frameWidth > defaultSize.width) {
                defaultSize.width = frameWidth;
            }
            if (frameHeight > defaultSize.height) {
                defaultSize.height = frameHeight;
            }
            this.setPreferredSize(defaultSize);
        }
        this.validate();
        this.repaint();
    }

    public boolean wasOKed() {
        return this.result == 0;
    }

    public boolean wasCancelled() {
        return this.result == 1;
    }

    public boolean wasClosed() {
        return this.result == 2;
    }

    public int getDialogResult() {
        return this.result;
    }

    void gotCancelAndExitRequest() {
        this.doCancelAndExit();
    }

    void gotSaveAndExitRequest() {
        this.doSaveAndExit();
    }

    private void doCloseAndExit() {
        this.result = 2;
        this.dispose();
    }

    private void doSaveAndExit() {
        this.result = 0;
        this.dispose();
    }

    private void doCancelAndExit() {
        this.result = 1;
        this.dispose();
    }

    private void doCancelAndExitChecked() {
        if (this.editorView.requestCancelAllowed()) {
            this.doCancelAndExit();
        }
    }

    private void doSaveAndExitChecked() {
        if (this.editorView.requestSaveAllowed()) {
            this.doSaveAndExit();
        }
    }

    private void doCloseAndExitChecked() {
        if (this.editorView.requestCloseAllowed()) {
            this.doCloseAndExit();
        }
    }

    public Object getEditedObject() {
        return this.editorView.getEditedObject();
    }

    public static int doDialog(JFrame parent, ObjectEditorPanel editorPanel, String title, boolean useAdd, Dimension defaultSize) {
        ObjectEditorDialog dialog = new ObjectEditorDialog(parent, editorPanel, useAdd, defaultSize);
        if (title != null) {
            dialog.setTitle(title);
        }
        if (parent != null) {
            dialog.setLocationRelativeTo(parent);
        } else {
            dialog.setLocation(100, 100);
        }
        dialog.pack();
        dialog.setVisible(true);
        return dialog.result;
    }

    public static int doDialog(JFrame parent, ObjectEditorPanel editorPanel) {
        return ObjectEditorDialog.doDialog(parent, editorPanel, null, false, null);
    }

    public static int doDialog(JFrame parent, ObjectEditorPanel editorPanel, boolean useAdd) {
        return ObjectEditorDialog.doDialog(parent, editorPanel, null, useAdd, null);
    }

    public static int doDialog(JFrame parent, ObjectEditorPanel editorPanel, Dimension defaultSize) {
        return ObjectEditorDialog.doDialog(parent, editorPanel, null, false, defaultSize);
    }

    public static int doDialog(JFrame parent, ObjectEditorPanel editorPanel, String title, boolean useAdd) {
        return ObjectEditorDialog.doDialog(parent, editorPanel, title, useAdd, null);
    }

    public static int doDialog(JFrame parent, ObjectEditorPanel editorPanel, int screenX, int screenY) {
        ObjectEditorDialog dialog = new ObjectEditorDialog(parent, editorPanel, false, null);
        if (parent != null) {
            dialog.setLocationRelativeTo(parent);
        }
        dialog.setLocation(screenX, screenY);
        dialog.pack();
        dialog.setVisible(true);
        return dialog.result;
    }

    private class InnerKeyListener
    extends KeyAdapter {
        private InnerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source = e.getSource();
            if (e.getKeyCode() == 10) {
                if (source == ObjectEditorDialog.this.okButton) {
                    ObjectEditorDialog.this.doSaveAndExitChecked();
                } else if (source == ObjectEditorDialog.this.cancelButton) {
                    ObjectEditorDialog.this.doCancelAndExitChecked();
                } else if (source == ObjectEditorDialog.this.closeButton) {
                    ObjectEditorDialog.this.doSaveAndExitChecked();
                }
            } else if (e.getKeyCode() == 27) {
                ObjectEditorDialog.this.doCancelAndExitChecked();
            }
        }
    }

    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ObjectEditorDialog.this.okButton) {
                ObjectEditorDialog.this.doSaveAndExitChecked();
            } else if (source == ObjectEditorDialog.this.cancelButton) {
                ObjectEditorDialog.this.doCancelAndExitChecked();
            } else if (source == ObjectEditorDialog.this.closeButton) {
                ObjectEditorDialog.this.doCloseAndExitChecked();
            }
        }
    }

    private class InnerFocusListener
    implements FocusListener {
        private InnerFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object source = e.getSource();
            if (source == ObjectEditorDialog.this.okButton) {
                ObjectEditorDialog.this.okButton.setBackground(ObjectEditorDialog.this.okFocusColor);
            } else if (source == ObjectEditorDialog.this.cancelButton) {
                ObjectEditorDialog.this.cancelButton.setBackground(ObjectEditorDialog.this.cancelFocusColor);
            } else if (source == ObjectEditorDialog.this.closeButton) {
                ObjectEditorDialog.this.cancelButton.setBackground(ObjectEditorDialog.this.cancelFocusColor);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == ObjectEditorDialog.this.okButton) {
                ObjectEditorDialog.this.okButton.setBackground(ObjectEditorDialog.this.normalButtonColor);
            } else if (source == ObjectEditorDialog.this.cancelButton) {
                ObjectEditorDialog.this.cancelButton.setBackground(ObjectEditorDialog.this.normalButtonColor);
            } else if (source == ObjectEditorDialog.this.closeButton) {
                ObjectEditorDialog.this.cancelButton.setBackground(ObjectEditorDialog.this.normalButtonColor);
            }
        }
    }
}

